/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.Collections;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PreferenceManagerTest {
    @Mock
    private IMavenConfiguration mavenConfig;
    private PreferenceManager preferenceManager;

    @Before
    public void setUp() {
        this.preferenceManager = new PreferenceManager();
        this.preferenceManager.setMavenConfiguration(this.mavenConfig);
    }

    @Test
    public void testUpdateMavenSettings() throws Exception {
        String path = "/foo/bar.xml";
        Preferences preferences = Preferences.createFrom(Collections.singletonMap("java.configuration.maven.userSettings", path));
        this.preferenceManager.update(preferences);
        ((IMavenConfiguration)Mockito.verify((Object)this.mavenConfig)).setUserSettingsFile(path);
        Mockito.reset((Object[])new IMavenConfiguration[]{this.mavenConfig});
        Mockito.when((Object)this.mavenConfig.getUserSettingsFile()).thenReturn((Object)path);
        this.preferenceManager.update(preferences);
        ((IMavenConfiguration)Mockito.verify((Object)this.mavenConfig, (VerificationMode)Mockito.never())).setUserSettingsFile(Matchers.anyString());
        Mockito.reset((Object[])new IMavenConfiguration[]{this.mavenConfig});
        Mockito.when((Object)this.mavenConfig.getUserSettingsFile()).thenReturn((Object)path);
        preferences.setMavenUserSettings(null);
        this.preferenceManager.update(preferences);
        ((IMavenConfiguration)Mockito.verify((Object)this.mavenConfig)).setUserSettingsFile(null);
    }

    @Test
    public void testInitialize() throws Exception {
        this.preferenceManager.initialize();
        Assert.assertEquals((Object)"enabled", JavaCore.getOptions().get("org.eclipse.jdt.core.codeComplete.visibilityCheck"));
    }

    @Test
    public void testPreferencesChangeListener() throws Exception {
        this.preferenceManager.initialize();
        final boolean[] called = new boolean[]{false};
        IPreferencesChangeListener listener = new IPreferencesChangeListener(){

            public void preferencesChange(Preferences oldPreferences, Preferences newPreferences) {
                called[0] = true;
            }
        };
        this.preferenceManager.addPreferencesChangeListener(listener);
        Preferences preferences = new Preferences();
        this.preferenceManager.update(preferences);
        Assert.assertTrue((String)"No one listener has been called", (boolean)called[0]);
        this.preferenceManager.removePreferencesChangeListener(listener);
        called[0] = false;
        preferences = new Preferences();
        this.preferenceManager.update(preferences);
        Assert.assertFalse((String)"A listener has been called", (boolean)called[0]);
    }
}

