/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractMavenBasedTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MavenProjectImporterTest
extends AbstractMavenBasedTest {
    private static final String INVALID = "invalid";
    private static final String MAVEN_INVALID = "maven/invalid";
    private static final String PROJECT1_PATTERN = "**/project1";
    private MavenUpdateProjectJobSpy jobSpy;

    private void attachJobSpy() {
        this.jobSpy = new MavenUpdateProjectJobSpy();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.jobSpy);
    }

    @After
    public void removeJobSpy() {
        if (this.jobSpy != null) {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobSpy);
        }
    }

    @Test
    public void testImportSimpleJavaProject() throws Exception {
        this.attachJobSpy();
        this.importSimpleJavaProject();
        Assert.assertEquals((String)"New Projects should not be updated", (long)0L, (long)this.jobSpy.updateProjectJobCalled);
    }

    @Test
    public void testJavaImportExclusions() throws Exception {
        List javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
        try {
            javaImportExclusions.add(PROJECT1_PATTERN);
            List<IProject> projects = this.importProjects("maven/multi");
            Assert.assertEquals((long)2L, (long)projects.size());
            IProject project1 = WorkspaceHelper.getProject("project1");
            Assert.assertNull((Object)project1);
            IProject project2 = WorkspaceHelper.getProject("project2");
            this.assertIsMavenProject(project2);
        }
        finally {
            javaImportExclusions.remove(PROJECT1_PATTERN);
        }
    }

    @Test
    public void testUnzippedSourceImportExclusions() throws Exception {
        List<IProject> projects = this.importProjects("maven/unzipped-sources");
        Assert.assertEquals(Arrays.asList(this.projectsManager.getDefaultProject()), projects);
    }

    @Test
    public void testDisableMaven() throws Exception {
        boolean enabled = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isImportMavenEnabled();
        try {
            JavaLanguageServerPlugin.getPreferencesManager().getPreferences().setImportMavenEnabled(false);
            List<IProject> projects = this.importProjects("eclipse/eclipsemaven");
            Assert.assertEquals((long)2L, (long)projects.size());
            IProject eclipse = WorkspaceHelper.getProject("eclipse");
            Assert.assertNotNull((Object)eclipse);
            Assert.assertFalse((String)(String.valueOf(eclipse.getName()) + " has the Maven nature"), (boolean)ProjectUtils.isMavenProject((IProject)eclipse));
        }
        finally {
            JavaLanguageServerPlugin.getPreferencesManager().getPreferences().setImportMavenEnabled(enabled);
        }
    }

    @Test
    public void testInvalidProject() throws Exception {
        List<IProject> projects = this.importProjects(MAVEN_INVALID);
        Assert.assertEquals((long)2L, (long)projects.size());
        IProject invalid = WorkspaceHelper.getProject(INVALID);
        this.assertIsMavenProject(invalid);
        IFile projectFile = invalid.getFile("/.project");
        Assert.assertTrue((boolean)projectFile.exists());
        File file = projectFile.getRawLocation().makeAbsolute().toFile();
        invalid.close((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)file.exists());
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        projects = this.importProjects(MAVEN_INVALID);
        Assert.assertEquals((long)2L, (long)projects.size());
        invalid = WorkspaceHelper.getProject(INVALID);
        this.assertIsMavenProject(invalid);
    }

    @Test
    public void testUnchangedProjectShouldNotBeUpdated() throws Exception {
        this.attachJobSpy();
        String name = "salut";
        this.importMavenProject(name);
        Assert.assertEquals((String)"New Project should not be updated", (long)0L, (long)this.jobSpy.updateProjectJobCalled);
        this.importExistingMavenProject(name);
        Assert.assertEquals((String)"Unchanged Project should not be updated", (long)0L, (long)this.jobSpy.updateProjectJobCalled);
    }

    @Test
    public void testChangedProjectShouldBeUpdated() throws Exception {
        this.attachJobSpy();
        String name = "salut";
        IProject salut = this.importMavenProject(name);
        Assert.assertEquals((String)"New Project should not be updated", (long)0L, (long)this.jobSpy.updateProjectJobCalled);
        File pom = salut.getFile("pom.xml").getRawLocation().toFile();
        pom.setLastModified(System.currentTimeMillis() + 1000L);
        this.importExistingMavenProject(name);
        Assert.assertEquals((String)"Changed Project should be updated", (long)1L, (long)this.jobSpy.updateProjectJobCalled);
    }

    @Test
    public void testJava9Project() throws Exception {
        IProject project = this.importMavenProject("salut-java9");
        this.assertIsJavaProject(project);
        Assert.assertEquals((Object)"9", (Object)ProjectUtils.getJavaSourceLevel((IProject)project));
        this.assertNoErrors(project);
    }

    private static class MavenUpdateProjectJobSpy
    extends JobChangeAdapter {
        int updateProjectJobCalled;

        private MavenUpdateProjectJobSpy() {
        }

        public void scheduled(IJobChangeEvent event) {
            String jobName = event.getJob().getName();
            if ("Update Maven project configuration".equals(jobName)) {
                ++this.updateProjectJobCalled;
            }
        }
    }
}

