/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.DocumentAdapter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.SimpleLogListener;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractProjectsManagerBasedTest {
    public static final String TEST_PROJECT_NAME = "TestProject";
    protected IProgressMonitor monitor = new NullProgressMonitor();
    protected ProjectsManager projectsManager;
    @Mock
    protected PreferenceManager preferenceManager;
    protected Preferences preferences;
    protected SimpleLogListener logListener;
    protected Map<String, List<Object>> clientRequests = new HashMap<String, List<Object>>();
    protected JavaClientConnection.JavaLanguageClient client = (JavaClientConnection.JavaLanguageClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{JavaClientConnection.JavaLanguageClient.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args.length == 1) {
                String name = method.getName();
                List<Object> params = AbstractProjectsManagerBasedTest.this.clientRequests.get(name);
                if (params == null) {
                    params = new ArrayList<Object>();
                    AbstractProjectsManagerBasedTest.this.clientRequests.put(name, params);
                }
                params.add(args[0]);
            }
            return null;
        }
    });

    @Before
    public void initProjectManager() throws CoreException {
        this.clientRequests.clear();
        this.logListener = new SimpleLogListener();
        Platform.addLogListener((ILogListener)this.logListener);
        this.preferences = new Preferences();
        if (this.preferenceManager != null) {
            Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)this.preferences);
        }
        this.projectsManager = new ProjectsManager(this.preferenceManager);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.Null;
            }
        });
    }

    protected IJavaProject newEmptyProject() throws Exception {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
        Assert.assertEquals((Object)false, (Object)testProject.exists());
        this.projectsManager.createJavaProject(testProject, (IProgressMonitor)new NullProgressMonitor());
        this.waitForBackgroundJobs();
        return JavaCore.create((IProject)testProject);
    }

    protected IJavaProject newDefaultProject() throws Exception {
        IProject testProject = this.projectsManager.getDefaultProject();
        this.projectsManager.createJavaProject(testProject, (IProgressMonitor)new NullProgressMonitor());
        this.waitForBackgroundJobs();
        return JavaCore.create((IProject)testProject);
    }

    protected IFile linkFilesToDefaultProject(String path) throws Exception {
        IProject testProject = this.projectsManager.getDefaultProject();
        String fullpath = this.copyFiles(path, true).getAbsolutePath().replace('\\', '/');
        String fileName = fullpath.substring(fullpath.lastIndexOf("/") + 1);
        IPath filePath = new Path("src").append(fileName);
        IFile file = testProject.getFile(filePath);
        URI uri = Paths.get(fullpath, new String[0]).toUri();
        JDTUtils.createFolders((IContainer)file.getParent(), (IProgressMonitor)this.monitor);
        this.waitForBackgroundJobs();
        file.createLink(uri, 256, this.monitor);
        this.waitForBackgroundJobs();
        return file;
    }

    protected List<IProject> importProjects(String path) throws Exception {
        return this.importProjects(Collections.singleton(path));
    }

    protected List<IProject> importExistingProjects(String path) throws Exception {
        return this.importProjects(Collections.singleton(path), false);
    }

    protected List<IProject> importProjects(Collection<String> paths) throws Exception {
        return this.importProjects(paths, true);
    }

    protected List<IProject> importProjects(Collection<String> paths, boolean deleteExistingFiles) throws Exception {
        final ArrayList<IPath> roots = new ArrayList<IPath>();
        for (String path : paths) {
            File file = this.copyFiles(path, deleteExistingFiles);
            roots.add(Path.fromOSString((String)file.getAbsolutePath()));
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AbstractProjectsManagerBasedTest.this.projectsManager.initializeProjects((Collection)roots, monitor);
            }
        };
        JavaCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)this.monitor);
        this.waitForBackgroundJobs();
        return WorkspaceHelper.getAllProjects();
    }

    protected void waitForBackgroundJobs() throws Exception {
        JobHelpers.waitForJobsToComplete((IProgressMonitor)this.monitor);
    }

    protected File getSourceProjectDirectory() {
        return new File("projects");
    }

    protected File getWorkingProjectDirectory() throws IOException {
        File dir = new File("target", "workingProjects");
        FileUtils.forceMkdir((File)dir);
        return dir;
    }

    @After
    public void cleanUp() throws Exception {
        this.projectsManager = null;
        Platform.removeLogListener((ILogListener)this.logListener);
        this.logListener = null;
        WorkspaceHelper.deleteAllProjects();
        FileUtils.forceDelete((File)this.getWorkingProjectDirectory());
    }

    protected void assertIsJavaProject(IProject project) {
        Assert.assertNotNull((Object)project);
        Assert.assertTrue((String)(String.valueOf(project.getName()) + " is missing the Java nature"), (boolean)ProjectUtils.isJavaProject((IProject)project));
    }

    protected void assertHasErrors(IProject project) {
        try {
            Assert.assertTrue((String)(String.valueOf(project.getName()) + " has no errors"), (ResourceUtils.getErrorMarkers((IResource)project).size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertNoErrors(IProject project) {
        try {
            List markers = ResourceUtils.getErrorMarkers((IResource)project);
            Assert.assertEquals((String)(String.valueOf(project.getName()) + " has errors: \n" + ResourceUtils.toString((List)markers)), (long)0L, (long)markers.size());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected File copyFiles(String path, boolean reimportIfExists) throws IOException {
        File from = new File(this.getSourceProjectDirectory(), path);
        File to = new File(this.getWorkingProjectDirectory(), path);
        if (to.exists()) {
            if (!reimportIfExists) {
                return to;
            }
            FileUtils.forceDelete((File)to);
        }
        if (from.isDirectory()) {
            FileUtils.copyDirectory((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        return to;
    }
}

