/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ClassFileUtil;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class NavigateToDefinitionHandlerTest
extends AbstractProjectsManagerBasedTest {
    private NavigateToDefinitionHandler handler;
    private IProject project;
    private PreferenceManager preferenceManager;

    @Before
    public void setUp() throws Exception {
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)new Preferences());
        this.handler = new NavigateToDefinitionHandler(this.preferenceManager);
        this.importProjects("maven/salut");
        this.project = WorkspaceHelper.getProject("salut");
    }

    @Test
    public void testGetEmptyDefinition() throws Exception {
        List definitions = this.handler.definition(new TextDocumentPositionParams(new TextDocumentIdentifier("/foo/bar"), new Position(1, 1)), this.monitor);
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)1L, (long)definitions.size());
        Assert.assertNotNull((String)"Location has no Range", (Object)((Location)definitions.get(0)).getRange());
    }

    @Test
    public void testAttachedSource() throws Exception {
        this.testClass("org.apache.commons.lang3.StringUtils", 20, 26);
    }

    @Test
    public void testDisassembledSource() throws Exception {
        this.testClass("javax.tools.Tool", 6, 44);
    }

    private void testClass(String className, int line, int column) throws JavaModelException {
        String uri = ClassFileUtil.getURI(this.project, className);
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
        List definitions = this.handler.definition(new TextDocumentPositionParams(identifier, new Position(line, column)), this.monitor);
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)1L, (long)definitions.size());
        Assert.assertNotNull((Object)((Location)definitions.get(0)).getUri());
        Assert.assertTrue((((Location)definitions.get(0)).getRange().getStart().getLine() >= 0 ? 1 : 0) != 0);
    }
}

