/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.Lsp4jAssertions;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DocumentLifeCycleHandlerTest
extends AbstractProjectsManagerBasedTest {
    private SharedASTProvider sharedASTProvider;
    private DocumentLifeCycleHandler lifeCycleHandler;
    private JavaClientConnection javaClient;
    private File temp;

    @Before
    public void setup() throws Exception {
        this.mockPreferences();
        this.sharedASTProvider = SharedASTProvider.getInstance();
        this.sharedASTProvider.invalidateAll();
        this.sharedASTProvider.clearASTCreationCount();
        this.javaClient = new JavaClientConnection(this.client);
        this.lifeCycleHandler = new DocumentLifeCycleHandler(this.javaClient, this.preferenceManager, this.projectsManager, false);
    }

    @After
    public void tearDown() throws Exception {
        this.javaClient.disconnect();
        ICompilationUnit[] iCompilationUnitArray = JavaCore.getWorkingCopies(null);
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            cu.discardWorkingCopy();
            ++n2;
        }
        FileUtils.deleteQuietly((File)this.temp);
    }

    @Test
    public void testUnimplementedMethods() throws Exception {
        IJavaProject javaProject = this.newEmptyProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public interface E {\n");
        buf.append("    void foo();\n");
        buf.append("}\n");
        pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class F implements E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("F.java", buf.toString(), false, null);
        this.openDocument(cu, cu.getSource(), 1);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class F implements E {\n");
        buf.append("\n");
        buf.append("    @Override\n");
        buf.append("    public void foo() {\n");
        buf.append("        \n");
        buf.append("    }\n");
        buf.append("}\n");
        List<Command> commands = this.getCodeActions(cu);
        Assert.assertTrue((commands.size() == 1 ? 1 : 0) != 0);
    }

    protected List<Command> getCodeActions(ICompilationUnit cu) throws JavaModelException {
        CompilationUnit astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, null);
        IProblem[] problems = astRoot.getProblems();
        Range range = this.getRange(cu, problems);
        CodeActionParams parms = new CodeActionParams();
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier();
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        parms.setTextDocument(textDocument);
        parms.setRange(range);
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(DiagnosticsHandler.toDiagnosticsArray(Arrays.asList(problems)));
        parms.setContext(context);
        return new CodeActionHandler().getCodeActionCommands(parms, (IProgressMonitor)new NullProgressMonitor());
    }

    private Range getRange(ICompilationUnit cu, IProblem[] problems) throws JavaModelException {
        IProblem problem = problems[0];
        return JDTUtils.toRange((IOpenable)cu, (int)problem.getSourceStart(), (int)0);
    }

    private Preferences mockPreferences() {
        Preferences mockPreferences = (Preferences)Mockito.mock(Preferences.class);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)mockPreferences);
        Mockito.when((Object)this.preferenceManager.getPreferences((IResource)Mockito.any())).thenReturn((Object)mockPreferences);
        Mockito.when((Object)mockPreferences.getIncompleteClasspathSeverity()).thenReturn((Object)Preferences.Severity.ignore);
        return mockPreferences;
    }

    @Test
    public void testBasicBufferLifeCycle() throws Exception {
        IJavaProject javaProject = this.newEmptyProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E123 {\n");
        buf.append("}\n");
        ICompilationUnit cu1 = pack1.createCompilationUnit("E123.java", buf.toString(), false, null);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)0L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.openDocument(cu1, cu1.getSource(), 1);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu1, 0));
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(1);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E123 {\n");
        buf.append("  X x;\n");
        buf.append("}\n");
        this.changeDocumentFull(cu1, buf.toString(), 2);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)true, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu1, 1));
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(1);
        this.saveDocument(cu1);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.closeDocument(cu1);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)0L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
    }

    @Test
    public void testIncrementalChangeDocument() throws Exception {
        IJavaProject javaProject = this.newEmptyProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        String BEGIN_PART = "package test1;\n";
        String TO_BE_CHANGED_PART = "public class E123 {\n";
        String END_PART = "}\n";
        buf.append(BEGIN_PART);
        buf.append(TO_BE_CHANGED_PART);
        buf.append(END_PART);
        ICompilationUnit cu1 = pack1.createCompilationUnit("E123.java", buf.toString(), false, null);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)0L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.openDocument(cu1, cu1.getSource(), 1);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu1, 0));
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(1);
        buf = new StringBuilder();
        buf.append(TO_BE_CHANGED_PART);
        buf.append("  X x;\n");
        this.changeDocumentIncrementally(cu1, buf.toString(), 2, BEGIN_PART.length(), TO_BE_CHANGED_PART.length());
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)true, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu1, 1));
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(1);
        this.saveDocument(cu1);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.closeDocument(cu1);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)0L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
    }

    @Test
    public void testFixInDependencyScenario() throws Exception {
        IJavaProject javaProject = this.newEmptyProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class F123 {\n");
        buf.append("}\n");
        ICompilationUnit cu1 = pack1.createCompilationUnit("F123.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class F456 {\n");
        buf.append("  { F123.foo(); }\n");
        buf.append("}\n");
        ICompilationUnit cu2 = pack1.createCompilationUnit("F456.java", buf.toString(), false, null);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)false, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)0L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.openDocument(cu2, cu2.getSource(), 1);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)true, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu2, 1));
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(1);
        this.openDocument(cu1, cu1.getSource(), 1);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)true, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu2, 1), new ExpectedProblemReport(cu1, 0));
        Assert.assertEquals((long)2L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(2);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class F123 {\n");
        buf.append("  public static void foo() {}\n");
        buf.append("}\n");
        this.changeDocumentFull(cu1, buf.toString(), 2);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)true, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)true, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport(cu2, 0), new ExpectedProblemReport(cu1, 0));
        Assert.assertEquals((long)2L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(2);
        this.saveDocument(cu1);
        Assert.assertEquals((Object)true, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)true, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)2L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.closeDocument(cu1);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)true, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)1L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
        this.closeDocument(cu2);
        Assert.assertEquals((Object)false, (Object)cu1.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu1.hasUnsavedChanges());
        Assert.assertEquals((Object)false, (Object)cu2.isWorkingCopy());
        Assert.assertEquals((Object)false, (Object)cu2.hasUnsavedChanges());
        this.assertNewProblemReported(new ExpectedProblemReport[0]);
        Assert.assertEquals((long)0L, (long)this.sharedASTProvider.getCacheSize());
        this.assertNewASTsCreated(0);
    }

    @Test
    public void testDidOpenStandaloneFile() throws Exception {
        IJavaProject javaProject = this.newDefaultProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("java", false, null);
        String standaloneFileContent = "package java;\npublic class Foo extends UnknownType {\tpublic void method1(){\n\t\tsuper.whatever();\t}\n}";
        ICompilationUnit cu1 = pack1.createCompilationUnit("Foo.java", standaloneFileContent, false, null);
        this.openDocument(cu1, cu1.getSource(), 1);
        List diagnosticReports = this.getClientRequests("publishDiagnostics");
        Assert.assertEquals((long)1L, (long)diagnosticReports.size());
        PublishDiagnosticsParams diagParam = (PublishDiagnosticsParams)diagnosticReports.get(0);
        Assert.assertEquals((long)0L, (long)diagParam.getDiagnostics().size());
    }

    @Test
    public void testDidOpenNotOnClasspath() throws Exception {
        this.importProjects("eclipse/hello");
        IProject project = WorkspaceHelper.getProject("hello");
        URI uri = project.getFile("nopackage/Test2.java").getRawLocationURI();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((URI)uri);
        String source = FileUtils.readFileToString((File)FileUtils.toFile((URL)uri.toURL()));
        this.openDocument(cu, source, 1);
        Job.getJobManager().join((Object)"DocumentLifeCycleJobs", this.monitor);
        Assert.assertEquals((Object)project, (Object)cu.getJavaProject().getProject());
        Assert.assertEquals((Object)source, (Object)cu.getSource());
        List diagnosticReports = this.getClientRequests("publishDiagnostics");
        Assert.assertEquals((long)1L, (long)diagnosticReports.size());
        PublishDiagnosticsParams diagParam = (PublishDiagnosticsParams)diagnosticReports.get(0);
        Assert.assertEquals((long)1L, (long)diagParam.getDiagnostics().size());
        this.closeDocument(cu);
        Job.getJobManager().join((Object)"DocumentLifeCycleJobs", this.monitor);
        diagnosticReports = this.getClientRequests("publishDiagnostics");
        Assert.assertEquals((long)2L, (long)diagnosticReports.size());
        diagParam = (PublishDiagnosticsParams)diagnosticReports.get(1);
        Assert.assertEquals((long)0L, (long)diagParam.getDiagnostics().size());
    }

    @Test
    public void testDidOpenStandaloneFileWithSyntaxError() throws Exception {
        IJavaProject javaProject = this.newDefaultProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("java", false, null);
        String standaloneFileContent = "package java;\npublic class Foo extends UnknownType {\n\tpublic void method1(){\n\t\tsuper.whatever()\n\t}\n}";
        ICompilationUnit cu1 = pack1.createCompilationUnit("Foo.java", standaloneFileContent, false, null);
        this.openDocument(cu1, cu1.getSource(), 1);
        List diagnosticReports = this.getClientRequests("publishDiagnostics");
        Assert.assertEquals((long)1L, (long)diagnosticReports.size());
        PublishDiagnosticsParams diagParam = (PublishDiagnosticsParams)diagnosticReports.get(0);
        Assert.assertEquals((String)("Unexpected number of errors " + diagParam.getDiagnostics()), (long)1L, (long)diagParam.getDiagnostics().size());
        Diagnostic d = (Diagnostic)diagParam.getDiagnostics().get(0);
        Assert.assertEquals((Object)"Syntax error, insert \";\" to complete BlockStatements", (Object)d.getMessage());
        Lsp4jAssertions.assertRange(3, 17, 18, d.getRange());
    }

    @Test
    public void testDidOpenStandaloneFileWithNonSyntaxErrors() throws Exception {
        IJavaProject javaProject = this.newDefaultProject();
        IPackageFragmentRoot sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        IPackageFragment pack1 = sourceFolder.createPackageFragment("java", false, null);
        String standaloneFileContent = "package java;\npublic class Foo {\n\tpublic static void notThis(){\n\t\tSystem.out.println(this);\n\t}\n\tpublic void method1(){\n\t}\n\tpublic void method1(){\n\t}\n}";
        ICompilationUnit cu1 = pack1.createCompilationUnit("Foo.java", standaloneFileContent, false, null);
        this.openDocument(cu1, cu1.getSource(), 1);
        List diagnosticReports = this.getClientRequests("publishDiagnostics");
        Assert.assertEquals((long)1L, (long)diagnosticReports.size());
        PublishDiagnosticsParams diagParam = (PublishDiagnosticsParams)diagnosticReports.get(0);
        Assert.assertEquals((String)("Unexpected number of errors " + diagParam.getDiagnostics()), (long)3L, (long)diagParam.getDiagnostics().size());
        Diagnostic d = (Diagnostic)diagParam.getDiagnostics().get(0);
        Assert.assertEquals((Object)"Cannot use this in a static context", (Object)d.getMessage());
        Lsp4jAssertions.assertRange(3, 21, 25, d.getRange());
        d = (Diagnostic)diagParam.getDiagnostics().get(1);
        Assert.assertEquals((Object)"Duplicate method method1() in type Foo", (Object)d.getMessage());
        Lsp4jAssertions.assertRange(5, 13, 22, d.getRange());
        d = (Diagnostic)diagParam.getDiagnostics().get(2);
        Assert.assertEquals((Object)"Duplicate method method1() in type Foo", (Object)d.getMessage());
        Lsp4jAssertions.assertRange(7, 13, 22, d.getRange());
    }

    @Test
    public void testNotExpectedPackage() throws Exception {
        this.newDefaultProject();
        String content = "package org;\npublic class Foo {}";
        this.temp = this.createTempFolder();
        File file = this.createTempFile(this.temp, "Foo.java", content);
        URI uri = file.toURI();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((URI)uri);
        this.openDocument(cu, cu.getSource(), 1);
        CompilationUnit astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, (IProgressMonitor)new NullProgressMonitor());
        IProblem[] problems = astRoot.getProblems();
        Assert.assertEquals((String)"Unexpected number of errors", (long)0L, (long)problems.length);
        String source = cu.getSource();
        int length = source.length();
        source = source.replace("org", "org.eclipse");
        this.changeDocument(cu, source, 2, JDTUtils.toRange((IOpenable)cu, (int)0, (int)source.length()), length);
        FileUtils.writeStringToFile((File)file, (String)source);
        this.saveDocument(cu);
        cu = JDTUtils.resolveCompilationUnit((URI)uri);
        astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, (IProgressMonitor)new NullProgressMonitor());
        problems = astRoot.getProblems();
        Assert.assertEquals((String)"Unexpected number of errors", (long)0L, (long)problems.length);
    }

    @Test
    public void testCreateCompilationUnit() throws Exception {
        IJavaProject javaProject = this.newEmptyProject();
        String fooContent = "package org;\npublic class Foo {}\n";
        String barContent = "package org;\npublic class Bar {\n  Foo test() { return null; }\n}\n";
        IFolder src = javaProject.getProject().getFolder("src");
        javaProject.getPackageFragmentRoot((IResource)src);
        File sourceDirectory = src.getRawLocation().makeAbsolute().toFile();
        File org = new File(sourceDirectory, "org");
        org.mkdir();
        File file = new File(org, "Bar.java");
        file.createNewFile();
        FileUtils.writeStringToFile((File)file, (String)barContent);
        ICompilationUnit bar = JDTUtils.resolveCompilationUnit((URI)file.toURI());
        bar.getResource().refreshLocal(1, null);
        Assert.assertNotNull((String)"Bar doesn't exist", (Object)javaProject.findType("org.Bar"));
        file = new File(org, "Foo.java");
        file.createNewFile();
        URI uri = file.toURI();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((URI)uri);
        this.openDocument(unit, "", 1);
        FileUtils.writeStringToFile((File)file, (String)fooContent);
        this.changeDocumentFull(unit, fooContent, 1);
        this.saveDocument(unit);
        this.closeDocument(unit);
        CompilationUnit astRoot = this.sharedASTProvider.getAST((ITypeRoot)bar, null);
        IProblem[] problems = astRoot.getProblems();
        Assert.assertEquals((String)"Unexpected number of errors", (long)0L, (long)problems.length);
    }

    @Test
    public void testNotExpectedPackage2() throws Exception {
        this.newDefaultProject();
        String content = "package org;\npublic class Foo {}";
        this.temp = this.createTempFolder();
        Path path = Paths.get(this.temp.getAbsolutePath(), "org", "eclipse");
        File file = this.createTempFile(path.toFile(), "Foo.java", content);
        URI uri = file.toURI();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((URI)uri);
        this.openDocument(cu, cu.getSource(), 1);
        CompilationUnit astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, (IProgressMonitor)new NullProgressMonitor());
        IProblem[] problems = astRoot.getProblems();
        Assert.assertEquals((String)"Unexpected number of errors", (long)0L, (long)problems.length);
        String source = cu.getSource();
        int length = source.length();
        source = source.replace("org", "org.eclipse");
        this.changeDocument(cu, source, 2, JDTUtils.toRange((IOpenable)cu, (int)0, (int)source.length()), length);
        FileUtils.writeStringToFile((File)file, (String)source);
        this.saveDocument(cu);
        cu = JDTUtils.resolveCompilationUnit((URI)uri);
        astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, (IProgressMonitor)new NullProgressMonitor());
        problems = astRoot.getProblems();
        Assert.assertEquals((String)"Unexpected number of errors", (long)0L, (long)problems.length);
        source = cu.getSource();
        length = source.length();
        source = source.replace("org.eclipse", "org.eclipse.toto");
        this.changeDocument(cu, source, 3, JDTUtils.toRange((IOpenable)cu, (int)0, (int)source.length()), length);
        FileUtils.writeStringToFile((File)file, (String)source);
        this.saveDocument(cu);
        cu = JDTUtils.resolveCompilationUnit((URI)uri);
        astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, (IProgressMonitor)new NullProgressMonitor());
        problems = astRoot.getProblems();
        Assert.assertEquals((String)"Unexpected number of errors", (long)1L, (long)problems.length);
    }

    private File createTempFile(File parent, String fileName, String content) throws IOException {
        parent.mkdirs();
        File file = new File(parent, fileName);
        file.deleteOnExit();
        file.createNewFile();
        FileUtils.writeStringToFile((File)file, (String)content);
        return file;
    }

    private File createTempFolder() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        temp.delete();
        temp.mkdirs();
        temp.deleteOnExit();
        return temp;
    }

    private <T> List<T> getClientRequests(String name) {
        List requests = (List)this.clientRequests.get(name);
        return requests != null ? requests : Collections.emptyList();
    }

    private void openDocument(ICompilationUnit cu, String content, int version) {
        DidOpenTextDocumentParams openParms = new DidOpenTextDocumentParams();
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setLanguageId("java");
        textDocument.setText(content);
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        textDocument.setVersion(version);
        openParms.setTextDocument(textDocument);
        this.lifeCycleHandler.didOpen(openParms);
    }

    private void changeDocumentIncrementally(ICompilationUnit cu, String content, int version, int offset, int length) throws JavaModelException {
        Range range = JDTUtils.toRange((IOpenable)cu, (int)offset, (int)length);
        this.changeDocument(cu, content, version, range, length);
    }

    private void changeDocumentFull(ICompilationUnit cu, String content, int version) throws JavaModelException {
        this.changeDocument(cu, content, version, null, 0);
    }

    private void changeDocument(ICompilationUnit cu, String content, int version, Range range, int length) throws JavaModelException {
        DidChangeTextDocumentParams changeParms = new DidChangeTextDocumentParams();
        VersionedTextDocumentIdentifier textDocument = new VersionedTextDocumentIdentifier();
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        textDocument.setVersion(version);
        changeParms.setTextDocument(textDocument);
        TextDocumentContentChangeEvent event = new TextDocumentContentChangeEvent();
        if (range != null) {
            event.setRange(range);
            event.setRangeLength(Integer.valueOf(length));
        }
        event.setText(content);
        ArrayList<TextDocumentContentChangeEvent> contentChanges = new ArrayList<TextDocumentContentChangeEvent>();
        contentChanges.add(event);
        changeParms.setContentChanges(contentChanges);
        this.lifeCycleHandler.didChange(changeParms);
    }

    private void saveDocument(ICompilationUnit cu) throws Exception {
        DidSaveTextDocumentParams saveParms = new DidSaveTextDocumentParams();
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier();
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        saveParms.setTextDocument(textDocument);
        saveParms.setText(cu.getSource());
        this.lifeCycleHandler.didSave(saveParms);
        this.waitForBackgroundJobs();
    }

    private void closeDocument(ICompilationUnit cu) {
        DidCloseTextDocumentParams closeParms = new DidCloseTextDocumentParams();
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier();
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        closeParms.setTextDocument(textDocument);
        this.lifeCycleHandler.didClose(closeParms);
    }

    private void assertNewProblemReported(ExpectedProblemReport ... expectedReports) {
        List diags = this.getClientRequests("publishDiagnostics");
        Assert.assertEquals((long)expectedReports.length, (long)diags.size());
        int i = 0;
        while (i < expectedReports.length) {
            PublishDiagnosticsParams diag = (PublishDiagnosticsParams)diags.get(i);
            ExpectedProblemReport expected = expectedReports[i];
            Assert.assertEquals((Object)JDTUtils.toURI((ICompilationUnit)expected.cu), (Object)diag.getUri());
            if (expected.problemCount != diag.getDiagnostics().size()) {
                String message = "";
                for (Diagnostic d : diag.getDiagnostics()) {
                    message = String.valueOf(message) + d.getMessage() + ", ";
                }
                Assert.assertEquals((String)message, (long)expected.problemCount, (long)diag.getDiagnostics().size());
            }
            ++i;
        }
        diags.clear();
    }

    private void assertNewASTsCreated(int expected) {
        Assert.assertEquals((long)expected, (long)this.sharedASTProvider.getASTCreationCount());
        this.sharedASTProvider.clearASTCreationCount();
    }

    class ExpectedProblemReport {
        ICompilationUnit cu;
        int problemCount;

        ExpectedProblemReport(ICompilationUnit cu, int problemCount) {
            this.cu = cu;
            this.problemCount = problemCount;
        }
    }
}

