/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ls.core.internal.ClassFileUtil;
import org.eclipse.jdt.ls.core.internal.JsonMessageHelper;
import org.eclipse.jdt.ls.core.internal.Lsp4jAssertions;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeLensHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CodeLensHandlerTest
extends AbstractProjectsManagerBasedTest {
    private static final String CODELENS_PARAM_TEMPLATE = "{\n    \"id\": \"1\",\n    \"method\": \"textDocument/codeLens\",\n    \"params\": {\n        \"textDocument\": {\n            \"uri\": \"${file}\"\n        }\n    },\n    \"jsonrpc\": \"2.0\"\n}";
    private static final String CODELENS_IMPLEMENTATIONS_TEMPLATE = "{\n    \"id\": \"1\",\n    \"method\": \"codeLens/resolve\",\n    \"params\": {\n\t\t\"range\": {\n\t        \"start\": {\n\t            \"line\": ${line},\n\t            \"character\": ${start}\n\t        },\n\t        \"end\": {\n\t            \"line\": ${line},\n\t            \"character\": ${end}\n\t        }\n\t    },\n\t    \"data\": [\n\t        \"${file}\",\n\t        {\n\t            \"line\": ${line},\n\t            \"character\": ${start}\n\t        },\n\t        \"implementations\"\n\t    ]    },\n    \"jsonrpc\": \"2.0\"\n}";
    private static final String CODELENS_REFERENCES_TEMPLATE = "{\n    \"id\": \"1\",\n    \"method\": \"codeLens/resolve\",\n    \"params\": {\n\t\t\"range\": {\n\t        \"start\": {\n\t            \"line\": ${line},\n\t            \"character\": ${start}\n\t        },\n\t        \"end\": {\n\t            \"line\": ${line},\n\t            \"character\": ${end}\n\t        }\n\t    },\n\t    \"data\": [\n\t        \"${file}\",\n\t        {\n\t            \"line\": ${line},\n\t            \"character\": ${start}\n\t        },\n\t        \"references\"\n\t    ]    },\n    \"jsonrpc\": \"2.0\"\n}";
    private CodeLensHandler handler;
    private IProject project;
    private PreferenceManager preferenceManager;

    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)new Preferences());
        this.handler = new CodeLensHandler(this.preferenceManager);
    }

    @Test
    public void testGetCodeLensSymbols() throws Exception {
        String payload = this.createCodeLensSymbolsRequest("src/java/Foo.java");
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        Assert.assertFalse((boolean)uri.isEmpty());
        List result = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((String)("Found " + result), (long)3L, (long)result.size());
        CodeLens cl = (CodeLens)result.get(0);
        Range r = cl.getRange();
        Lsp4jAssertions.assertRange(7, 20, 24, r);
        cl = (CodeLens)result.get(1);
        r = cl.getRange();
        Lsp4jAssertions.assertRange(14, 13, 16, r);
        cl = (CodeLens)result.get(2);
        r = cl.getRange();
        Lsp4jAssertions.assertRange(5, 13, 16, r);
    }

    @Test
    public void testGetCodeLensSymbolsForClass() throws Exception {
        Preferences implementationsCodeLenses = Preferences.createFrom(Collections.singletonMap("java.implementationsCodeLens.enabled", "true"));
        Mockito.reset((Object[])new PreferenceManager[]{this.preferenceManager});
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)implementationsCodeLenses);
        this.handler = new CodeLensHandler(this.preferenceManager);
        String uriString = ClassFileUtil.getURI(this.project, "java.lang.Runnable");
        String payload = this.createCodeLensSymbolRequest(new URI(uriString));
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        Assert.assertFalse((boolean)uri.isEmpty());
        List lenses = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((String)("Found " + lenses), (long)3L, (long)lenses.size());
    }

    @Test
    public void testGetCodeLenseBoundaries() {
        List result = this.handler.getCodeLensSymbols(null, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
        String payload = this.createCodeLensSymbolsRequest("src/java/Missing.java");
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        result = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testDisableCodeLensSymbols() throws Exception {
        Preferences noCodeLenses = Preferences.createFrom(Collections.singletonMap("java.referencesCodeLens.enabled", "false"));
        Mockito.reset((Object[])new PreferenceManager[]{this.preferenceManager});
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)noCodeLenses);
        this.handler = new CodeLensHandler(this.preferenceManager);
        String payload = this.createCodeLensSymbolsRequest("src/java/IFoo.java");
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        Assert.assertFalse((boolean)uri.isEmpty());
        List result = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testEnableImplementationsCodeLensSymbols() throws Exception {
        Preferences implementationsCodeLenses = Preferences.createFrom(Collections.singletonMap("java.implementationsCodeLens.enabled", "true"));
        Mockito.reset((Object[])new PreferenceManager[]{this.preferenceManager});
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)implementationsCodeLenses);
        this.handler = new CodeLensHandler(this.preferenceManager);
        String payload = this.createCodeLensSymbolsRequest("src/java/IFoo.java");
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        Assert.assertFalse((boolean)uri.isEmpty());
        List result = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((long)2L, (long)result.size());
        CodeLens lens = (CodeLens)result.get(1);
        List data = (List)lens.getData();
        String type = (String)data.get(2);
        Assert.assertEquals((Object)type, (Object)"implementations");
    }

    @Test
    public void testDisableImplementationsCodeLensSymbols() throws Exception {
        Preferences noImplementationsCodeLenses = Preferences.createFrom(Collections.singletonMap("java.implementationsCodeLens.enabled", "false"));
        Mockito.reset((Object[])new PreferenceManager[]{this.preferenceManager});
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)noImplementationsCodeLenses);
        Preferences noReferencesCodeLenses = Preferences.createFrom(Collections.singletonMap("java.referencesCodeLens.enabled", "false"));
        Mockito.reset((Object[])new PreferenceManager[]{this.preferenceManager});
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)noReferencesCodeLenses);
        this.handler = new CodeLensHandler(this.preferenceManager);
        String payload = this.createCodeLensSymbolsRequest("src/java/IFoo.java");
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        Assert.assertFalse((boolean)uri.isEmpty());
        List result = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testResolveImplementationsCodeLense() {
        String source = "src/java/IFoo.java";
        String payload = this.createCodeLensImplementationsRequest(source, 5, 17, 21);
        CodeLens lens = (CodeLens)JsonMessageHelper.getParams(payload);
        Range range = lens.getRange();
        Lsp4jAssertions.assertRange(5, 17, 21, range);
        CodeLens result = this.handler.resolve(lens, this.monitor);
        Assert.assertNotNull((Object)result);
        Command command = result.getCommand();
        Assert.assertNotNull((Object)command);
        Assert.assertEquals((Object)"2 implementations", (Object)command.getTitle());
        Assert.assertEquals((Object)"java.show.implementations", (Object)command.getCommand());
        List args = command.getArguments();
        Assert.assertEquals((long)3L, (long)args.size());
        String sourceUri = args.get(0).toString();
        Assert.assertTrue((boolean)sourceUri.endsWith("IFoo.java"));
        Map map = (Map)args.get(1);
        Assert.assertEquals((Object)5.0, map.get("line"));
        Assert.assertEquals((Object)17.0, map.get("character"));
        List locations = (List)args.get(2);
        Assert.assertEquals((long)2L, (long)locations.size());
        Location loc = (Location)locations.get(0);
        Assert.assertTrue((boolean)loc.getUri().endsWith("src/java/Foo2.java"));
        Lsp4jAssertions.assertRange(5, 13, 17, loc.getRange());
    }

    @Test
    public void testResolveCodeLense() {
        String source = "src/java/Foo.java";
        String payload = this.createCodeLensRequest(source, 5, 13, 16);
        CodeLens lens = (CodeLens)JsonMessageHelper.getParams(payload);
        Range range = lens.getRange();
        Lsp4jAssertions.assertRange(5, 13, 16, range);
        CodeLens result = this.handler.resolve(lens, this.monitor);
        Assert.assertNotNull((Object)result);
        Command command = result.getCommand();
        Assert.assertNotNull((Object)command);
        Assert.assertEquals((Object)"1 reference", (Object)command.getTitle());
        Assert.assertEquals((Object)"java.show.references", (Object)command.getCommand());
        List args = command.getArguments();
        Assert.assertEquals((long)3L, (long)args.size());
        String sourceUri = args.get(0).toString();
        Assert.assertTrue((boolean)sourceUri.endsWith(source));
        Map map = (Map)args.get(1);
        Assert.assertEquals((Object)5.0, map.get("line"));
        Assert.assertEquals((Object)13.0, map.get("character"));
        List locations = (List)args.get(2);
        Assert.assertEquals((long)1L, (long)locations.size());
        Location loc = (Location)locations.get(0);
        Assert.assertTrue((boolean)loc.getUri().endsWith("src/java/Bar.java"));
        Lsp4jAssertions.assertRange(5, 25, 28, loc.getRange());
    }

    @Test
    public void testResolveCodeLenseBoundaries() {
        CodeLens result = this.handler.resolve(null, this.monitor);
        Assert.assertNull((Object)result);
        String payload = this.createCodeLensRequest("src/java/Missing.java", 5, 13, 16);
        CodeLens lens = (CodeLens)JsonMessageHelper.getParams(payload);
        result = this.handler.resolve(lens, this.monitor);
        Assert.assertSame((Object)lens, (Object)result);
        Assert.assertNotNull((Object)result.getCommand());
    }

    @Test
    public void testIgnoreLombokCodeLensSymbols() throws Exception {
        String payload = this.createCodeLensSymbolsRequest("src/java/Bar.java");
        CodeLensParams codeLensParams = (CodeLensParams)JsonMessageHelper.getParams(payload);
        String uri = codeLensParams.getTextDocument().getUri();
        Assert.assertFalse((boolean)uri.isEmpty());
        List result = this.handler.getCodeLensSymbols(uri, this.monitor);
        Assert.assertEquals((String)("Found " + result), (long)4L, (long)result.size());
        CodeLens cl = (CodeLens)result.get(0);
        Lsp4jAssertions.assertRange(7, 11, 14, cl.getRange());
        cl = (CodeLens)result.get(1);
        Lsp4jAssertions.assertRange(16, 16, 40, cl.getRange());
        cl = (CodeLens)result.get(2);
        Lsp4jAssertions.assertRange(22, 16, 19, cl.getRange());
        cl = (CodeLens)result.get(3);
        Lsp4jAssertions.assertRange(5, 13, 16, cl.getRange());
    }

    String createCodeLensSymbolsRequest(String file) {
        URI uri = this.project.getFile(file).getRawLocationURI();
        return this.createCodeLensSymbolRequest(uri);
    }

    String createCodeLensSymbolRequest(URI file) {
        String fileURI = ResourceUtils.fixURI((URI)file);
        return CODELENS_PARAM_TEMPLATE.replace("${file}", fileURI);
    }

    String createCodeLensRequest(String file, int line, int start, int end) {
        URI uri = this.project.getFile(file).getRawLocationURI();
        return this.createCodeLensRequest(uri, line, start, end);
    }

    String createCodeLensImplementationsRequest(String file, int line, int start, int end) {
        URI uri = this.project.getFile(file).getRawLocationURI();
        return this.createCodeLensImplementationsRequest(uri, line, start, end);
    }

    String createCodeLensRequest(URI file, int line, int start, int end) {
        String fileURI = ResourceUtils.fixURI((URI)file);
        return CODELENS_REFERENCES_TEMPLATE.replace("${file}", fileURI).replace("${line}", String.valueOf(line)).replace("${start}", String.valueOf(start)).replace("${end}", String.valueOf(end));
    }

    String createCodeLensImplementationsRequest(URI file, int line, int start, int end) {
        String fileURI = ResourceUtils.fixURI((URI)file);
        return CODELENS_IMPLEMENTATIONS_TEMPLATE.replace("${file}", fileURI).replace("${line}", String.valueOf(line)).replace("${start}", String.valueOf(start)).replace("${end}", String.valueOf(end));
    }
}

