/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.codemanipulation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.ls.core.internal.correction.TestOptions;
import org.eclipse.jdt.ls.core.internal.managers.AbstractMavenBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.text.edits.TextEdit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImportOrganizeTest
extends AbstractMavenBasedTest {
    private static final String JUNIT_SRC_ENCODING = "ISO-8859-1";
    private IJavaProject javaProject;
    private IPackageFragmentRoot fSourceFolder;
    private IProject project;
    private File junitSrcArchive;

    @Before
    public void setup() throws Exception {
        this.importProjects("maven/quickstart");
        this.project = WorkspaceHelper.getProject("quickstart");
        this.javaProject = JavaCore.create((IProject)this.project);
        Hashtable<String, String> options = TestOptions.getDefaultOptions();
        options.put("org.eclipse.jdt.core.formatter.number_of_empty_lines_to_preserve", String.valueOf(99));
        this.javaProject.setOptions(options);
        this.fSourceFolder = this.javaProject.getPackageFragmentRoot((IResource)this.javaProject.getProject().getFolder("src/main/java"));
        File src = this.fSourceFolder.getResource().getLocation().toFile();
        src.mkdirs();
        this.project.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void requireJUnitSources() throws Exception {
        ArtifactKey key = new ArtifactKey("junit", "junit", "3.8.1", "sources");
        this.junitSrcArchive = ImportOrganizeTest.getLocalArtifactFile(key);
        if (this.junitSrcArchive == null) {
            Artifact junit = MavenPlugin.getMaven().resolve(key.getGroupId(), key.getArtifactId(), key.getVersion(), "jar", key.getClassifier(), null, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)("Unable to download " + key), (Object)junit);
            this.junitSrcArchive = ImportOrganizeTest.getLocalArtifactFile(key);
        }
        Assert.assertTrue((String)"junit src not found", (boolean)this.junitSrcArchive.isFile());
        this.addFilesFromJar(this.javaProject, this.junitSrcArchive, JUNIT_SRC_ENCODING);
    }

    private static File getLocalArtifactFile(ArtifactKey a) {
        IMaven maven = MavenPlugin.getMaven();
        try {
            ArtifactRepository localRepository = maven.getLocalRepository();
            String relPath = maven.getArtifactPath(localRepository, a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", a.getClassifier());
            File file = new File(localRepository.getBasedir(), relPath).getCanonicalFile();
            if (file.canRead()) {
                return file;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @After
    public void cleanUp() throws Exception {
        SharedASTProvider.getInstance().invalidateAll();
        super.cleanUp();
        JavaLanguageServerPlugin.getPreferencesManager().getPreferences().setImportOrder(Preferences.JAVA_IMPORT_ORDER_DEFAULT);
    }

    protected OrganizeImportsOperation.IChooseImportQuery createQuery(final String name, final String[] choices, final int[] nEntries) {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                Assert.assertTrue((String)(String.valueOf(name) + "-query-nchoices1"), (choices.length == openChoices.length ? 1 : 0) != 0);
                Assert.assertTrue((String)(String.valueOf(name) + "-query-nchoices2"), (nEntries.length == openChoices.length ? 1 : 0) != 0);
                int i = 0;
                while (i < nEntries.length) {
                    Assert.assertTrue((String)(String.valueOf(name) + "-query-cnt" + i), (openChoices[i].length == nEntries[i] ? 1 : 0) != 0);
                    ++i;
                }
                TypeNameMatch[] res = new TypeNameMatch[openChoices.length];
                int i2 = 0;
                while (i2 < openChoices.length) {
                    TypeNameMatch[] selection = openChoices[i2];
                    Assert.assertNotNull((String)(String.valueOf(name) + "-query-setset" + i2), (Object)selection);
                    Assert.assertTrue((String)(String.valueOf(name) + "-query-setlen" + i2), (selection.length > 0 ? 1 : 0) != 0);
                    TypeNameMatch found = null;
                    int k = 0;
                    while (k < selection.length) {
                        if (selection[k].getFullyQualifiedName().equals(choices[i2])) {
                            found = selection[k];
                        }
                        ++k;
                    }
                    Assert.assertNotNull((String)(String.valueOf(name) + "-query-notfound" + i2), found);
                    res[i2] = found;
                    ++i2;
                }
                return res;
            }
        };
    }

    private void assertImports(ICompilationUnit cu, String[] imports) throws Exception {
        IImportDeclaration[] desc = cu.getImports();
        Assert.assertEquals((String)(String.valueOf(cu.getElementName()) + "-count"), (long)imports.length, (long)desc.length);
        int i = 0;
        while (i < imports.length) {
            Assert.assertEquals((String)(String.valueOf(cu.getElementName()) + "-cmpentries" + i), (Object)desc[i].getElementName(), (Object)imports[i]);
            ++i;
        }
    }

    @Test
    public void test1() throws Exception {
        this.requireJUnitSources();
        ICompilationUnit cu = (ICompilationUnit)this.javaProject.findElement((IPath)new Path("junit/runner/BaseTestRunner.java"));
        Assert.assertNotNull((String)"BaseTestRunner.java", (Object)cu);
        IPackageFragmentRoot root = (IPackageFragmentRoot)cu.getParent().getParent();
        IPackageFragment pack = root.createPackageFragment("mytest", true, null);
        ICompilationUnit colidingCU = pack.getCompilationUnit("TestListener.java");
        colidingCU.createType("public abstract class TestListener {\n}\n", null, true, null);
        String[] order = new String[]{};
        OrganizeImportsOperation.IChooseImportQuery query = this.createQuery("BaseTestRunner", new String[]{"junit.framework.TestListener"}, new int[]{2});
        OrganizeImportsOperation op = this.createOperation(cu, order, false, true, true, query);
        TextEdit edit = op.createTextEdit((IProgressMonitor)new NullProgressMonitor());
        Document document = new Document(cu.getSource());
        edit.apply((IDocument)document);
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            cu.getBuffer().setContents(document.get());
            cu.reconcile(0, true, null, (IProgressMonitor)new NullProgressMonitor());
            this.assertImports(cu, new String[]{"java.io.BufferedReader", "java.io.File", "java.io.FileInputStream", "java.io.FileOutputStream", "java.io.IOException", "java.io.InputStream", "java.io.PrintWriter", "java.io.StringReader", "java.io.StringWriter", "java.lang.reflect.InvocationTargetException", "java.lang.reflect.Method", "java.lang.reflect.Modifier", "java.text.NumberFormat", "java.util.Properties", "junit.framework.AssertionFailedError", "junit.framework.Test", "junit.framework.TestListener", "junit.framework.TestSuite"});
        }
        finally {
            cu.discardWorkingCopy();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addFilesFromJar(IJavaProject javaProject, File jarFile, String encoding) throws InvocationTargetException, CoreException, IOException {
        src = (IFolder)this.fSourceFolder.getResource();
        targetFile = src.getLocation().toFile();
        var6_6 = null;
        var7_8 = null;
        try {
            file = new JarFile(jarFile);
            try {
                for (JarEntry entry : Collections.list(file.entries())) {
                    if (entry.isDirectory()) continue;
                    var11_13 = null;
                    var12_15 = null;
                    try {
                        in = file.getInputStream(entry);
                        try {
                            reader = new InputStreamReader(in, encoding);
                            try {
                                outFile = new File(targetFile, entry.getName());
                                outFile.getParentFile().mkdirs();
                                var16_21 = null;
                                var17_23 = null;
                                try {
                                    out = new FileOutputStream(outFile);
                                    try {
                                        writer = new OutputStreamWriter((OutputStream)out, encoding);
                                        try {
                                            IOUtils.copy((Reader)reader, (Writer)writer);
                                        }
                                        finally {
                                            if (writer != null) {
                                                writer.close();
                                            }
                                        }
                                        ** if (out == null) goto lbl-1000
                                    }
                                    catch (Throwable var17_24) {
                                        if (var16_21 == null) {
                                            var16_21 = var17_24;
                                        } else if (var16_21 != var17_24) {
                                            var16_21.addSuppressed(var17_24);
                                        }
                                        if (out != null) {
                                            out.close();
                                        }
                                        throw var16_21;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        out.close();
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                    }
                                }
                                catch (Throwable var17_25) {
                                    if (var16_21 == null) {
                                        var16_21 = var17_25;
                                    } else if (var16_21 != var17_25) {
                                        var16_21.addSuppressed(var17_25);
                                    }
                                    throw var16_21;
                                }
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            if (in == null) continue;
                        }
                        catch (Throwable var12_16) {
                            if (var11_13 == null) {
                                var11_13 = var12_16;
                            } else if (var11_13 != var12_16) {
                                var11_13.addSuppressed(var12_16);
                            }
                            if (in != null) {
                                in.close();
                            }
                            throw var11_13;
                        }
                        in.close();
                    }
                    catch (Throwable var12_17) {
                        if (var11_13 == null) {
                            var11_13 = var12_17;
                        } else if (var11_13 != var12_17) {
                            var11_13.addSuppressed(var12_17);
                        }
                        throw var11_13;
                    }
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable var7_9) {
            if (var6_6 == null) {
                var6_6 = var7_9;
            } else if (var6_6 != var7_9) {
                var6_6.addSuppressed(var7_9);
            }
            throw var6_6;
        }
        javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void test1WithOrder() throws Exception {
        this.requireJUnitSources();
        ICompilationUnit cu = (ICompilationUnit)this.javaProject.findElement((IPath)new Path("junit/runner/BaseTestRunner.java"));
        Assert.assertNotNull((String)"BaseTestRunner.java is missing", (Object)cu);
        IPackageFragmentRoot root = (IPackageFragmentRoot)cu.getParent().getParent();
        IPackageFragment pack = root.createPackageFragment("mytest", true, null);
        ICompilationUnit colidingCU = pack.getCompilationUnit("TestListener.java");
        colidingCU.createType("public abstract class TestListener {\n}\n", null, true, null);
        String[] order = new String[]{"junit", "java.text", "java.io", "java"};
        OrganizeImportsOperation.IChooseImportQuery query = this.createQuery("BaseTestRunner", new String[]{"junit.framework.TestListener"}, new int[]{2});
        OrganizeImportsOperation op = this.createOperation(cu, order, false, true, true, query);
        TextEdit edit = op.createTextEdit((IProgressMonitor)new NullProgressMonitor());
        Document document = new Document(cu.getSource());
        edit.apply((IDocument)document);
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            cu.getBuffer().setContents(document.get());
            cu.reconcile(0, true, null, (IProgressMonitor)new NullProgressMonitor());
            this.assertImports(cu, new String[]{"junit.framework.AssertionFailedError", "junit.framework.Test", "junit.framework.TestListener", "junit.framework.TestSuite", "java.text.NumberFormat", "java.io.BufferedReader", "java.io.File", "java.io.FileInputStream", "java.io.FileOutputStream", "java.io.IOException", "java.io.InputStream", "java.io.PrintWriter", "java.io.StringReader", "java.io.StringWriter", "java.lang.reflect.InvocationTargetException", "java.lang.reflect.Method", "java.lang.reflect.Modifier", "java.util.Properties"});
        }
        finally {
            cu.discardWorkingCopy();
        }
    }

    @Test
    public void testStaticImports1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("pack1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import static java.lang.System.out;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("    public int foo() {\n");
        buf.append("        out.print(File.separator);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("C.java", buf.toString(), false, null);
        String[] order = new String[]{"java", "pack", "#java"};
        OrganizeImportsOperation.IChooseImportQuery query = this.createQuery("C", new String[0], new int[0]);
        OrganizeImportsOperation op = this.createOperation(cu, order, false, true, true, query);
        TextEdit edit = op.createTextEdit((IProgressMonitor)new NullProgressMonitor());
        Document document = new Document(cu.getSource());
        edit.apply((IDocument)document);
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            cu.getBuffer().setContents(document.get());
            cu.reconcile(0, true, null, (IProgressMonitor)new NullProgressMonitor());
            buf = new StringBuilder();
            buf.append("package pack1;\n");
            buf.append("\n");
            buf.append("import java.io.File;\n");
            buf.append("\n");
            buf.append("import static java.lang.System.out;\n");
            buf.append("\n");
            buf.append("public class C {\n");
            buf.append("    public int foo() {\n");
            buf.append("        out.print(File.separator);\n");
            buf.append("    }\n");
            buf.append("}\n");
            Assert.assertTrue((boolean)cu.getSource().equals(buf.toString()));
        }
        finally {
            cu.discardWorkingCopy();
        }
    }

    @Test
    public void testStaticImports2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("pack1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import static java.io.File.*;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("    public String foo() {\n");
        buf.append("        return pathSeparator + separator + File.separator;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("C.java", buf.toString(), false, null);
        String[] order = new String[]{"#java.io.File", "java", "pack"};
        OrganizeImportsOperation.IChooseImportQuery query = this.createQuery("C", new String[0], new int[0]);
        OrganizeImportsOperation op = this.createOperation(cu, order, false, true, true, query);
        TextEdit edit = op.createTextEdit((IProgressMonitor)new NullProgressMonitor());
        Document document = new Document(cu.getSource());
        edit.apply((IDocument)document);
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            cu.getBuffer().setContents(document.get());
            cu.reconcile(0, true, null, (IProgressMonitor)new NullProgressMonitor());
            buf = new StringBuilder();
            buf.append("package pack1;\n");
            buf.append("\n");
            buf.append("import static java.io.File.pathSeparator;\n");
            buf.append("import static java.io.File.separator;\n");
            buf.append("\n");
            buf.append("import java.io.File;\n");
            buf.append("\n");
            buf.append("public class C {\n");
            buf.append("    public String foo() {\n");
            buf.append("        return pathSeparator + separator + File.separator;\n");
            buf.append("    }\n");
            buf.append("}\n");
            Assert.assertTrue((boolean)cu.getSource().equals(buf.toString()));
        }
        finally {
            cu.discardWorkingCopy();
        }
    }

    protected OrganizeImportsOperation createOperation(ICompilationUnit cu, String[] order, boolean ignoreLowerCaseNames, boolean save, boolean allowSyntaxErrors, OrganizeImportsOperation.IChooseImportQuery chooseImportQuery) {
        this.setOrganizeImportSettings(order);
        return new OrganizeImportsOperation(cu, null, ignoreLowerCaseNames, save, allowSyntaxErrors, chooseImportQuery);
    }

    protected void setOrganizeImportSettings(String[] order) {
        Preferences prefs = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        ArrayList<String> importOrder = new ArrayList<String>();
        if (order != null) {
            importOrder.addAll(Arrays.asList(order));
        }
        prefs.setImportOrder(importOrder);
    }
}

