/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Location;

public final class ClassFileUtil {
    private ClassFileUtil() {
    }

    public static String getURI(IProject project, String fqcn) throws JavaModelException {
        Assert.isNotNull((Object)project, (String)"Project can't be null");
        Assert.isNotNull((Object)fqcn, (String)"FQCN can't be null");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        int lastDot = fqcn.lastIndexOf(".");
        String packageName = lastDot > 0 ? fqcn.substring(0, lastDot) : "";
        String className = lastDot > 0 ? fqcn.substring(lastDot + 1) : fqcn;
        ClassUriExtractor extractor = new ClassUriExtractor();
        new SearchEngine().searchAllTypeNames(packageName.toCharArray(), 0, className.toCharArray(), 0, 0, JDTUtils.createSearchScope((IJavaProject)javaProject), (TypeNameMatchRequestor)extractor, 3, (IProgressMonitor)new NullProgressMonitor());
        return extractor.uri;
    }

    private static class ClassUriExtractor
    extends TypeNameMatchRequestor {
        String uri;

        private ClassUriExtractor() {
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            try {
                if (match.getType().isBinary()) {
                    Location location = JDTUtils.toLocation((IClassFile)match.getType().getClassFile());
                    if (location != null) {
                        this.uri = location.getUri();
                    }
                } else {
                    this.uri = match.getType().getResource().getLocationURI().toString();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

