/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.BundleUtils;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleUtilsTest
extends AbstractProjectsManagerBasedTest {
    private static final String REFERENCE_PREFIX = "reference:";
    private static final String EXTENSIONPOINT_ID = "testbundle.ext";

    @Test
    public void testLoad() throws Exception {
        this.loadBundles(Arrays.asList(this.getBundle()));
        String bundleLocation = this.getBundleLocation(this.getBundle(), true);
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        Bundle installedBundle = context.getBundle(bundleLocation);
        try {
            Assert.assertNotNull((Object)installedBundle);
            Assert.assertTrue((installedBundle.getState() == 8 || installedBundle.getState() == 32 ? 1 : 0) != 0);
            installedBundle.loadClass("testbundle.Activator");
            Assert.assertEquals((long)installedBundle.getState(), (long)32L);
            String extResult = this.getBundleExtensionResult();
            Assert.assertEquals((Object)"EXT_TOSTRING", (Object)extResult);
        }
        finally {
            installedBundle.uninstall();
        }
    }

    @Test
    public void testLoadWithoutLoadClass() throws Exception {
        this.loadBundles(Arrays.asList(this.getBundle()));
        String bundleLocation = this.getBundleLocation(this.getBundle(), true);
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        Bundle installedBundle = context.getBundle(bundleLocation);
        try {
            Assert.assertNotNull((Object)installedBundle);
            Assert.assertTrue((installedBundle.getState() == 8 || installedBundle.getState() == 32 ? 1 : 0) != 0);
            String extResult = this.getBundleExtensionResult();
            Assert.assertEquals((Object)"EXT_TOSTRING", (Object)extResult);
        }
        finally {
            installedBundle.uninstall();
        }
    }

    @Test
    public void testLoadAndUpdate() throws Exception {
        this.loadBundles(Arrays.asList(this.getBundle()));
        String bundleLocation = this.getBundleLocation(this.getBundle(), true);
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        Bundle installedBundle = context.getBundle(bundleLocation);
        try {
            Assert.assertNotNull((Object)installedBundle);
            Assert.assertTrue((installedBundle.getState() == 8 || installedBundle.getState() == 32 ? 1 : 0) != 0);
            installedBundle.loadClass("testbundle.Activator");
            Assert.assertEquals((long)installedBundle.getState(), (long)32L);
            String extResult = this.getBundleExtensionResult();
            Assert.assertEquals((Object)"EXT_TOSTRING", (Object)extResult);
            this.loadBundles(Arrays.asList(this.getBundle("testresources", "testbundle-0.6.0-SNAPSHOT.jar")));
            bundleLocation = this.getBundleLocation(this.getBundle("testresources", "testbundle-0.6.0-SNAPSHOT.jar"), true);
            installedBundle = context.getBundle(bundleLocation);
            Assert.assertNotNull((Object)installedBundle);
            Assert.assertTrue((installedBundle.getState() == 8 || installedBundle.getState() == 32 ? 1 : 0) != 0);
            installedBundle.loadClass("testbundle.Activator");
            Assert.assertEquals((long)installedBundle.getState(), (long)32L);
            extResult = this.getBundleExtensionResult();
            Assert.assertEquals((Object)"EXT_TOSTRING_0.6.0", (Object)extResult);
        }
        finally {
            installedBundle.uninstall();
        }
    }

    @Test
    public void testLoadWithWhitespace() throws Exception {
        this.loadBundles(Arrays.asList(this.getBundle("testresources/path with whitespace", "bundle with whitespace.jar")));
        String bundleLocation = this.getBundleLocation(this.getBundle("testresources/path with whitespace", "bundle with whitespace.jar"), true);
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        Bundle installedBundle = context.getBundle(bundleLocation);
        try {
            Assert.assertNotNull((Object)installedBundle);
            Assert.assertTrue((installedBundle.getState() == 8 || installedBundle.getState() == 32 ? 1 : 0) != 0);
            installedBundle.loadClass("testbundle.Activator");
            Assert.assertEquals((long)installedBundle.getState(), (long)32L);
            String extResult = this.getBundleExtensionResult();
            Assert.assertEquals((Object)"EXT_TOSTRING", (Object)extResult);
        }
        finally {
            installedBundle.uninstall();
        }
    }

    @Test(expected=CoreException.class)
    public void testLoadThrowCoreException() throws Exception {
        BundleUtils.loadBundles(Arrays.asList("Fakedlocation"));
    }

    private void loadBundles(List<String> bundles) throws Exception {
        RegistryChangeListener listener = new RegistryChangeListener(false);
        try {
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)listener);
            BundleUtils.loadBundles(bundles);
            while (!listener.isChanged()) {
                Thread.sleep(100L);
            }
        }
        finally {
            Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)listener);
        }
    }

    private String getBundle() {
        return this.getBundle("testresources", "testbundle-0.3.0-SNAPSHOT.jar");
    }

    private String getBundle(String folder, String bundleName) {
        return new File(folder, bundleName).getAbsolutePath();
    }

    private String getBundleLocation(String location, boolean useReference) {
        File f = new File(location);
        String bundleLocation = null;
        try {
            bundleLocation = f.toURI().toURL().toString();
            if (useReference) {
                bundleLocation = REFERENCE_PREFIX + bundleLocation;
            }
        }
        catch (MalformedURLException e) {
            JavaLanguageServerPlugin.logException((String)"Get bundle location failure ", (Throwable)e);
        }
        return bundleLocation;
    }

    private String getBundleExtensionResult() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_ID);
        Assert.assertEquals((String)"Expect one extension point", (long)1L, (long)elements.length);
        final String[] resultValues = new String[]{""};
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement e = iConfigurationElementArray[n2];
            if ("java".equals(e.getAttribute("type"))) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        Object extInstance = e.createExecutableExtension("class");
                        resultValues[0] = extInstance.toString();
                    }

                    public void handleException(Throwable ex) {
                        Status status = new Status(4, "org.eclipse.jdt.ls.core", 0, "Error in JDT Core during launching debug server", ex);
                        JavaLanguageServerPlugin.log((IStatus)status);
                    }
                });
            }
            ++n2;
        }
        return resultValues[0];
    }

    private class RegistryChangeListener
    implements IRegistryChangeListener {
        private boolean changed;

        private RegistryChangeListener(boolean changed) {
            this.setChanged(changed);
        }

        public void registryChanged(IRegistryChangeEvent event) {
            this.setChanged(true);
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void setChanged(boolean changed) {
            this.changed = changed;
        }
    }
}

