/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.sql.XADataSource;

public class TSXADataSource {
    private static final char PROPS_DELIM = ':';
    private static final char PAIR_DELIM = '=';
    private static final char LITERAL_DELIM = '\'';
    private static final String XA_CLASS_NAME = "XADataSourceName";
    private static TSXADataSource instance = new TSXADataSource();

    private TSXADataSource() {
    }

    public static TSXADataSource instance() {
        return instance;
    }

    private String lowerFirstChar(String str) {
        String result = str;
        if (str == null || str.length() == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            result = Character.toString(Character.toUpperCase(firstChar)) + result.substring(1);
        }
        return result;
    }

    private void setProperties(Map props, Class clazz, Object target) throws Exception {
        try {
            for (String originalPropName : props.keySet()) {
                String propName = this.lowerFirstChar(originalPropName);
                String methodName = "set" + propName;
                Method m = this.findMethod(methodName, clazz);
                String propValue = (String)props.get(originalPropName);
                Class<?>[] parameters = m.getParameterTypes();
                Object[] values = new Object[]{this.convertType(parameters[0], propValue)};
                m.invoke(target, values);
                System.err.println("$$$$$ TSXADataSource.setProperties \"[" + originalPropName + ", " + propValue + "]\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Map getProps(String arg) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean inValue = false;
        boolean inQuote = false;
        StringBuffer nameBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        int numChars = arg.length();
        for (int i = 0; i < numChars; ++i) {
            char current = arg.charAt(i);
            if (Character.isWhitespace(current)) continue;
            if (current == '=') {
                inValue = true;
                continue;
            }
            if (current == '\'') {
                inQuote = !inQuote;
                continue;
            }
            if (current == ':' && !inQuote) {
                inValue = false;
                result.put(nameBuffer.toString(), valueBuffer.toString());
                nameBuffer.delete(0, nameBuffer.length());
                valueBuffer.delete(0, valueBuffer.length());
                continue;
            }
            if (inQuote || inValue) {
                valueBuffer.append(current);
                continue;
            }
            nameBuffer.append(current);
        }
        result.put(nameBuffer.toString(), valueBuffer.toString());
        System.err.println("$$$$$ getProps()" + result);
        return result;
    }

    private Method findMethod(String methodName, Class clazz) throws Exception {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            result = methods[i];
            System.err.println("$$$$$$$$$$$$$$$$$$$$$$$$$");
            System.err.println("$$$$$ findMethod() found method: " + result);
            System.err.println("$$$$$$$$$$$$$$$$$$$$$$$$$");
            break;
        }
        if (result == null) {
            throw new Exception("$$$$ Could not find method " + methodName + " in Class: " + clazz.getName());
        }
        return result;
    }

    private Object convertType(Class type, String parameter) throws NumberFormatException {
        try {
            String typeName = type.getName();
            if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
                return parameter;
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return new Integer(parameter);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return new Short(parameter);
            }
            if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
                return new Byte(parameter);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return new Long(parameter);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return new Float(parameter);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return new Double(parameter);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(parameter);
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(parameter);
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return new Boolean(parameter);
            }
            return parameter;
        }
        catch (NumberFormatException nfe) {
            System.err.println("$$$$$ NumberFormatException Encountered");
            throw nfe;
        }
    }

    public XADataSource getXADataSource(String xaProps, String className) throws Exception {
        System.err.println("$$$$$$$$$$$$$$$$$$$$$$$$$");
        System.err.println("xaProps \"" + xaProps + "\"");
        System.err.println("className \"" + className + "\"");
        System.err.println("$$$$$$$$$$$$$$$$$$$$$$$$$");
        Map props = this.getProps(xaProps);
        Class<?> clazz = Class.forName(className);
        XADataSource target = (XADataSource)clazz.newInstance();
        this.setProperties(props, clazz, target);
        return target;
    }
}

