/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs31.ee.multipart;

import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@RunAsClient
public class MultipartSupportIT {
    private static final String LS = System.lineSeparator();
    @ArquillianResource
    private URI uri;

    static InputStream xmlFile() {
        String xml = "<root>" + LS + "  <mid attr1=\"value1\" attr2=\"value2\">" + LS + "    <inner attr3=\"value3\"/>" + LS + "  </mid>" + LS + "  <mid attr1=\"value4\" attr2=\"value5\">" + LS + "    <inner attr3=\"value6\"/>" + LS + "  </mid>" + LS + "</root>";
        return new ByteArrayInputStream(xml.getBytes());
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment
    public static WebArchive deployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(MultipartSupportIT.class.getSimpleName() + ".war"))).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void basicTest() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            List<EntityPart> multipart = List.of(EntityPart.withName((String)"octet-stream").content((Object)"test string".getBytes(StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE).build(), EntityPart.withName((String)"file").content("test file", MultipartSupportIT.xmlFile()).mediaType("application/xml").build());
            try (Response response = client.target(MultipartSupportIT.createCombinedUri(this.uri, "test/basicTest")).request(new MediaType[]{MediaType.MULTIPART_FORM_DATA_TYPE}).post(Entity.entity((Object)new GenericEntity<List<EntityPart>>(multipart){}, (String)"multipart/form-data"));){
                Assertions.assertEquals((int)200, (int)response.getStatus());
                List entityParts = (List)response.readEntity((GenericType)new GenericType<List<EntityPart>>(){});
                if (entityParts.size() != 3) {
                    String msg = "Expected 3 entries, received " + entityParts.size() + "." + System.lineSeparator() + MultipartSupportIT.getMessage(entityParts);
                    Assertions.fail((String)msg);
                }
                EntityPart part = MultipartSupportIT.find(entityParts, "received-string");
                Assertions.assertNotNull((Object)part, MultipartSupportIT.getMessage(entityParts));
                Assertions.assertEquals((Object)"test string", (Object)part.getContent(String.class));
                try {
                    part.getContent(String.class);
                    Assertions.fail((String)"IllegalStateException is expected when getContent() is invoked more than once.");
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Throwable t) {
                    Assertions.fail((String)("Incorrect Throwable received: " + t));
                }
                part = MultipartSupportIT.find(entityParts, "received-file");
                Assertions.assertNotNull((Object)part, MultipartSupportIT.getMessage(entityParts));
                Assertions.assertEquals((Object)"test file", part.getFileName().get());
                Assertions.assertTrue((boolean)((String)part.getContent(String.class)).contains("value6"));
                part = MultipartSupportIT.find(entityParts, "added-input-stream");
                Assertions.assertNotNull((Object)part, MultipartSupportIT.getMessage(entityParts));
                Assertions.assertEquals((Object)"Add part on return.", (Object)part.getContent(String.class));
                if (part.getHeaders() == null || part.getHeaders().size() != 4) {
                    String msg = "Expected 4 headers, received " + part.getHeaders().size();
                    Assertions.fail((String)msg);
                }
                Assertions.assertEquals((Object)"Test1", ((List)part.getHeaders().get((Object)"Header1")).get(0));
                Assertions.assertEquals((Object)"Test2", ((List)part.getHeaders().get((Object)"Header2")).get(0));
            }
        }
    }

    @Test
    public void multiFormParamTest() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            List<EntityPart> multipart = List.of(EntityPart.withName((String)"entity-part").content((Object)"test entity part").mediaType(MediaType.TEXT_PLAIN_TYPE).build(), EntityPart.withName((String)"string-part").content((Object)"test string").mediaType(MediaType.TEXT_PLAIN_TYPE).build(), EntityPart.withName((String)"input-stream-part").content((Object)"test input stream".getBytes(StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE).build());
            try (Response response = client.target(MultipartSupportIT.createCombinedUri(this.uri, "test/multi-form-param")).request(new MediaType[]{MediaType.MULTIPART_FORM_DATA_TYPE}).post(Entity.entity((Object)new GenericEntity<List<EntityPart>>(multipart){}, (String)"multipart/form-data"));){
                Assertions.assertEquals((int)200, (int)response.getStatus());
                List entityParts = (List)response.readEntity((GenericType)new GenericType<List<EntityPart>>(){});
                if (entityParts.size() != 3) {
                    String msg = "Expected 3 entries, received " + entityParts.size() + "." + System.lineSeparator() + MultipartSupportIT.getMessage(entityParts);
                    Assertions.fail((String)msg);
                }
                MultipartSupportIT.verifyEntityPart(entityParts, "received-entity-part", "test entity part");
                MultipartSupportIT.verifyEntityPart(entityParts, "received-string", "test string");
                MultipartSupportIT.verifyEntityPart(entityParts, "received-input-stream", "test input stream");
            }
        }
    }

    private static void verifyEntityPart(List<EntityPart> parts, String name, String text) throws IOException {
        EntityPart part = MultipartSupportIT.find(parts, name);
        Assertions.assertNotNull((Object)part, (String)String.format("Failed to find entity part %s in: %s", name, MultipartSupportIT.getMessage(parts)));
        Assertions.assertEquals((Object)text, (Object)part.getContent(String.class));
    }

    private static Supplier<String> getMessage(List<EntityPart> parts) {
        return () -> {
            StringBuilder msg = new StringBuilder();
            Iterator iter = parts.iterator();
            while (iter.hasNext()) {
                EntityPart part = (EntityPart)iter.next();
                try {
                    msg.append('[').append(part.getName()).append("={").append("headers=").append(part.getHeaders()).append(", mediaType=").append(part.getMediaType()).append(", body=").append(MultipartSupportIT.toString(part.getContent())).append('}');
                }
                catch (IOException e) {
                    Assertions.fail((String)("Unable to proces Entityparts." + e));
                }
                if (iter.hasNext()) {
                    msg.append("], ");
                    continue;
                }
                msg.append(']');
            }
            return msg.toString();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(InputStream in) throws IOException {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[32];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            String string = out.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            in.close();
        }
    }

    private static EntityPart find(Collection<EntityPart> parts, String name) {
        for (EntityPart part : parts) {
            if (!name.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    private static URI createCombinedUri(URI uri, String path) throws URISyntaxException {
        if (path == null || path.isEmpty()) {
            return uri;
        }
        String uriString = uri.toString();
        TestUtil.logMsg("Initial uri string: " + uriString);
        StringBuilder builder = new StringBuilder(uriString);
        if (builder.charAt(builder.length() - 1) == '/') {
            if (path.charAt(0) == '/') {
                builder.append(path.substring(1));
            } else {
                builder.append(path);
            }
        } else if (path.charAt(0) == '/') {
            builder.append(path.substring(1));
        } else {
            builder.append('/').append(path);
        }
        String builderString = builder.toString();
        TestUtil.logMsg("Combined uri string: " + builderString);
        return new URI(builderString);
    }

    @Path(value="/test")
    public static class TestResource {
        @POST
        @Consumes(value={"multipart/form-data"})
        @Produces(value={"multipart/form-data"})
        @Path(value="/basicTest")
        public Response basicTest(List<EntityPart> parts) throws IOException {
            List<EntityPart> multipart = List.of(EntityPart.withName((String)"received-string").content(MultipartSupportIT.find(parts, "octet-stream").getContent(byte[].class)).mediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE).build(), EntityPart.withName((String)"received-file").content((String)MultipartSupportIT.find(parts, "file").getFileName().get(), MultipartSupportIT.find(parts, "file").getContent()).mediaType("application/xml").build(), EntityPart.withName((String)"added-input-stream").content((InputStream)new ByteArrayInputStream("Add part on return.".getBytes())).mediaType("text/asciidoc").header("Header1", new String[]{"Test1"}).header("Header2", new String[]{"Test2"}).build());
            return Response.ok((Object)new GenericEntity<List<EntityPart>>(multipart){}, (String)"multipart/form-data").build();
        }

        @POST
        @Consumes(value={"multipart/form-data"})
        @Produces(value={"multipart/form-data"})
        @Path(value="/multi-form-param")
        public Response multipleFormParamTest(@FormParam(value="string-part") String string, @FormParam(value="entity-part") EntityPart entityPart, @FormParam(value="input-stream-part") InputStream in) throws IOException {
            List<EntityPart> multipart = List.of(EntityPart.withName((String)"received-entity-part").content(entityPart.getContent(String.class)).mediaType(entityPart.getMediaType()).fileName((String)entityPart.getFileName().orElse(null)).build(), EntityPart.withName((String)"received-input-stream").content((Object)MultipartSupportIT.toString(in).getBytes(StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE).build(), EntityPart.withName((String)"received-string").content((Object)string).mediaType(MediaType.TEXT_PLAIN_TYPE).build());
            return Response.ok((Object)new GenericEntity<List<EntityPart>>(multipart){}, (String)"multipart/form-data").build();
        }
    }

    @ApplicationPath(value="/")
    public static class MultipartTestApplication
    extends Application {
    }
}

