/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.client.invocationbuilder;

import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Map;

@Path(value="resource")
public class Resource {
    @GET
    @Path(value="languages")
    public String languages(@Context HttpHeaders headers) {
        return JaxrsUtil.iterableToString(" ", headers.getAcceptableLanguages());
    }

    @GET
    @Path(value="headerstostring")
    public String headersToString(@Context HttpHeaders headers) {
        MultivaluedMap map = headers.getRequestHeaders();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry header : map.entrySet()) {
            sb.append((String)header.getKey()).append(":").append(JaxrsUtil.iterableToString(" ", (Iterable)header.getValue())).append(";");
        }
        return sb.toString();
    }

    @GET
    @Path(value="cookie")
    public String cookie(@CookieParam(value="tck") String cookie) {
        return cookie;
    }

    @GET
    @Path(value="allow")
    public String allow() {
        return "allow";
    }

    @DELETE
    @Path(value="forbid")
    public String forbid() {
        return "forbid";
    }

    @GET
    @Path(value="get")
    public String get() {
        return "get";
    }

    @HEAD
    @Path(value="head")
    public String head() {
        return "head";
    }

    @PUT
    @Path(value="put")
    public String put(String value) {
        return value;
    }

    @POST
    @Path(value="post")
    public String post(String value) {
        return value;
    }

    @DELETE
    @Path(value="delete")
    public String delete() {
        return "delete";
    }

    @OPTIONS
    @Path(value="options")
    public String options() {
        return "options";
    }
}

