/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.inner;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.api.chunk.AbstractItemWriter;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.batch.api.chunk.listener.AbstractItemProcessListener;
import jakarta.batch.api.chunk.listener.AbstractItemWriteListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;

public class ListenerOnErrorArtifacts {
    private static int failOn = 8;
    private static int max = 10;

    @Named(value="ListenerOnErrorArtifacts.PL")
    public static class PL
    extends AbstractItemProcessListener {
        @Inject
        JobContext jobCtx;

        public void onProcessError(Object item, Exception ex) throws Exception {
            this.jobCtx.setExitStatus(item.toString());
        }
    }

    @Named(value="ListenerOnErrorArtifacts.WL")
    public static class WL
    extends AbstractItemWriteListener {
        @Inject
        JobContext jobCtx;

        public void onWriteError(List<Object> items, Exception e) throws Exception {
            this.jobCtx.setExitStatus(items.toString());
        }
    }

    @Named(value="ListenerOnErrorArtifacts.W")
    public static class W
    extends AbstractItemWriter {
        int writeCount = 0;
        @Inject
        @BatchProperty(name="write.fail")
        String failString;

        public void writeItems(List<Object> items) throws Exception {
            this.writeCount += items.size();
            if (this.writeCount >= failOn) {
                throw new Exception("process fail immediate");
            }
        }
    }

    @Named(value="ListenerOnErrorArtifacts.P")
    public static class P
    implements ItemProcessor {
        @Inject
        @BatchProperty(name="process.fail")
        String failString;

        public Object processItem(Object item) throws Exception {
            int itemNum = (Integer)item;
            if (Boolean.parseBoolean(this.failString) && itemNum == failOn) {
                throw new Exception("process fail immediate");
            }
            return 2 * itemNum;
        }
    }

    @Named(value="ListenerOnErrorArtifacts.R")
    public static class R
    extends AbstractItemReader {
        int i = 0;

        public Object readItem() throws Exception {
            if (this.i < max) {
                return this.i++;
            }
            return null;
        }
    }
}

