/*
 * Decompiled with CFR 0.152.
 */
package com.github.peterwippermann.junit4.parameterizedsuite.util;

import com.github.peterwippermann.junit4.parameterizedsuite.util.BlockJUnit4ClassRunnerUtil;
import com.github.peterwippermann.junit4.parameterizedsuite.util.ParentRunnerUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class BlockJUnit4ClassRunnerWithParametersUtil {
    public static Object createInstanceOfParameterizedTest(TestClass testClass, Object[] parameters) throws Exception {
        InjectionType injectionType = BlockJUnit4ClassRunnerWithParametersUtil.getInjectionType(testClass);
        switch (injectionType) {
            case CONSTRUCTOR: {
                return BlockJUnit4ClassRunnerWithParametersUtil.createTestUsingConstructorInjection(testClass, parameters);
            }
            case FIELD: {
                return BlockJUnit4ClassRunnerWithParametersUtil.createTestUsingFieldInjection(testClass, parameters);
            }
        }
        throw new IllegalStateException("The injection type " + (Object)((Object)injectionType) + " is not supported.");
    }

    private static Object createTestUsingConstructorInjection(TestClass testClass, Object[] parameters) throws Exception {
        return testClass.getOnlyConstructor().newInstance(parameters);
    }

    private static Object createTestUsingFieldInjection(TestClass testClass, Object[] parameters) throws Exception {
        List<FrameworkField> annotatedFieldsByParameter = BlockJUnit4ClassRunnerWithParametersUtil.getAnnotatedFieldsByParameter(testClass);
        if (annotatedFieldsByParameter.size() != parameters.length) {
            throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + parameters.length + ".");
        }
        Object testClassInstance = testClass.getJavaClass().newInstance();
        for (FrameworkField each : annotatedFieldsByParameter) {
            Field field = each.getField();
            Parameterized.Parameter annotation = field.getAnnotation(Parameterized.Parameter.class);
            int index = annotation.value();
            try {
                field.set(testClassInstance, parameters[index]);
            }
            catch (IllegalArgumentException iare) {
                throw new Exception(testClass.getName() + ": Trying to set " + field.getName() + " with the value " + parameters[index] + " that is not the right type (" + parameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
            }
        }
        return testClassInstance;
    }

    public static List<FrameworkField> getAnnotatedFieldsByParameter(TestClass testClass) {
        return testClass.getAnnotatedFields(Parameterized.Parameter.class);
    }

    private static InjectionType getInjectionType(TestClass testClass) {
        if (BlockJUnit4ClassRunnerWithParametersUtil.fieldsAreAnnotated(testClass)) {
            return InjectionType.FIELD;
        }
        return InjectionType.CONSTRUCTOR;
    }

    private static boolean fieldsAreAnnotated(TestClass testClass) {
        return !BlockJUnit4ClassRunnerWithParametersUtil.getAnnotatedFieldsByParameter(testClass).isEmpty();
    }

    public static Statement buildStatementWithTestRules(Statement baseStatementWithChildren, final TestClass testClass, Description description, final Object[] singleParameter) {
        Object test;
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return BlockJUnit4ClassRunnerWithParametersUtil.createInstanceOfParameterizedTest(testClass, singleParameter);
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        List<TestRule> testRules = BlockJUnit4ClassRunnerUtil.getTestRules(test, testClass);
        Statement statement = BlockJUnit4ClassRunnerUtil.withTestRules(testRules, description, baseStatementWithChildren);
        statement = ParentRunnerUtil.withBeforeClasses(statement, testClass);
        statement = ParentRunnerUtil.withAfterClasses(statement, testClass);
        statement = ParentRunnerUtil.withClassRules(statement, testClass, description);
        return statement;
    }

    private static enum InjectionType {
        CONSTRUCTOR,
        FIELD;

    }
}

