/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.cli;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static Activator instance;
    private Set<Closeable> closeables = new HashSet<Closeable>();

    public void start(BundleContext context) throws Exception {
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void setInstance(Activator instance) {
        Activator.instance = instance;
    }

    public boolean addCloseable(Closeable c) {
        return this.closeables.add(c);
    }

    public boolean removeCloseable(Closeable c) {
        return this.closeables.remove(c);
    }
}

