/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.ChildBuffer;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.snapshot.StaleSnapshotException;

public class ChildBufferTest
extends TestCase {
    private TestBuffer parent;
    private ChildBuffer child;

    protected void setUp() throws Exception {
        super.setUp();
        this.parent = new TestBuffer("foo");
        this.child = new ChildBuffer((IBuffer)this.parent);
    }

    public void test1() {
        ChildBufferTest.assertEquals((String)this.parent.getDocument().get(), (String)this.child.getDocument().get());
        ChildBufferTest.assertEquals((int)2, (int)this.parent.refCount);
        ChildBufferTest.assertFalse((boolean)this.parent.isDirty());
        ChildBufferTest.assertFalse((boolean)this.child.isDirty());
    }

    public void test2() {
        this.child.addRef();
        ChildBufferTest.assertEquals((int)3, (int)this.parent.refCount);
        this.child.release();
        ChildBufferTest.assertEquals((int)2, (int)this.parent.refCount);
    }

    public void test3() throws Exception {
        this.child.getDocument().set("bar");
        ChildBufferTest.assertEquals((String)"foo", (String)this.parent.getDocument().get());
        ChildBufferTest.assertTrue((boolean)this.child.isDirty());
        ChildBufferTest.assertFalse((boolean)this.parent.isDirty());
        this.child.save(Contexts.EMPTY_CONTEXT, null);
        ChildBufferTest.assertFalse((boolean)this.child.isDirty());
        ChildBufferTest.assertFalse((boolean)this.parent.isDirty());
        ChildBufferTest.assertEquals((String)"bar", (String)this.parent.getDocument().get());
    }

    public void test4() throws Exception {
        this.child.getDocument().set("bar");
        this.parent.getDocument().set("baz");
        ChildBufferTest.assertEquals((String)"bar", (String)this.child.getDocument().get());
        ChildBufferTest.assertTrue((boolean)this.child.isDirty());
        ChildBufferTest.assertTrue((boolean)this.parent.isDirty());
        try {
            this.child.save(Contexts.EMPTY_CONTEXT, null);
            ChildBufferTest.fail();
        }
        catch (CoreException e) {
            ChildBufferTest.assertTrue((boolean)(e.getCause() instanceof StaleSnapshotException));
        }
    }

    public void test5() throws Exception {
        this.child.getDocument().set("bar");
        this.parent.getDocument().set("baz");
        this.parent.save(Contexts.EMPTY_CONTEXT, null);
        ChildBufferTest.assertFalse((boolean)this.parent.isDirty());
        ChildBufferTest.assertEquals((String)"bar", (String)this.child.getDocument().get());
        ChildBufferTest.assertTrue((boolean)this.child.isDirty());
        try {
            this.child.save(Contexts.EMPTY_CONTEXT, null);
            ChildBufferTest.fail();
        }
        catch (CoreException e) {
            ChildBufferTest.assertTrue((boolean)(e.getCause() instanceof StaleSnapshotException));
        }
    }

    private static class TestBuffer
    extends Buffer {
        int refCount = 1;

        TestBuffer(String contents) {
            super(contents);
        }

        public void addRef() {
            ++this.refCount;
        }

        public void release() {
            --this.refCount;
        }
    }
}

