/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.batik.ext.swing.AffineTransformTracker;
import org.apache.batik.ext.swing.DoubleDocument;
import org.apache.batik.ext.swing.JGridBagPanel;
import org.apache.batik.ext.swing.Resources;

public class JAffineTransformChooser
extends JGridBagPanel {
    public static final String LABEL_ANGLE = "JAffineTransformChooser.label.angle";
    public static final String LABEL_DEGREE = "JAffineTransformChooser.label.degree";
    public static final String LABEL_PERCENT = "JAffineTransformChooser.label.percent";
    public static final String LABEL_ROTATE = "JAffineTransformChooser.label.rotate";
    public static final String LABEL_SCALE = "JAffineTransformChooser.label.scale";
    public static final String LABEL_RX = "JAffineTransformChooser.label.rx";
    public static final String LABEL_RY = "JAffineTransformChooser.label.ry";
    public static final String LABEL_SX = "JAffineTransformChooser.label.sx";
    public static final String LABEL_SY = "JAffineTransformChooser.label.sy";
    public static final String LABEL_TRANSLATE = "JAffineTransformChooser.label.translate";
    public static final String LABEL_TX = "JAffineTransformChooser.label.tx";
    public static final String LABEL_TY = "JAffineTransformChooser.label.ty";
    public static final String CONFIG_TEXT_FIELD_WIDTH = "JAffineTransformChooser.config.text.field.width";
    public static final String CONFIG_TOP_PAD = "JAffineTransformChooser.config.top.pad";
    public static final String CONFIG_LEFT_PAD = "JAffineTransformChooser.config.left.pad";
    public static final String CONFIG_BOTTOM_PAD = "JAffineTransformChooser.config.bottom.pad";
    public static final String CONFIG_RIGHT_PAD = "JAffineTransformChooser.config.right.pad";
    protected AffineTransform txf;
    protected DoubleDocument txModel = new DoubleDocument();
    protected DoubleDocument tyModel = new DoubleDocument();
    protected DoubleDocument sxModel = new DoubleDocument();
    protected DoubleDocument syModel = new DoubleDocument();
    protected DoubleDocument rxModel = new DoubleDocument();
    protected DoubleDocument ryModel = new DoubleDocument();
    protected DoubleDocument rotateModel = new DoubleDocument();
    protected static final double RAD_TO_DEG = 57.29577951308232;
    protected static final double DEG_TO_RAD = Math.PI / 180;

    public JAffineTransformChooser() {
        this.build();
        this.setAffineTransform(new AffineTransform());
    }

    protected void build() {
        Component component = this.buildPanel(Resources.getString(LABEL_TRANSLATE), Resources.getString(LABEL_TX), this.txModel, Resources.getString(LABEL_TY), this.tyModel, "", "", true);
        Component component2 = this.buildPanel(Resources.getString(LABEL_SCALE), Resources.getString(LABEL_SX), this.sxModel, Resources.getString(LABEL_SY), this.syModel, Resources.getString(LABEL_PERCENT), Resources.getString(LABEL_PERCENT), true);
        Component component3 = this.buildRotatePanel();
        this.add(component, 0, 0, 1, 1, 10, 1, 1.0, 1.0);
        this.add(component2, 1, 0, 1, 1, 10, 1, 1.0, 1.0);
        this.add(component3, 0, 1, 2, 1, 10, 1, 1.0, 1.0);
    }

    protected Component buildRotatePanel() {
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        Component component = this.buildPanel(Resources.getString(LABEL_ROTATE), Resources.getString(LABEL_ANGLE), this.rotateModel, null, null, Resources.getString(LABEL_DEGREE), null, false);
        Component component2 = this.buildPanel("", Resources.getString(LABEL_RX), this.rxModel, Resources.getString(LABEL_RY), this.ryModel, null, null, false);
        jGridBagPanel.add(component, 0, 0, 1, 1, 10, 1, 1.0, 1.0);
        jGridBagPanel.add(component2, 1, 0, 1, 1, 10, 1, 1.0, 1.0);
        this.setPanelBorder(jGridBagPanel, Resources.getString(LABEL_ROTATE));
        return jGridBagPanel;
    }

    protected Component buildPanel(String string, String string2, Document document, String string3, Document document2, String string4, String string5, boolean bl) {
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        this.addToPanelAtRow(string2, document, string4, jGridBagPanel, 0);
        if (string3 != null) {
            this.addToPanelAtRow(string3, document2, string5, jGridBagPanel, 1);
        }
        if (bl) {
            this.setPanelBorder(jGridBagPanel, string);
        }
        return jGridBagPanel;
    }

    public void setPanelBorder(JComponent jComponent, String string) {
        AbstractBorder abstractBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
        int n = Resources.getInteger(CONFIG_TOP_PAD);
        int n2 = Resources.getInteger(CONFIG_LEFT_PAD);
        int n3 = Resources.getInteger(CONFIG_BOTTOM_PAD);
        int n4 = Resources.getInteger(CONFIG_RIGHT_PAD);
        abstractBorder = BorderFactory.createCompoundBorder(abstractBorder, BorderFactory.createEmptyBorder(n, n2, n3, n4));
        jComponent.setBorder(abstractBorder);
    }

    protected void addToPanelAtRow(String string, Document document, String string2, JGridBagPanel jGridBagPanel, int n) {
        JTextField jTextField = new JTextField(Resources.getInteger(CONFIG_TEXT_FIELD_WIDTH));
        ((JTextComponent)jTextField).setDocument(document);
        jGridBagPanel.add(new JLabel(string), 0, n, 1, 1, 17, 2, 0.0, 0.0);
        jGridBagPanel.add(jTextField, 1, n, 1, 1, 10, 2, 1.0, 0.0);
        jGridBagPanel.add(new JLabel(string2), 2, n, 1, 1, 17, 2, 0.0, 0.0);
    }

    public AffineTransform getAffineTransform() {
        double d = this.sxModel.getValue() / 100.0;
        double d2 = this.syModel.getValue() / 100.0;
        double d3 = this.rotateModel.getValue() * (Math.PI / 180);
        double d4 = this.rxModel.getValue();
        double d5 = this.ryModel.getValue();
        double d6 = this.txModel.getValue();
        double d7 = this.tyModel.getValue();
        double[] dArray = new double[]{d * Math.cos(d3), d * Math.sin(d3), -d2 * Math.sin(d3), d2 * Math.cos(d3), d6 + d4 - d4 * Math.cos(d3) + d5 * Math.sin(d3), d7 + d5 - d4 * Math.sin(d3) - d5 * Math.cos(d3)};
        this.txf = new AffineTransform(dArray);
        return this.txf;
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        this.txf = affineTransform;
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.txModel.setValue(dArray[4]);
        this.tyModel.setValue(dArray[5]);
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        double d2 = Math.sqrt(dArray[2] * dArray[2] + dArray[3] * dArray[3]);
        this.sxModel.setValue(100.0 * d);
        this.syModel.setValue(100.0 * d2);
        double d3 = 0.0;
        if (dArray[0] > 0.0) {
            d3 = Math.atan2(dArray[1], dArray[0]);
        }
        this.rotateModel.setValue(57.29577951308232 * d3);
        this.rxModel.setValue(0.0);
        this.ryModel.setValue(0.0);
    }

    public static AffineTransform showDialog(Component component, String string) {
        JAffineTransformChooser jAffineTransformChooser = new JAffineTransformChooser();
        AffineTransformTracker affineTransformTracker = new AffineTransformTracker(jAffineTransformChooser);
        Dialog dialog = new Dialog(component, string, true, jAffineTransformChooser, affineTransformTracker, null);
        dialog.addWindowListener(new Closer());
        dialog.addComponentListener(new DisposeOnClose());
        ((java.awt.Dialog)dialog).show();
        return affineTransformTracker.getAffineTransform();
    }

    public static Dialog createDialog(Component component, String string) {
        JAffineTransformChooser jAffineTransformChooser = new JAffineTransformChooser();
        AffineTransformTracker affineTransformTracker = new AffineTransformTracker(jAffineTransformChooser);
        Dialog dialog = new Dialog(component, string, true, jAffineTransformChooser, affineTransformTracker, null);
        dialog.addWindowListener(new Closer());
        dialog.addComponentListener(new DisposeOnClose());
        return dialog;
    }

    public static void main(String[] stringArray) {
        AffineTransform affineTransform = JAffineTransformChooser.showDialog(null, "Hello");
        if (affineTransform == null) {
            System.out.println("Cancelled");
        } else {
            System.out.println("t = " + affineTransform);
        }
    }

    static class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.hide();
        }
    }

    public static class Dialog
    extends JDialog {
        private JAffineTransformChooser chooserPane;
        private AffineTransformTracker tracker;
        public static final String LABEL_OK = "JAffineTransformChooser.label.ok";
        public static final String LABEL_CANCEL = "JAffineTransformChooser.label.cancel";
        public static final String LABEL_RESET = "JAffineTransformChooser.label.reset";
        public static final String ACTION_COMMAND_OK = "OK";
        public static final String ACTION_COMMAND_CANCEL = "cancel";

        public Dialog(Component component, String string, boolean bl, JAffineTransformChooser jAffineTransformChooser, AffineTransformTracker affineTransformTracker, ActionListener actionListener) {
            super(JOptionPane.getFrameForComponent(component), string, bl);
            this.chooserPane = jAffineTransformChooser;
            this.tracker = affineTransformTracker;
            String string2 = Resources.getString(LABEL_OK);
            String string3 = Resources.getString(LABEL_CANCEL);
            String string4 = Resources.getString(LABEL_RESET);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jAffineTransformChooser, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            JButton jButton = new JButton(string2);
            this.getRootPane().setDefaultButton(jButton);
            jButton.setActionCommand(ACTION_COMMAND_OK);
            if (affineTransformTracker != null) {
                jButton.addActionListener(affineTransformTracker);
            }
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.hide();
                }
            });
            jPanel.add(jButton);
            JButton jButton2 = new JButton(string3);
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = dialog;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        this.this$0.hide();
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.hide();
                }
            });
            jPanel.add(jButton2);
            JButton jButton3 = new JButton(string4);
            jButton3.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.reset();
                }
            });
            jPanel.add(jButton3);
            container.add((Component)jPanel, "South");
            this.pack();
            this.setLocationRelativeTo(component);
        }

        public void show() {
            this.tracker.reset();
            super.show();
        }

        public AffineTransform showDialog() {
            this.show();
            return this.tracker.getAffineTransform();
        }

        public void reset() {
            this.chooserPane.setAffineTransform(new AffineTransform());
        }

        public void setTransform(AffineTransform affineTransform) {
            if (affineTransform == null) {
                affineTransform = new AffineTransform();
            }
            this.chooserPane.setAffineTransform(affineTransform);
        }
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getComponent();
            window.dispose();
        }
    }
}

