/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.l10n.ExampleDiagramLogicMessages;

public class LogicConstants {
    public static final String TOOL_LED = "LED";
    public static final String TOOL_FLOWCONTAINER = "FlowContainer";
    public static final String TOOL_CIRCUIT = "circuit";
    public static final String TOOL_ORGATE = "OrGate";
    public static final String TOOL_ANDGATE = "AndGate";
    public static final String TOOL_XORGATE = "XORGate";
    public static final String TOOL_HALFADDER = "HalfAdder";
    public static final String TOOL_FULLADDER = "FullAdder";
    public static final String LOGIC_SHAPE_COMPARTMENT = "LogicCompartment";
    public static final String LOGIC_FLOW_COMPARTMENT = "LogicFlowCompartment";
    public static final String ICON_LED = "ledicon16.gif";
    public static final String ICON_LOGICFLOW = "logicflow16.gif";
    public static final String ICON_CIRCUIT = "circuit16.gif";
    public static final String ICON_ORGATE = "or16.gif";
    public static final String ICON_ANDGATE = "and16.gif";
    public static final String ICON_XORGATE = "xor16.gif";
    public static final String ICON_HALFADDER = "halfadder16.gif";
    public static final String ICON_FULLADDER = "fulladder16.gif";
    public static final String TOOL_CONNECTION = "wire";
    public static final String ICON_CONNECTION = "connection16.gif";

    public static List getSupportedShapes() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add(TOOL_LED);
        toReturn.add(TOOL_FLOWCONTAINER);
        toReturn.add(TOOL_CIRCUIT);
        toReturn.add(TOOL_ORGATE);
        toReturn.add(TOOL_ANDGATE);
        toReturn.add(TOOL_XORGATE);
        toReturn.add(TOOL_HALFADDER);
        toReturn.add(TOOL_FULLADDER);
        return toReturn;
    }

    public static List getSupportedConnections() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add(TOOL_CONNECTION);
        return toReturn;
    }

    public static String getShapeLocalizedType(String typeName) {
        return LogicConstants.getShapeLabel(typeName).replaceFirst("&", "");
    }

    public static String getDisplayName(String label) {
        return label.replaceFirst("&", "");
    }

    public static String getShapeLabel(String toGet) {
        if (toGet.equals(TOOL_LED)) {
            return ExampleDiagramLogicMessages.logic_LEDTool_Label;
        }
        if (toGet.equals(TOOL_FLOWCONTAINER)) {
            return ExampleDiagramLogicMessages.logic_LogicFlowTool_Label;
        }
        if (toGet.equals(TOOL_CIRCUIT)) {
            return ExampleDiagramLogicMessages.logic_CircuitTool_Label;
        }
        if (toGet.equals(TOOL_ORGATE)) {
            return ExampleDiagramLogicMessages.logic_OrGateTool_Label;
        }
        if (toGet.equals(TOOL_ANDGATE)) {
            return ExampleDiagramLogicMessages.logic_AndGateTool_Label;
        }
        if (toGet.equals(TOOL_XORGATE)) {
            return ExampleDiagramLogicMessages.logic_XORGateTool_Label;
        }
        if (toGet.equals(TOOL_HALFADDER)) {
            return ExampleDiagramLogicMessages.logic_HalfAdderTool_Label;
        }
        if (toGet.equals(TOOL_FULLADDER)) {
            return ExampleDiagramLogicMessages.logic_FullAdderTool_Label;
        }
        return ExampleDiagramLogicMessages.logic_Shape_Label;
    }
}

