/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.papyrus.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gendoc.bundle.acceleo.commons.files.CommonService;
import org.eclipse.gendoc.bundle.acceleo.gmf.service.GMFServices;
import org.eclipse.gendoc.bundle.acceleo.papyrus.Activator;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.table.Cell;
import org.eclipse.gendoc.table.Row;
import org.eclipse.gendoc.table.TableFactory;
import org.eclipse.gendoc.table.TableHeader;
import org.eclipse.gendoc.tags.handlers.IEMFModelLoaderService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TranslatedLayerCell;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.dataprovider.BodyDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.selection.ObjectsSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class PapyrusServices
extends GMFServices {
    private static final String KEY_OWNED_DIAGRAMS = "org.eclipse.gendoc.bundle.acceleo.papyrus:key_owned_diagram_map";
    private static final String ASSOCIATED_RESOURCES_SOURCE = "http://www.topcased.org/resources";
    private static final String PAPYRUS_DOCUMENTATION_STEREOTYPE_QUALIFIED_NAME = "Documentation::Documentation";
    private static final String PREFIX_WORKSPACE_RESOURCE = "WR";
    private static final String PREFIX_EXTERNAL_RESOURCE = "ER";
    private static final String PREFIX_REMOTE_RESOURCE = "RR";
    private static Pattern LINK_PATTERN = Pattern.compile("\\{@link #(\\w*)(\\s|$)*\\}");

    public List<Diagram> getDiagrams(EObject e, URI uri) {
        IEMFModelLoaderService modelLoader = (IEMFModelLoaderService)GendocServices.getDefault().getService(IEMFModelLoaderService.class);
        try {
            modelLoader.getModel(uri);
        }
        catch (ModelNotFoundException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.gendoc.bundle.acceleo.papyrus", e1.getMessage(), (Throwable)e1));
        }
        return super.getDiagrams(e, uri);
    }

    public List<Diagram> getPapyrusDiagrams(EObject object) {
        List result = this.getDiagramsUsingNotation(object);
        return result;
    }

    public List<Diagram> getPapyrusOwnedDiagrams(EObject obj) {
        String eobjKey;
        List diagrams;
        List<EStructuralFeature> ownerFeatures = this.getDiagramOwnerFeature();
        if (ownerFeatures.isEmpty() || obj == null || obj.eResource() == null || obj.eResource().getResourceSet() == null) {
            return Collections.EMPTY_LIST;
        }
        IRegistryService registry = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        if (registry == null) {
            return Collections.EMPTY_LIST;
        }
        TreeMap<String, ArrayList<Diagram>> map = (TreeMap<String, ArrayList<Diagram>>)registry.get((Object)KEY_OWNED_DIAGRAMS);
        if (map == null) {
            map = new TreeMap<String, ArrayList<Diagram>>();
            for (Resource res : obj.eResource().getResourceSet().getResources()) {
                if (!res.getURI().toString().endsWith(".notation") || res.getContents().isEmpty()) continue;
                List diagrams2 = this.getDiagrams(res);
                for (Diagram d : diagrams2) {
                    for (EStructuralFeature f : ownerFeatures) {
                        EObject owner;
                        Object value;
                        Style s = d.getStyle(f.getEContainingClass());
                        if (s == null || !((value = s.eGet(f, true)) instanceof EObject) || (owner = (EObject)value).eIsProxy()) continue;
                        String eobjKey2 = owner.eResource().getURI() + "#" + owner.eResource().getURIFragment(owner);
                        ArrayList<Diagram> dias = (ArrayList<Diagram>)map.get(eobjKey2);
                        if (dias == null) {
                            dias = new ArrayList<Diagram>();
                            map.put(eobjKey2, dias);
                        }
                        dias.add(d);
                    }
                }
            }
            registry.put((Object)KEY_OWNED_DIAGRAMS, map);
        }
        if ((diagrams = (List)map.get(eobjKey = obj.eResource().getURI() + "#" + obj.eResource().getURIFragment(obj))) == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(diagrams);
    }

    private List<EStructuralFeature> getDiagramOwnerFeature() {
        EClass style;
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        EPackage stylePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/papyrus/infra/gmfdiag/style");
        if (stylePackage != null) {
            style = (EClass)stylePackage.getEClassifier("PapyrusDiagramStyle");
            features.add(style.getEStructuralFeature("owner"));
        }
        if ((stylePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/papyrus/infra/viewpoints/policy/style")) != null) {
            style = (EClass)stylePackage.getEClassifier("PapyrusViewStyle");
            features.add(style.getEStructuralFeature("owner"));
        }
        return features;
    }

    public String getDocumentation(EObject eObject) {
        if (eObject instanceof Element) {
            EList ownedComments = ((Element)eObject).getOwnedComments();
            for (Comment comment : ownedComments) {
                if (comment.getAppliedStereotype(PAPYRUS_DOCUMENTATION_STEREOTYPE_QUALIFIED_NAME) == null) continue;
                String body = comment.getBody();
                return body;
            }
        }
        return null;
    }

    public List<String> getDocumentationResources(EObject object) {
        ArrayList<String> absolutePaths = new ArrayList<String>();
        List<URI> uris = this.getAssociatedResources(object);
        for (URI uri : uris) {
            String absolutePath;
            if (uri.isPlatform()) {
                IPath filePath = Path.fromPortableString((String)uri.toPlatformString(true));
                absolutePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + filePath;
            } else {
                absolutePath = uri.isFile() ? uri.toFileString() : uri.toString();
            }
            absolutePaths.add(absolutePath);
        }
        return absolutePaths;
    }

    /*
     * Unable to fully structure code
     */
    public String replaceLinksByNameOrLabel(String body, EObject context) {
        logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        result = "";
        m = PapyrusServices.LINK_PATTERN.matcher(body);
        startIndex = 0;
        lastIndex = 0;
        if (context != null && context.eResource() != null) ** GOTO lbl20
        diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        diag.addDiagnostic((Diagnostic)new BasicDiagnostic(2, "org.eclipse.gendoc.bundle.acceleo.papyrus", 0, String.format("error in script, invalid parameter for operation replaceLinksByNameOrLabel for text : %s", new Object[]{body}), new Object[]{body}));
        return body;
lbl-1000:
        // 1 sources

        {
            theLink = m.group(1);
            startIndex = m.start();
            linkedEObject = context.eResource().getEObject(theLink);
            if (linkedEObject == null) {
                logger.log(String.format("The linked object (%s) from %s is null", new Object[]{theLink, CommonService.getText((EObject)context)}), 2);
            }
            toInsert = null;
            toInsert = linkedEObject == null ? "UNKNOWN" : (linkedEObject instanceof NamedElement != false ? ((NamedElement)linkedEObject).getName() : CommonService.getText((EObject)linkedEObject));
            staticPart = body.substring(lastIndex, startIndex);
            result = String.valueOf(result) + staticPart + toInsert;
            lastIndex = m.end();
lbl20:
            // 2 sources

            ** while (m.find())
        }
lbl21:
        // 1 sources

        return result.concat(body.substring(lastIndex));
    }

    private List<URI> getAssociatedResources(EObject eObject) {
        EAnnotation annotation;
        if (eObject instanceof EModelElement && !(eObject instanceof EAnnotation) && (annotation = ((EModelElement)eObject).getEAnnotation(ASSOCIATED_RESOURCES_SOURCE)) != null) {
            return PapyrusServices.convertDetailsToURIs((EMap<String, String>)annotation.getDetails());
        }
        return Collections.emptyList();
    }

    private static List<URI> convertDetailsToURIs(EMap<String, String> details) {
        LinkedList<URI> uris = new LinkedList<URI>();
        for (Map.Entry detail : details) {
            String value = (String)detail.getValue();
            String prefix = ((String)detail.getKey()).substring(0, 2);
            URI uri = null;
            if (PREFIX_REMOTE_RESOURCE.equals(prefix)) {
                uri = URI.createURI((String)value, (boolean)false);
            } else if (PREFIX_EXTERNAL_RESOURCE.equals(prefix)) {
                uri = URI.createFileURI((String)value);
            } else if (PREFIX_WORKSPACE_RESOURCE.equals(prefix)) {
                uri = URI.createPlatformResourceURI((String)value, (boolean)true);
            }
            uris.add(uri);
        }
        return uris;
    }

    public Collection<org.eclipse.gendoc.table.Table> getPapyrusTables(EObject modelElement) throws org.eclipse.gendoc.services.exception.ServiceException, ServiceException {
        LinkedList<org.eclipse.gendoc.table.Table> result = null;
        URI uri = modelElement.eResource().getURI();
        Resource diResource = this.getDiResouce(modelElement, uri.trimFileExtension().appendFileExtension("notation"));
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((ResourceSet)diResource.getResourceSet());
        if (domain == null) {
            domain = TransactionalEditingDomainImpl.FactoryImpl.INSTANCE.createEditingDomain(diResource.getResourceSet());
        }
        TreeIterator i = EcoreUtil.getAllProperContents((Resource)diResource, (boolean)true);
        while (i.hasNext()) {
            Table table;
            EObject eobject = (EObject)i.next();
            if (!(eobject instanceof Table) || (table = (Table)eobject).getOwner() == null || !table.getOwner().equals(modelElement)) continue;
            if (result == null) {
                result = new LinkedList<org.eclipse.gendoc.table.Table>();
            }
            result.add(this.getGendocTable(table));
        }
        return result;
    }

    private org.eclipse.gendoc.table.Table getGendocTable(Table table) throws org.eclipse.gendoc.services.exception.ServiceException, ServiceException {
        org.eclipse.gendoc.table.Table gendocTable = TableFactory.eINSTANCE.createTable();
        gendocTable.setName(table.getName());
        gendocTable.setType(table.getTableConfiguration().getType());
        NattableModelManager nattableModelManager = (NattableModelManager)NattableModelManagerFactory.INSTANCE.createNatTableModelManager(table, (ISelectionExtractor)new ObjectsSelectionExtractor());
        ITableAxisElementProvider axisElementProvider = nattableModelManager.getTableAxisElementProvider();
        List horizontalHeader = axisElementProvider.getColumnElementsList();
        LabelProviderService labelProviderService = (LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry(table.getContext()).getService(LabelProviderService.class);
        ConfigRegistry configRegistry = new ConfigRegistry();
        configRegistry.registerConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, (Object)nattableModelManager, "NORMAL", "nattable_model_manager_id");
        configRegistry.registerConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, (Object)labelProviderService, "NORMAL", "label_provider_service_id");
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        TableHeader header = TableFactory.eINSTANCE.createTableHeader();
        for (Object axis : horizontalHeader) {
            Cell cell = TableFactory.eINSTANCE.createCell();
            cell.setLabel(this.getColumnLabel(nattableModelManager, configRegistry, serv, axis));
            header.getCells().add((Object)cell);
        }
        gendocTable.setTableheader(header);
        DataLayer dataLayer = new DataLayer((IDataProvider)new BodyDataProvider((INattableModelManager)nattableModelManager));
        ((AbstractLayer)dataLayer).setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnOverrideLabelAccumulator((ILayer)dataLayer));
        ((AbstractLayer)dataLayer).setRegionName("BODY");
        TranslatedLayerCell layer = new TranslatedLayerCell(null, (ILayer)dataLayer, 0, 0, 0, 0);
        int rowPosition = 0;
        while (rowPosition < nattableModelManager.getRowCount()) {
            boolean isEmpty = nattableModelManager instanceof ITreeNattableModelManager;
            Row row = TableFactory.eINSTANCE.createRow();
            int columnPosition = 0;
            while (columnPosition < nattableModelManager.getColumnCount()) {
                Cell cell = TableFactory.eINSTANCE.createCell();
                Object value = nattableModelManager.getDataValue(columnPosition, rowPosition);
                String label = this.getCellLabel(configRegistry, serv, (ILayerCell)layer, value);
                cell.setLabel(label);
                isEmpty = isEmpty && label.isEmpty();
                row.getCells().add((Object)cell);
                if (nattableModelManager instanceof ITreeNattableModelManager) {
                    ((ITreeNattableModelManager)nattableModelManager).getTreeList().setExpanded(rowPosition, true);
                }
                ++columnPosition;
            }
            if (!isEmpty) {
                gendocTable.getRows().add((Object)row);
            }
            ++rowPosition;
        }
        return gendocTable;
    }

    private String getCellLabel(ConfigRegistry configRegistry, LabelProviderService serv, ILayerCell layer, Object value) {
        String label = "";
        String COLLECTION_SEPARATOR = "\n";
        if (value != null) {
            if (value instanceof Collection) {
                LinkedList<String> labels = new LinkedList<String>();
                for (Object collectionElement : (Collection)value) {
                    labels.add(this.getCellLabel(configRegistry, serv, layer, collectionElement));
                }
                return String.join((CharSequence)COLLECTION_SEPARATOR, labels);
            }
            LabelProviderCellContextElementWrapper contextElement = new LabelProviderCellContextElementWrapper();
            contextElement.setObject(value);
            contextElement.setConfigRegistry((IConfigRegistry)configRegistry);
            ILabelProvider bodylabelProvider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider", (Object)contextElement);
            contextElement.setCell(layer);
            label = bodylabelProvider.getText(value);
        }
        return label;
    }

    private String getColumnLabel(NattableModelManager nattableModelManager, ConfigRegistry configRegistry, LabelProviderService serv, Object axis) {
        LabelProviderCellContextElementWrapper contextElement = new LabelProviderCellContextElementWrapper();
        contextElement.setObject(axis);
        contextElement.setConfigRegistry((IConfigRegistry)configRegistry);
        DataLayer dataLayer = new DataLayer((IDataProvider)new BodyDataProvider((INattableModelManager)nattableModelManager));
        ((AbstractLayer)dataLayer).setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnOverrideLabelAccumulator((ILayer)dataLayer));
        ((AbstractLayer)dataLayer).setRegionName("COLUMN_HEADER");
        TranslatedLayerCell layer = new TranslatedLayerCell(null, (ILayer)dataLayer, 0, 0, 0, 0);
        contextElement.setCell((ILayerCell)layer);
        ILabelProvider headerlabelProvider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider", (Object)contextElement);
        return headerlabelProvider.getText((Object)contextElement);
    }

    private Resource getDiResouce(EObject modelElement, URI notationFile) {
        Resource diResource = null;
        if (modelElement.eResource().getURI().equals(notationFile)) {
            diResource = modelElement.eResource();
        } else {
            try {
                diResource = modelElement.eResource().getResourceSet().getResource(notationFile, true);
            }
            catch (WrappedException ex) {
                IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                diag.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.bundle.acceleo.papyrus", 0, String.format("Resource %s not found", notationFile.toString()), new Object[]{modelElement}));
                ex.printStackTrace();
            }
        }
        return diResource;
    }
}

