/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.wizard.AdditionnalParameterItem;
import org.eclipse.gendoc.wizard.AdditionnalParametersComposite;
import org.eclipse.gendoc.wizard.GendocWizard;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocTemplate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GendocWizardPage
extends WizardPage {
    private Text text;
    private Text text_1;
    private Text text_2;
    private Combo combo_1;
    private ComboViewer comboViewer_1;
    private Combo outputFormatCombo;
    private ComboViewer outputFormatComboViewer;
    private final int OFFSET = 3;
    private IFile fileForTemplate;
    private AdditionnalParametersComposite addParamsComposite;
    private Button saveButton;
    private Group grpSaveAction;

    public GendocWizardPage() {
        super("wizardPage");
        this.setTitle("Documentation Generation (Default Generation)");
    }

    public void createControl(Composite parent) {
        Object elementSelected;
        int n;
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        if (this.getGWizard().getRunners().size() == 0) {
            return;
        }
        if (this.getGWizard().getRunners().size() > 1) {
            Label lblNewLabel_4 = new Label(container, 0);
            GridData gd_lblNewLabel_4 = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_lblNewLabel_4.widthHint = 89;
            lblNewLabel_4.setLayoutData((Object)gd_lblNewLabel_4);
            lblNewLabel_4.setText(" List of templates:");
            this.comboViewer_1 = new ComboViewer(container, 8);
            this.combo_1 = this.comboViewer_1.getCombo();
            GridData gd_combo_1 = new GridData(4, 0x1000000, true, false, 2, 1);
            gd_combo_1.widthHint = 475;
            this.combo_1.setLayoutData((Object)gd_combo_1);
            this.combo_1.select(0);
            this.manageTemplateCombo(this.comboViewer_1);
        }
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText("Selected File:");
        this.text = new Text(container, 2048);
        this.text.setEnabled(false);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setText("Output Format:");
        this.outputFormatComboViewer = new ComboViewer(container, 8);
        this.outputFormatCombo = this.outputFormatComboViewer.getCombo();
        this.outputFormatCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblNewLabel_2 = new Label(container, 0);
        lblNewLabel_2.setText("Output Path:");
        this.manageCombo(this.outputFormatComboViewer);
        this.text_1 = new Text(container, 2048);
        this.text_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnNewButton = new Button(container, 0);
        btnNewButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnNewButton.setText("browse...");
        Label lblNewLabel_3 = new Label(container, 0);
        lblNewLabel_3.setText("File Name:");
        this.text_2 = new Text(container, 2048);
        this.text_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        IFile[] files = this.getGWizard().getInputFiles();
        IGendocRunner selectedRunner = null;
        if (this.getGWizard().getRunners().size() == 1) {
            selectedRunner = this.getGWizard().getRunners().get(0);
            IFile[] iFileArray = files;
            n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (selectedRunner.getPattern().matcher(f.getName()).matches()) {
                    this.fileForTemplate = f;
                }
                ++n2;
            }
        } else if (this.comboViewer_1 != null && this.comboViewer_1.getSelection() instanceof StructuredSelection && (elementSelected = ((StructuredSelection)this.comboViewer_1.getSelection()).getFirstElement()) instanceof IGendocRunner) {
            selectedRunner = (IGendocRunner)elementSelected;
            IFile[] iFileArray = files;
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                IFile f = iFileArray[n];
                if (selectedRunner.getPattern().matcher(f.getName()).matches()) {
                    this.fileForTemplate = f;
                }
                ++n;
            }
        }
        if (this.fileForTemplate != null) {
            StringTokenizer token = new StringTokenizer(this.fileForTemplate.getName(), ".");
            String nomFile = token.nextToken();
            this.text.setText(this.fileForTemplate.getName());
            String directory = this.getUriText(URI.createURI((String)this.fileForTemplate.getLocationURI().toString()));
            directory = this.replacePercentBySpace(directory, 3);
            this.text_1.setText(directory);
            this.text_2.setText(nomFile);
        }
        this.manageListeners(this.outputFormatComboViewer, btnNewButton);
        Group grpAddParams = new Group(container, 32);
        grpAddParams.setText("Additionnal parameters");
        grpAddParams.setLayout((Layout)new GridLayout(1, false));
        GridData gd_grpAddParams = new GridData(4, 4, false, true, 3, 1);
        gd_grpAddParams.widthHint = 567;
        grpAddParams.setLayoutData((Object)gd_grpAddParams);
        this.addParamsComposite = new AdditionnalParametersComposite((Composite)grpAddParams);
        this.addParamsComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.addParamsComposite.setInput(selectedRunner.getAdditionnalParameters());
        this.grpSaveAction = new Group(container, 0);
        this.grpSaveAction.setText("Save Action");
        this.grpSaveAction.setLayout((Layout)new FormLayout());
        GridData gd_grpSaveAction = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_grpSaveAction.widthHint = 567;
        this.grpSaveAction.setLayoutData((Object)gd_grpSaveAction);
        this.saveButton = new Button((Composite)this.grpSaveAction, 0);
        FormData fd_btnNewButton_1 = new FormData();
        fd_btnNewButton_1.left = new FormAttachment(100, -65);
        fd_btnNewButton_1.bottom = new FormAttachment(100, -3);
        fd_btnNewButton_1.right = new FormAttachment(100);
        this.saveButton.setLayoutData((Object)fd_btnNewButton_1);
        this.saveButton.setText("Save");
        if (this.getSelected() != null) {
            this.setDescription(this.getSelected().getDescription());
        }
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                block6: {
                    if (GendocWizardPage.this.getSelected() != null) {
                        try {
                            IContainer[] result = WorkspaceResourceDialog.openFolderSelection((Shell)GendocWizardPage.this.getShell(), (String)"Folder Selection", (String)"Select an output folder", (boolean)false, (Object[])new Object[0], null);
                            if (result == null || result.length != 1) break block6;
                            IContainer folder = result[0];
                            IFile file = folder.getFile((IPath)new Path("generic_template." + GendocWizardPage.this.getSelected().getOutPutExtension()));
                            InputStream stream = GendocWizardPage.this.getSelected().getTemplate().openStream();
                            try {
                                file.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
                                MessageDialog.openInformation((Shell)GendocWizardPage.this.getShell(), (String)"Information", (String)("the generic template has been saved at :\n" + file.getFullPath().toString()));
                            }
                            catch (CoreException e1) {
                                MessageDialog.openError((Shell)GendocWizardPage.this.getShell(), (String)"Error", (String)e1.getLocalizedMessage());
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        GendocWizardPage.this.setErrorMessage("Please select an output extension");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableSave();
        Label lblYouCanSave = new Label((Composite)this.grpSaveAction, 0);
        FormData fd_lblYouCanSave = new FormData();
        fd_lblYouCanSave.top = new FormAttachment(0, 5);
        fd_lblYouCanSave.bottom = new FormAttachment(100, -7);
        fd_lblYouCanSave.left = new FormAttachment(0, 10);
        lblYouCanSave.setLayoutData((Object)fd_lblYouCanSave);
        lblYouCanSave.setText("You can save the Gendoc template used for the generation to modify it :");
        if (this.getGWizard().getRunners().size() > 1) {
            this.comboViewer_1.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object elementSelected;
                    IGendocRunner runners = GendocWizardPage.this.getSelectedRunner();
                    GendocWizardPage.this.outputFormatComboViewer.setInput((Object)runners);
                    GendocWizardPage.this.outputFormatCombo.select(0);
                    GendocWizardPage.this.setDescription(GendocWizardPage.this.getSelected().getDescription());
                    IFile[] files = GendocWizardPage.this.getGWizard().getInputFiles();
                    if (GendocWizardPage.this.comboViewer_1 != null && GendocWizardPage.this.comboViewer_1.getSelection() instanceof StructuredSelection && (elementSelected = ((StructuredSelection)GendocWizardPage.this.comboViewer_1.getSelection()).getFirstElement()) instanceof IGendocRunner) {
                        IGendocRunner runner = (IGendocRunner)elementSelected;
                        IFile[] iFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile f = iFileArray[n2];
                            if (runner.getPattern().matcher(f.getName()).matches()) {
                                GendocWizardPage.this.fileForTemplate = f;
                            }
                            ++n2;
                        }
                        GendocWizardPage.this.addParamsComposite.setInput(runner.getAdditionnalParameters());
                    }
                    GendocWizardPage.this.text.setText(GendocWizardPage.this.fileForTemplate.getName());
                    GendocWizardPage.this.getGWizard().refresh();
                }
            });
        }
    }

    private void manageListeners(ComboViewer comboViewer, Button btnNewButton) {
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContainer[] result = WorkspaceResourceDialog.openFolderSelection((Shell)GendocWizardPage.this.getShell(), (String)"Folder Selection", (String)"Select an output folder", (boolean)false, (Object[])new Object[0], null);
                if (result != null && result.length == 1) {
                    IContainer folder = result[0];
                    String repertoire = URI.createURI((String)folder.getLocationURI().toString()).devicePath().toString();
                    repertoire = GendocWizardPage.this.replacePercentBySpace(repertoire, 3);
                    GendocWizardPage.this.text_1.setText(String.valueOf(repertoire) + "/");
                    GendocWizardPage.this.getGWizard().refresh();
                }
            }
        });
        this.text_1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GendocWizardPage.this.getGWizard().refresh();
                GendocWizardPage.this.enableSave();
            }
        });
        this.text_2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GendocWizardPage.this.getGWizard().refresh();
            }
        });
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GendocWizardPage.this.setDescription(GendocWizardPage.this.getSelected().getDescription());
                GendocWizardPage.this.getGWizard().refresh();
            }
        });
    }

    private void manageTemplateCombo(ComboViewer comboViewer1) {
        comboViewer1.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    Collection coll = (Collection)inputElement;
                    return coll.toArray();
                }
                return null;
            }
        });
        comboViewer1.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IGendocRunner) {
                    return ((IGendocRunner)element).getLabel();
                }
                return null;
            }
        });
        comboViewer1.setInput(this.getGWizard().getRunners());
        this.combo_1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IGendocRunner selectedRunner = GendocWizardPage.this.getSelectedRunner();
                if (GendocWizardPage.this.outputFormatComboViewer != null && selectedRunner != null) {
                    GendocWizardPage.this.outputFormatComboViewer.setInput((Object)selectedRunner);
                    if (GendocWizardPage.this.outputFormatCombo.getItemCount() > 0) {
                        GendocWizardPage.this.outputFormatCombo.select(0);
                    }
                }
                GendocWizardPage.this.getGWizard().refresh();
            }
        });
        if (this.combo_1.getItemCount() > 0) {
            this.combo_1.select(0);
        }
    }

    private void manageCombo(ComboViewer comboViewer) {
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IGendocRunner) {
                    IGendocRunner runner = (IGendocRunner)inputElement;
                    if (runner.getGendocTemplates() == null) {
                        ILogger log = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                        log.log("runner does not have a template " + runner.getLabel(), 4);
                        return new Object[0];
                    }
                    return runner.getGendocTemplates().toArray();
                }
                return null;
            }
        });
        comboViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IGendocTemplate) {
                    return ((IGendocTemplate)element).getOutPutExtension();
                }
                return null;
            }
        });
        IGendocRunner selectedRunner = this.getSelectedRunner();
        if (selectedRunner != null) {
            comboViewer.setInput((Object)this.getSelectedRunner());
        }
        this.outputFormatCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GendocWizardPage.this.getGWizard().refresh();
                GendocWizardPage.this.enableSave();
            }
        });
        if (this.outputFormatCombo.getItemCount() > 0) {
            this.outputFormatCombo.select(0);
        }
    }

    private void enableSave() {
        if (this.grpSaveAction != null && this.getSelected() != null) {
            this.grpSaveAction.setVisible(this.getSelected().isSavable());
        }
    }

    public String getUriText(URI uri) {
        return String.valueOf(uri.trimSegments(1).devicePath().toString()) + "/";
    }

    public GendocWizard getGWizard() {
        return (GendocWizard)this.getWizard();
    }

    public String getOutputPath() {
        return this.text_1.getText();
    }

    public String getModelName() {
        return this.text_2.getText();
    }

    public boolean isCorrectExtension() {
        return Arrays.asList(this.outputFormatCombo.getItems()).contains(this.outputFormatCombo.getText());
    }

    public boolean allIsFilled() {
        if (this.combo_1 != null) {
            return this.text_1.getText().length() > 0 && this.text_2.getText().length() > 0 && this.existeTemplate() && this.outputFormatCombo.getText().length() > 0;
        }
        return this.text_1.getText().length() > 0 && this.text_2.getText().length() > 0 && this.outputFormatCombo.getText().length() > 0;
    }

    public boolean existeTemplate() {
        return this.combo_1.getText().length() > 0;
    }

    public IGendocRunner getSelectedRunner() {
        if (this.getGWizard().getRunners().size() == 1) {
            return this.getGWizard().getRunners().get(0);
        }
        if (this.getGWizard().getRunners().size() > 1 && this.comboViewer_1.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection select = (IStructuredSelection)this.comboViewer_1.getSelection();
            return (IGendocRunner)select.getFirstElement();
        }
        return null;
    }

    public IGendocTemplate getSelected() {
        if (this.outputFormatComboViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection select = (IStructuredSelection)this.outputFormatComboViewer.getSelection();
            return (IGendocTemplate)select.getFirstElement();
        }
        return null;
    }

    public String getFullOutputPath() {
        return String.valueOf(this.text_1.getText()) + this.text_2.getText() + "." + this.outputFormatCombo.getText();
    }

    public String replacePercentBySpace(String theString, int offset) {
        StringBuffer buffer = new StringBuffer(theString);
        int pos = 1;
        while (theString.contains("%")) {
            pos = theString.indexOf("%");
            theString = buffer.replace(pos, pos + offset, " ").toString();
        }
        return theString;
    }

    public String getModel() {
        return URI.createURI((String)this.fileForTemplate.getLocationURI().toString()).toString().replaceAll(".di\\z", ".notation");
    }

    public List<AdditionnalParameterItem> getAdditionnalParameters() {
        return this.addParamsComposite.getAdditionnalParametersValue();
    }
}

