/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.merge.AdditiveMergeCriterion;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMergeCriterionAware;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class AbstractMerger
implements IMerger2,
IMergeOptionAware,
IMergeCriterionAware {
    public static final String SUB_DIFF_AWARE_OPTION = "subDiffAwareOption";
    private static final Logger LOGGER = Logger.getLogger(AbstractMerger.class);
    private static final Predicate<? super Diff> HAS_UNRESOLVED_STATE = EMFComparePredicates.hasState(DifferenceState.UNRESOLVED);
    private static WeakReference<CachedMergerDelegate> cachedMergerDelegateReference;
    protected Map<Object, Object> mergeOptions = Maps.newHashMap();
    private int ranking;
    private IMerger.Registry2 registry;

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public IMerger.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(IMerger.Registry registry) {
        if (this.registry != null && registry != null) {
            throw new IllegalStateException("The registry has to be set only once.");
        }
        if (!(registry instanceof IMerger.Registry2)) {
            throw new IllegalArgumentException("The registry must implement Registry2");
        }
        this.registry = (IMerger.Registry2)registry;
    }

    @Override
    public boolean apply(IMergeCriterion criterion) {
        return criterion == null || criterion == IMergeCriterion.NONE || criterion == AdditiveMergeCriterion.INSTANCE;
    }

    @Override
    public Map<Object, Object> getMergeOptions() {
        return this.mergeOptions;
    }

    @Override
    public void setMergeOptions(Map<Object, Object> options) {
        this.mergeOptions = options;
    }

    private boolean isHandleSubDiffs() {
        if (this.mergeOptions != null) {
            Object subDiffs = this.mergeOptions.get(SUB_DIFF_AWARE_OPTION);
            return subDiffs == Boolean.TRUE;
        }
        return false;
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        Diff masterEquivalence;
        long start = System.currentTimeMillis();
        LazyLinkedHashSet<Diff> dependencies = new LazyLinkedHashSet<Diff>();
        if (AbstractMerger.isAccepting(diff, mergeRightToLeft)) {
            dependencies.addAll((Collection<Diff>)diff.getRequires());
            dependencies.addAll((Collection<Diff>)diff.getImpliedBy());
        } else {
            dependencies.addAll((Collection<Diff>)diff.getImplies());
            dependencies.addAll((Collection<Diff>)diff.getRequiredBy());
        }
        dependencies.addAll((Collection<Diff>)diff.getRefinedBy());
        if (diff.getEquivalence() != null && (masterEquivalence = this.findMasterEquivalence(diff, mergeRightToLeft)) != null && masterEquivalence != diff) {
            dependencies.add(masterEquivalence);
        }
        if (LOGGER.isDebugEnabled()) {
            Long duration = new Long(System.currentTimeMillis() - start);
            String log = String.format("getDirectMergeDependencies(Diff, boolean) - %d dependencies found in %d ms for diff %d", new Integer(dependencies.size()), duration, new Integer(diff.hashCode()));
            LOGGER.debug((Object)log);
        }
        return dependencies;
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff target, boolean mergeRightToLeft) {
        long start = System.currentTimeMillis();
        LazyLinkedHashSet<Diff> resulting = new LazyLinkedHashSet<Diff>();
        resulting.addAll(this.getImpliedMerges(target, mergeRightToLeft));
        resulting.addAll(this.getLogicallyResultingMerges(target, mergeRightToLeft));
        if (LOGGER.isDebugEnabled()) {
            Long duration = new Long(System.currentTimeMillis() - start);
            String log = String.format("getDirectResultingMerges(Diff, boolean) - %d resulting merges found in %d ms for diff %d", new Integer(resulting.size()), duration, new Integer(target.hashCode()));
            LOGGER.debug((Object)log);
        }
        return resulting;
    }

    private Collection<? extends Diff> findInterlockedOneToOneDiffs(ReferenceChange referenceChange, boolean mergeRightToLeft) {
        Object sourceValue;
        boolean sanityChecks = referenceChange.getKind() != DifferenceKind.CHANGE || referenceChange.getReference().isMany() || referenceChange.getReference().getEOpposite().isMany();
        EObject sourceContainer = ComparisonUtil.getExpectedSide(referenceChange.getMatch(), referenceChange.getSource(), mergeRightToLeft);
        if (!sanityChecks && sourceContainer != null && (sourceValue = ReferenceUtil.safeEGet(sourceContainer, (EStructuralFeature)referenceChange.getReference())) == sourceContainer) {
            Match match = referenceChange.getMatch();
            LinkedHashSet<Diff> candidates = new LinkedHashSet<Diff>();
            for (Diff diff : match.getDifferences()) {
                candidates.add(diff);
                if (diff.getEquivalence() == null) continue;
                candidates.addAll((Collection<Diff>)diff.getEquivalence().getDifferences());
            }
            return this.filterInterlockedOneToOneDiffs(candidates, referenceChange, mergeRightToLeft);
        }
        return Collections.emptyList();
    }

    private Collection<? extends Diff> filterInterlockedOneToOneDiffs(Collection<? extends Diff> diffsToCheck, ReferenceChange referenceChange, boolean mergeRightToLeft) {
        EObject sourceContainer = ComparisonUtil.getExpectedSide(referenceChange.getMatch(), referenceChange.getSource(), mergeRightToLeft);
        EReference sourceReference = referenceChange.getReference();
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        for (Diff diff : diffsToCheck) {
            if (!(diff instanceof ReferenceChange)) continue;
            EObject candidateContainer = ComparisonUtil.getExpectedSide(diff.getMatch(), diff.getSource(), mergeRightToLeft);
            EReference candidateReference = ((ReferenceChange)diff).getReference();
            if (sourceContainer != candidateContainer || sourceReference.getEOpposite() != candidateReference) continue;
            result.add(diff);
            if (diff.getEquivalence() == null) continue;
            result.addAll((Collection<Diff>)diff.getEquivalence().getDifferences());
        }
        return result;
    }

    @Override
    public Set<Diff> getDirectResultingRejections(Diff target, boolean rightToLeft) {
        long start = System.currentTimeMillis();
        LazyLinkedHashSet<Diff> directlyImpliedRejections = new LazyLinkedHashSet<Diff>();
        Conflict conflict = target.getConflict();
        if (conflict != null && conflict.getKind() == ConflictKind.REAL && AbstractMerger.isAccepting(target, rightToLeft)) {
            directlyImpliedRejections.addAll((Collection<Diff>)conflict.getDifferences());
            return Sets.filter(directlyImpliedRejections, (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(target)));
        }
        if (LOGGER.isDebugEnabled()) {
            Long duration = new Long(System.currentTimeMillis() - start);
            String log = String.format("getDirectResultingMerges(Diff, boolean) - %d implied rejections found in %d ms for diff %d", new Integer(directlyImpliedRejections.size()), duration, new Integer(target.hashCode()));
            LOGGER.debug((Object)log);
        }
        return directlyImpliedRejections;
    }

    private Diff findMasterEquivalence(Diff diff, boolean mergeRightToLeft) {
        Diff idealMasterDiff;
        EList<Diff> equivalentDiffs = diff.getEquivalence().getDifferences();
        Optional firstConflicting = Iterables.tryFind(equivalentDiffs, EMFComparePredicates.hasConflict(ConflictKind.REAL));
        if (diff instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)diff;
            idealMasterDiff = this.getMasterEquivalenceForReferenceChange(referenceChange, mergeRightToLeft);
        } else if (diff instanceof FeatureMapChange) {
            FeatureMapChange featureMapChange = (FeatureMapChange)diff;
            idealMasterDiff = this.getMasterEquivalenceForFeatureMapChange(featureMapChange, mergeRightToLeft);
        } else {
            idealMasterDiff = null;
        }
        Object masterDiff = firstConflicting.isPresent() && !this.hasRealConflict(idealMasterDiff) ? (this.hasRealConflict(diff) ? null : (Diff)firstConflicting.get()) : idealMasterDiff;
        return masterDiff;
    }

    private boolean hasRealConflict(Diff diff) {
        return diff != null && diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.REAL;
    }

    private Diff getMasterEquivalenceForFeatureMapChange(FeatureMapChange diff, boolean mergeRightToLeft) {
        if (diff.getKind() == DifferenceKind.MOVE) {
            Match valueMatch;
            EObject expectedValue;
            Comparison comparison = diff.getMatch().getComparison();
            FeatureMap.Entry entry = (FeatureMap.Entry)diff.getValue();
            if (entry.getValue() instanceof EObject && !ComparisonUtil.isContainedInFeatureMap(expectedValue = ComparisonUtil.getExpectedSide(valueMatch = comparison.getMatch((EObject)entry.getValue()), diff.getSource(), mergeRightToLeft))) {
                return (Diff)Iterators.tryFind((Iterator)diff.getEquivalence().getDifferences().iterator(), (Predicate)Predicates.instanceOf(ReferenceChange.class)).orNull();
            }
        }
        return null;
    }

    private Diff getMasterEquivalenceForReferenceChange(ReferenceChange diff, boolean mergeRightToLeft) {
        Diff masterDiff = this.getMasterEquivalenceOnReference(diff, mergeRightToLeft);
        if (masterDiff == null) {
            masterDiff = this.getMasterEquivalenceOnFeatureMap(diff, mergeRightToLeft);
        }
        return masterDiff;
    }

    private Diff getMasterEquivalenceOnReference(ReferenceChange diff, final boolean mergeRightToLeft) {
        Diff masterDiff = null;
        Predicate candidateFilter = Predicates.or(EMFComparePredicates.isDiffOnEOppositeOf(diff), EMFComparePredicates.hasSameReferenceAs(diff));
        EList<Diff> equivalentDiffs = diff.getEquivalence().getDifferences();
        Optional multiValuedAddition = Iterators.tryFind((Iterator)Iterators.filter(equivalentDiffs.iterator(), (Predicate)candidateFilter), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input instanceof ReferenceChange && ((ReferenceChange)input).getReference().isMany() && AbstractMerger.this.isAdd((ReferenceChange)input, mergeRightToLeft);
            }
        });
        UnmodifiableIterator candidateDiffs = Iterators.filter(equivalentDiffs.iterator(), (Predicate)candidateFilter);
        if (multiValuedAddition.isPresent()) {
            while (masterDiff == null && candidateDiffs.hasNext()) {
                ReferenceChange next = (ReferenceChange)candidateDiffs.next();
                if (next.getReference().isMany() && this.isAdd(next, mergeRightToLeft)) continue;
                masterDiff = (Diff)multiValuedAddition.get();
            }
        } else {
            ReferenceChange candidate = null;
            if (candidateDiffs.hasNext()) {
                candidate = (ReferenceChange)candidateDiffs.next();
            }
            while (masterDiff == null && candidateDiffs.hasNext()) {
                assert (candidate != null);
                ReferenceChange next = (ReferenceChange)candidateDiffs.next();
                if (candidate.getReference().isMany() || this.isUnset(candidate, mergeRightToLeft)) {
                    if (next.getReference().isMany() || !this.isSet(next, mergeRightToLeft)) continue;
                    masterDiff = next;
                    continue;
                }
                if (this.isSet(candidate, mergeRightToLeft)) {
                    if (!next.getReference().isMany() && !this.isUnset(next, mergeRightToLeft)) continue;
                    masterDiff = candidate;
                    continue;
                }
                candidate = next;
            }
        }
        return masterDiff;
    }

    private Diff getMasterEquivalenceOnFeatureMap(ReferenceChange diff, boolean mergeRightToLeft) {
        Comparison comparison;
        Match valueMatch;
        EObject sourceValue;
        if (diff.getKind() == DifferenceKind.MOVE && !ComparisonUtil.isContainedInFeatureMap(sourceValue = ComparisonUtil.getExpectedSide(valueMatch = (comparison = diff.getMatch().getComparison()).getMatch(diff.getValue()), diff.getSource(), mergeRightToLeft))) {
            return null;
        }
        return (Diff)Iterators.tryFind((Iterator)diff.getEquivalence().getDifferences().iterator(), (Predicate)Predicates.instanceOf(FeatureMapChange.class)).orNull();
    }

    private boolean isOneToOneAndChange(ReferenceChange diff) {
        EReference reference;
        if (diff.getKind() == DifferenceKind.CHANGE && (reference = diff.getReference()) != null && !reference.isMany()) {
            EReference eOpposite = reference.getEOpposite();
            return eOpposite != null && !eOpposite.isMany();
        }
        return false;
    }

    protected Set<Diff> getLogicallyResultingMerges(Diff diff, boolean mergeRightToLeft) {
        long start = System.currentTimeMillis();
        LazyLinkedHashSet<Diff> resulting = new LazyLinkedHashSet<Diff>();
        if (AbstractMerger.isAccepting(diff, mergeRightToLeft)) {
            resulting.addAll((Collection<Diff>)diff.getImpliedBy());
        } else {
            resulting.addAll((Collection<Diff>)diff.getImplies());
        }
        resulting.addAll((Collection<Diff>)diff.getRefines());
        if (this.isHandleSubDiffs()) {
            Iterable directSubDiffs = (Iterable)ComparisonUtil.getDirectSubDiffs(!mergeRightToLeft).apply((Object)diff);
            Iterables.addAll(resulting, (Iterable)directSubDiffs);
        }
        if (LOGGER.isDebugEnabled()) {
            Long duration = new Long(System.currentTimeMillis() - start);
            String log = String.format("getLogicallyResultingMerges(Diff, boolean) - %d merges found in %d ms for diff %d", new Integer(resulting.size()), duration, new Integer(diff.hashCode()));
            LOGGER.debug((Object)log);
        }
        return resulting;
    }

    protected Set<Diff> getImpliedMerges(Diff target, boolean mergeRightToLeft) {
        ReferenceChange refTarget;
        EList<Diff> refines;
        long start = System.currentTimeMillis();
        LazyLinkedHashSet<Diff> impliedMerges = new LazyLinkedHashSet<Diff>();
        if (AbstractMerger.isAccepting(target, mergeRightToLeft)) {
            impliedMerges.addAll((Collection<Diff>)target.getImplies());
        } else {
            impliedMerges.addAll((Collection<Diff>)target.getImpliedBy());
        }
        if (target.getEquivalence() != null) {
            impliedMerges.addAll((Collection<Diff>)target.getEquivalence().getDifferences());
            impliedMerges.remove(target);
        }
        if (target.getConflict() != null && target.getConflict().getKind() == ConflictKind.PSEUDO) {
            impliedMerges.addAll((Collection<Diff>)target.getConflict().getDifferences());
            impliedMerges.remove(target);
        }
        if (!(refines = target.getRefines()).isEmpty()) {
            HashSet impliedMergesWithTarget = Sets.newHashSet(impliedMerges);
            impliedMergesWithTarget.add(target);
            for (Diff refine : refines) {
                Collection unresolvedRefinedDiffs = Collections2.filter(refine.getRefinedBy(), HAS_UNRESOLVED_STATE);
                if (!impliedMergesWithTarget.containsAll(unresolvedRefinedDiffs) || !impliedMerges.add(refine)) continue;
                impliedMergesWithTarget.add(refine);
            }
        }
        if (target instanceof ReferenceChange && this.isOneToOneAndChange(refTarget = (ReferenceChange)target)) {
            impliedMerges.addAll(this.findInterlockedOneToOneDiffs(refTarget, mergeRightToLeft));
        }
        if (LOGGER.isDebugEnabled()) {
            Long duration = new Long(System.currentTimeMillis() - start);
            String log = String.format("getImpliedMerges(Diff, boolean) - %d implied merges found in %d ms for diff %d", new Integer(impliedMerges.size()), duration, new Integer(target.hashCode()));
            LOGGER.debug((Object)log);
        }
        return impliedMerges;
    }

    protected void copyDiff(Diff target, Monitor monitor, boolean rightToLeft) {
        if (AbstractMerger.isInTerminalState(target)) {
            return;
        }
        long start = System.currentTimeMillis();
        target.setState(DifferenceState.MERGING);
        Set<Diff> impliedMerges = this.getImpliedMerges(target, rightToLeft);
        while (!impliedMerges.isEmpty()) {
            Diff impliedMerge = impliedMerges.iterator().next();
            if (impliedMerge != target && !AbstractMerger.isInTerminalState(impliedMerge)) {
                if (AbstractMerger.isAccepting(impliedMerge, rightToLeft)) {
                    impliedMerge.setState(DifferenceState.MERGED);
                } else {
                    impliedMerge.setState(DifferenceState.DISCARDED);
                }
                impliedMerges.addAll(this.getImpliedMerges(impliedMerge, rightToLeft));
            }
            impliedMerges.remove(impliedMerge);
            impliedMerges.remove(target);
        }
        if (AbstractMerger.isAccepting(target, rightToLeft)) {
            this.accept(target, rightToLeft);
            target.setState(DifferenceState.MERGED);
        } else {
            this.reject(target, rightToLeft);
            target.setState(DifferenceState.DISCARDED);
        }
        if (LOGGER.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - start;
            LOGGER.debug((Object)("copyDiff(Diff, Monitor, Boolean) - diff " + target.hashCode() + " merged (rightToLeft: " + rightToLeft + ") in " + duration + "ms"));
        }
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        this.copyDiff(target, monitor, false);
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        this.copyDiff(target, monitor, true);
    }

    protected void accept(Diff diff, boolean rightToLeft) {
    }

    protected void reject(Diff diff, boolean rightToLeft) {
    }

    protected void mergeDiff(Diff diff, boolean rightToLeft, Monitor monitor) {
        DelegatingMerger delegate = this.getMergerDelegate(diff);
        if (rightToLeft) {
            delegate.copyRightToLeft(diff, monitor);
        } else {
            delegate.copyLeftToRight(diff, monitor);
        }
    }

    protected DelegatingMerger getMergerDelegate(Diff diff) {
        IMergeCriterion criterion = (IMergeCriterion)this.getMergeOptions().get("merge.criterion");
        return AbstractMerger.getMergerDelegate(diff, (IMerger.Registry2)this.getRegistry(), criterion);
    }

    public static DelegatingMerger getMergerDelegate(Diff diff, IMerger.Registry2 registry, IMergeCriterion criterion) {
        CachedMergerDelegate cachedMergerDelegate;
        if (cachedMergerDelegateReference != null && (cachedMergerDelegate = (CachedMergerDelegate)cachedMergerDelegateReference.get()) != null && cachedMergerDelegate.matches(diff, registry, criterion)) {
            return cachedMergerDelegate.delegatingMerger;
        }
        Iterator<IMerger> it = registry.getMergersByRankDescending(diff, criterion);
        if (!it.hasNext()) {
            throw new IllegalStateException("No merger found for diff " + diff.getClass().getSimpleName());
        }
        IMerger merger = it.next();
        DelegatingMerger delegatingMerger = new DelegatingMerger(merger, criterion);
        cachedMergerDelegateReference = new WeakReference<CachedMergerDelegate>(new CachedMergerDelegate(diff, registry, criterion, delegatingMerger));
        return delegatingMerger;
    }

    public static boolean isInTerminalState(Diff target) {
        switch (target.getState()) {
            case MERGED: 
            case DISCARDED: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAdd(ReferenceChange diff, boolean rightToLeft) {
        if (rightToLeft) {
            return this.isLeftDeleteOrRightAdd(diff);
        }
        return this.isLeftAddOrRightDelete(diff);
    }

    private boolean isLeftAddOrRightDelete(ReferenceChange diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return diff.getKind() == DifferenceKind.ADD;
        }
        return diff.getKind() == DifferenceKind.DELETE;
    }

    private boolean isLeftDeleteOrRightAdd(ReferenceChange diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return diff.getKind() == DifferenceKind.DELETE;
        }
        return diff.getKind() == DifferenceKind.ADD;
    }

    protected boolean isUnset(ReferenceChange diff, boolean mergeRightToLeft) {
        if (diff.getKind() != DifferenceKind.CHANGE) {
            return false;
        }
        boolean isUnset = false;
        Match match = diff.getMatch();
        EObject container = diff.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
        if (container == null) {
            isUnset = AbstractMerger.isAccepting(diff, mergeRightToLeft);
        } else if (!ReferenceUtil.safeEIsSet(container, (EStructuralFeature)diff.getReference())) {
            isUnset = AbstractMerger.isAccepting(diff, mergeRightToLeft);
        } else if (this.isRejecting(diff, mergeRightToLeft)) {
            EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (mergeRightToLeft ? match.getRight() : match.getLeft());
            isUnset = originContainer == null || !ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)diff.getReference());
        }
        return isUnset;
    }

    protected boolean isSet(ReferenceChange diff, boolean mergeRightToLeft) {
        if (diff.getKind() != DifferenceKind.CHANGE) {
            return false;
        }
        boolean isSet = false;
        Match match = diff.getMatch();
        EObject container = diff.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
        if (container == null) {
            isSet = this.isRejecting(diff, mergeRightToLeft);
        } else if (!ReferenceUtil.safeEIsSet(container, (EStructuralFeature)diff.getReference())) {
            isSet = this.isRejecting(diff, mergeRightToLeft);
        } else if (this.isRejecting(diff, mergeRightToLeft)) {
            EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (mergeRightToLeft ? match.getRight() : match.getLeft());
            isSet = originContainer != null && ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)diff.getReference());
        } else {
            EObject targetContainer = mergeRightToLeft ? match.getLeft() : match.getRight();
            isSet = targetContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)diff.getReference());
        }
        return isSet;
    }

    public static boolean isAccepting(Diff diff, boolean mergeRightToLeft) {
        if (diff.getSource() == DifferenceSource.RIGHT) {
            return mergeRightToLeft;
        }
        return !mergeRightToLeft;
    }

    private boolean isRejecting(Diff diff, boolean mergeRightToLeft) {
        return !AbstractMerger.isAccepting(diff, mergeRightToLeft);
    }

    protected EObject createCopy(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected <E> void addAt(List<E> list, E value, int insertionIndex) {
        if (list instanceof InternalEList) {
            if (insertionIndex < 0 || insertionIndex > list.size()) {
                ((InternalEList)list).addUnique(value);
            } else {
                ((InternalEList)list).addUnique(insertionIndex, value);
            }
        } else if (insertionIndex < 0 || insertionIndex > list.size()) {
            list.add(value);
        } else {
            list.add(insertionIndex, value);
        }
    }

    private static final class CachedMergerDelegate {
        private final Diff diff;
        private final IMerger.Registry2 registry;
        private final IMergeCriterion criterion;
        private final DelegatingMerger delegatingMerger;

        private CachedMergerDelegate(Diff diff, IMerger.Registry2 registry, IMergeCriterion criterion, DelegatingMerger delegatingMerger) {
            this.diff = diff;
            this.registry = registry;
            this.criterion = criterion;
            this.delegatingMerger = delegatingMerger;
        }

        public boolean matches(Diff otherDiff, IMerger.Registry2 otherRegistry, IMergeCriterion otherCritereon) {
            return this.diff == otherDiff && this.registry == otherRegistry && this.criterion == otherCritereon;
        }
    }

    private static class LazyLinkedHashSet<E extends EObject>
    extends LinkedHashSet<E> {
        private static final long serialVersionUID = 1L;
        private transient Collection<? extends E> delegate;
        private transient boolean set;

        protected LazyLinkedHashSet() {
        }

        private void collapse() {
            if (this.delegate != null) {
                for (EObject e : this.delegate) {
                    super.add(e);
                }
                this.delegate = null;
                this.set = false;
            }
        }

        @Override
        public Iterator<E> iterator() {
            if (this.delegate != null) {
                final Iterator iterator = this.set ? this.delegate.iterator() : ((InternalEList)this.delegate).basicIterator();
                return new Iterator<E>(){
                    private E e;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public E next() {
                        this.e = (EObject)iterator.next();
                        return this.e;
                    }

                    @Override
                    public void remove() {
                        LazyLinkedHashSet.this.collapse();
                        LazyLinkedHashSet.super.remove(this.e);
                    }
                };
            }
            return super.iterator();
        }

        @Override
        public int size() {
            if (this.delegate != null) {
                return this.delegate.size();
            }
            return super.size();
        }

        @Override
        public boolean isEmpty() {
            if (this.delegate != null) {
                return false;
            }
            return super.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (this.set) {
                return this.delegate.contains(o);
            }
            if (this.delegate != null && this.delegate.size() < 4) {
                return ((InternalEList)this.delegate).basicContains(o);
            }
            this.collapse();
            return super.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (this.set) {
                return this.delegate.containsAll(c);
            }
            if (this.delegate != null && this.delegate.size() < 4) {
                return ((InternalEList)this.delegate).basicContainsAll(c);
            }
            this.collapse();
            return super.containsAll(c);
        }

        @Override
        public boolean add(E e) {
            this.collapse();
            return super.add(e);
        }

        @Override
        public boolean remove(Object o) {
            this.collapse();
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.delegate = null;
            this.set = false;
            super.clear();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.collapse();
            return super.removeAll(c);
        }

        @Override
        public Object[] toArray() {
            if (this.delegate != null) {
                return this.delegate.toArray();
            }
            return super.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (this.delegate != null) {
                return this.delegate.toArray(a);
            }
            return super.toArray(a);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (c.isEmpty()) {
                return false;
            }
            if (this.isEmpty()) {
                if (c instanceof EObjectEList) {
                    this.delegate = c;
                } else if (c instanceof LazyLinkedHashSet) {
                    LazyLinkedHashSet other = (LazyLinkedHashSet)c;
                    if (other.delegate != null) {
                        this.delegate = other.delegate;
                        this.set = other.set;
                    } else {
                        this.delegate = c;
                        this.set = true;
                    }
                } else if (c instanceof Set) {
                    this.delegate = c;
                    this.set = true;
                } else {
                    super.addAll(c);
                }
                return true;
            }
            this.collapse();
            return super.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.collapse();
            return super.retainAll(c);
        }

        @Override
        public boolean equals(Object o) {
            this.collapse();
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            if (this.delegate != null) {
                return this.delegate.hashCode();
            }
            return super.hashCode();
        }

        @Override
        public String toString() {
            if (this.delegate != null) {
                return this.delegate.toString();
            }
            return super.toString();
        }
    }
}

