/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeAndListGroup
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object fRoot;
    private Object fCurrentTreeSelection;
    private List fExpandedTreeNodes = new ArrayList();
    private Map fCheckedStateStore = new HashMap(9);
    private List fWhiteCheckedTreeItems = new ArrayList();
    private List fListeners = new ArrayList();
    private ITreeContentProvider fTreeContentProvider;
    private IStructuredContentProvider fListContentProvider;
    private ILabelProvider fTreeLabelProvider;
    private ILabelProvider fListLabelProvider;
    private CheckboxTreeViewer fTreeViewer;
    private CheckboxTableViewer fListViewer;

    public CheckboxTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        this.fRoot = rootObject;
        this.fTreeContentProvider = treeContentProvider;
        this.fListContentProvider = listContentProvider;
        this.fTreeLabelProvider = treeLabelProvider;
        this.fListLabelProvider = listLabelProvider;
        this.createContents(parent, width, height, style);
    }

    public void aboutToOpen() {
        Object primary;
        this.determineWhiteCheckedDescendents(this.fRoot);
        this.checkNewTreeElements(this.getTreeChildren(this.fRoot));
        this.fCurrentTreeSelection = null;
        Object[] elements = this.getTreeChildren(this.fRoot);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
        this.fTreeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fListeners.add(listener);
    }

    private void addToHierarchyToCheckedStore(Object treeElement) {
        Object parent;
        if (!this.fCheckedStateStore.containsKey(treeElement)) {
            this.fCheckedStateStore.put(treeElement, new ArrayList());
        }
        if ((parent = this.fTreeContentProvider.getParent(treeElement)) != null) {
            this.addToHierarchyToCheckedStore(parent);
        }
    }

    protected boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] children = this.getTreeChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (!this.fWhiteCheckedTreeItems.contains(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean areAllElementsChecked(Object treeElement) {
        List checkedElements = (List)this.fCheckedStateStore.get(treeElement);
        if (checkedElements == null) {
            return false;
        }
        return this.getListItemsSize(treeElement) == checkedElements.size();
    }

    protected void checkNewTreeElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object currentElement = elements[i];
            boolean checked = this.fCheckedStateStore.containsKey(currentElement);
            this.fTreeViewer.setChecked(currentElement, checked);
            this.fTreeViewer.setGrayed(currentElement, checked && !this.fWhiteCheckedTreeItems.contains(currentElement));
            ++i;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.getCheckable().equals(CheckboxTreeAndListGroup.this.fTreeViewer)) {
                    CheckboxTreeAndListGroup.this.treeItemChecked(event.getElement(), event.getChecked());
                } else {
                    CheckboxTreeAndListGroup.this.listItemChecked(event.getElement(), event.getChecked(), true);
                }
                CheckboxTreeAndListGroup.this.notifyCheckStateChangeListeners(event);
            }
        });
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, width / 2, height);
        this.createListViewer(composite, width / 2, height);
        this.initialize();
    }

    protected void createListViewer(Composite parent, int width, int height) {
        this.fListViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.fListViewer.setUseHashlookup(true);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        this.fListViewer.getTable().setLayoutData((Object)data);
        this.fListViewer.setContentProvider((IContentProvider)this.fListContentProvider);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)this.fListLabelProvider);
        this.fListViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        this.fTreeViewer = new CheckboxTreeViewer(tree);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.fTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        List checked = (List)this.fCheckedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            return true;
        }
        Object[] children = this.getTreeChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (this.fCheckedStateStore.containsKey(children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object treeElement) {
        return this.areAllChildrenWhiteChecked(treeElement) && this.areAllElementsChecked(treeElement);
    }

    protected void determineWhiteCheckedDescendents(Object treeElement) {
        Object[] children = this.getTreeChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            this.determineWhiteCheckedDescendents(children[i]);
            ++i;
        }
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
    }

    public void expandAll() {
        this.fTreeViewer.expandAll();
    }

    public Iterator getAllCheckedListItems() {
        HashSet result = new HashSet();
        Iterator listCollectionsEnum = this.fCheckedStateStore.values().iterator();
        while (listCollectionsEnum.hasNext()) {
            result.addAll((List)listCollectionsEnum.next());
        }
        return result.iterator();
    }

    public Set getAllCheckedTreeItems() {
        return new HashSet(this.fCheckedStateStore.keySet());
    }

    public int getCheckedElementCount() {
        return this.fCheckedStateStore.size();
    }

    protected int getListItemsSize(Object treeElement) {
        Object[] elements = this.getListElements(treeElement);
        return elements.length;
    }

    public Table getTable() {
        return this.fListViewer.getTable();
    }

    public Tree getTree() {
        return this.fTreeViewer.getTree();
    }

    public void addTreeFilter(ViewerFilter filter) {
        this.fTreeViewer.addFilter(filter);
    }

    public void addListFilter(ViewerFilter filter) {
        this.fListViewer.addFilter(filter);
    }

    protected void grayCheckHierarchy(Object treeElement) {
        Object parent;
        if (this.fCheckedStateStore.containsKey(treeElement)) {
            return;
        }
        this.fCheckedStateStore.put(treeElement, new ArrayList());
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
        if ((parent = this.fTreeContentProvider.getParent(treeElement)) != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    public void initialCheckListItem(Object element) {
        Object parent;
        this.fCurrentTreeSelection = parent = this.fTreeContentProvider.getParent(element);
        this.listItemChecked(element, true, false);
        this.updateHierarchy(parent);
    }

    public void initialCheckTreeItem(Object element) {
        this.treeItemChecked(element, true);
    }

    protected void initialize() {
        this.fTreeViewer.setInput(this.fRoot);
    }

    protected void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List checkedListItems = (List)this.fCheckedStateStore.get(this.fCurrentTreeSelection);
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.fCurrentTreeSelection);
                checkedListItems = (List)this.fCheckedStateStore.get(this.fCurrentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.fCurrentTreeSelection);
            }
        }
        if (updatingFromSelection) {
            this.updateHierarchy(this.fCurrentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(CheckStateChangedEvent event) {
        Iterator listenersEnum = this.fListeners.iterator();
        while (listenersEnum.hasNext()) {
            ((ICheckStateListener)listenersEnum.next()).checkStateChanged(event);
        }
    }

    protected void populateListViewer(Object treeElement) {
        if (treeElement == this.fCurrentTreeSelection) {
            return;
        }
        this.fCurrentTreeSelection = treeElement;
        this.fListViewer.setInput(treeElement);
        List listItemsToCheck = (List)this.fCheckedStateStore.get(treeElement);
        if (listItemsToCheck != null) {
            Iterator listItemsEnum = listItemsToCheck.iterator();
            while (listItemsEnum.hasNext()) {
                this.fListViewer.setChecked(listItemsEnum.next(), true);
            }
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.fListeners.remove(listener);
    }

    public void selectionChanged(final SelectionChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getTable().getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement == null) {
                    CheckboxTreeAndListGroup.this.fCurrentTreeSelection = null;
                    CheckboxTreeAndListGroup.this.fListViewer.setInput(CheckboxTreeAndListGroup.this.fCurrentTreeSelection);
                    return;
                }
                CheckboxTreeAndListGroup.this.populateListViewer(selectedElement);
            }
        });
    }

    public void setAllSelections(final boolean selection) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckboxTreeAndListGroup.this.setTreeChecked(CheckboxTreeAndListGroup.this.fRoot, selection);
                CheckboxTreeAndListGroup.this.fListViewer.setAllChecked(selection);
            }
        });
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.fListViewer.setContentProvider((IContentProvider)contentProvider);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setListSorter(ViewerComparator comparator) {
        this.fListViewer.setComparator(comparator);
    }

    public void setRoot(Object newRoot) {
        this.fRoot = newRoot;
        this.initialize();
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        if (treeElement.equals(this.fCurrentTreeSelection)) {
            this.fListViewer.setAllChecked(state);
        }
        if (state) {
            Object[] listItems = this.getListElements(treeElement);
            ArrayList<Object> listItemsChecked = new ArrayList<Object>();
            int i = 0;
            while (i < listItems.length) {
                listItemsChecked.add(listItems[i]);
                ++i;
            }
            this.fCheckedStateStore.put(treeElement, listItemsChecked);
        } else {
            this.fCheckedStateStore.remove(treeElement);
        }
        this.setWhiteChecked(treeElement, state);
        this.fTreeViewer.setChecked(treeElement, state);
        this.fTreeViewer.setGrayed(treeElement, false);
        Object[] children = this.getTreeChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            this.setTreeChecked(children[i], state);
            ++i;
        }
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeComparator(ViewerComparator comparator) {
        this.fTreeViewer.setComparator(comparator);
    }

    protected void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.fWhiteCheckedTreeItems.contains(treeElement)) {
                this.fWhiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.fWhiteCheckedTreeItems.remove(treeElement);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object item = event.getElement();
        if (!this.fExpandedTreeNodes.contains(item)) {
            this.fExpandedTreeNodes.add(item);
            this.checkNewTreeElements(this.getTreeChildren(item));
        }
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.fTreeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.updateHierarchy(treeElement);
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.fCheckedStateStore.remove(treeElement);
        }
        if ((parent = this.fTreeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    protected void updateHierarchy(Object treeElement) {
        boolean whiteChecked = this.determineShouldBeWhiteChecked(treeElement);
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.fTreeViewer.setChecked(treeElement, whiteChecked || shouldBeAtLeastGray);
        this.setWhiteChecked(treeElement, whiteChecked);
        if (whiteChecked) {
            this.fTreeViewer.setGrayed(treeElement, false);
        } else {
            this.fTreeViewer.setGrayed(treeElement, shouldBeAtLeastGray);
        }
        Object parent = this.fTreeContentProvider.getParent(treeElement);
        if (parent != null) {
            this.updateHierarchy(parent);
        }
    }

    public void updateSelections(final Map items) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckboxTreeAndListGroup.this.handleUpdateSelection(items);
            }
        });
    }

    protected Object[] filter(ViewerFilter[] filters, Object[] elements) {
        if (filters != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                int j = 0;
                while (j < filters.length) {
                    add = filters[j].select(null, null, elements[i]);
                    if (!add) break;
                    ++j;
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return elements;
    }

    private Object[] getTreeChildren(Object element) {
        return this.filter(this.fTreeViewer.getFilters(), this.fTreeContentProvider.getChildren(element));
    }

    private Object[] getListElements(Object element) {
        return this.filter(this.fListViewer.getFilters(), this.fListContentProvider.getElements(element));
    }

    public Set getWhiteCheckedTreeItems() {
        return new HashSet(this.fWhiteCheckedTreeItems);
    }

    private void handleUpdateSelection(Map items) {
        for (Object key : items.keySet()) {
            List selections = (List)items.get(key);
            if (selections.size() == 0) {
                this.fCheckedStateStore.remove(key);
                continue;
            }
            this.fCheckedStateStore.put(key, selections);
            Object parent = this.fTreeContentProvider.getParent(key);
            if (parent == null) continue;
            this.addToHierarchyToCheckedStore(parent);
        }
        for (Object key : items.keySet()) {
            this.updateHierarchy(key);
            if (this.fCurrentTreeSelection == null || !this.fCurrentTreeSelection.equals(key)) continue;
            this.fListViewer.setAllChecked(false);
            this.fListViewer.setCheckedElements(((List)items.get(key)).toArray());
        }
    }

    public boolean isTreeItemGreyChecked(Object object) {
        return this.fTreeViewer.getGrayed(object);
    }

    public void expandTreeToLevel(Object object, int level) {
        this.fTreeViewer.expandToLevel(object, level);
    }

    public void setTreeSelection(ISelection selection) {
        this.fTreeViewer.setSelection(selection);
    }
}

