/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.listener;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;

public class AleWorkspaceListener
implements IResourceChangeListener {
    private static final String ALE_MARKER = "org.eclipse.emf.ecoretools.ale.xtext.AleMarker";
    Session session;
    Resource dslRes;
    Set<IFile> files;

    public AleWorkspaceListener(Session session, Resource dslRes) {
        this.session = session;
        this.files = new LinkedHashSet<IFile>();
        this.dslRes = dslRes;
    }

    public void listen(IFile file) {
        this.files.add(file);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1 && this.isMatching(event.getDelta())) {
            ArrayList<ResourceSyncClient.ResourceStatusChange> changes = new ArrayList<ResourceSyncClient.ResourceStatusChange>();
            ResourceSetSync.ResourceStatus oldStatus = ResourceSetSync.getStatus((Resource)this.dslRes);
            ResourceSetSync.ResourceStatus newStatus = ResourceSetSync.ResourceStatus.EXTERNAL_CHANGED;
            changes.add(new ResourceSyncClient.ResourceStatusChange(this.dslRes, newStatus, oldStatus));
            ResourceSetSync rsSetSync = ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.session.getTransactionalEditingDomain());
            rsSetSync.statusesChanged(changes);
        }
    }

    private boolean isMatching(IResourceDelta delta) {
        for (IFile file : this.files) {
            IResourceDelta deltaTarget = delta.findMember(file.getFullPath());
            boolean hasAleMarker = false;
            if (deltaTarget != null) {
                IMarkerDelta[] markerDeltas;
                IMarkerDelta[] iMarkerDeltaArray = markerDeltas = deltaTarget.getMarkerDeltas();
                int n = markerDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                    hasAleMarker = hasAleMarker || markerDelta.getType().equals(ALE_MARKER);
                    ++n2;
                }
            }
            if (deltaTarget == null || hasAleMarker) continue;
            return true;
        }
        return false;
    }
}

