/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class SessionLazyCrossReferencer
extends SiriusCrossReferenceAdapter {
    protected DAnalysisSessionImpl session;
    protected boolean initialized;
    private Predicate<EObject> eObjectToBeIgnoredPredicate = obj -> false;

    public SessionLazyCrossReferencer(DAnalysisSessionImpl session) {
        this.session = session;
    }

    public void dump() {
        if (!this.initialized) {
            this.initialize();
        }
        super.dump();
    }

    public void setEObjectToBeIgnored(Predicate<EObject> predicate) {
        this.eObjectToBeIgnoredPredicate = predicate;
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject object, boolean resolve) {
        if (!this.eObjectToBeIgnoredPredicate.test(object)) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.getInverseReferences(object, resolve);
        }
        return Collections.emptyList();
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject object) {
        if (!this.eObjectToBeIgnoredPredicate.test(object)) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.getInverseReferences(object);
        }
        return Collections.emptyList();
    }

    public Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject object, boolean resolve) {
        if (!this.eObjectToBeIgnoredPredicate.test(object)) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.getNonNavigableInverseReferences(object, resolve);
        }
        return Collections.emptyList();
    }

    public Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject object) {
        if (!this.eObjectToBeIgnoredPredicate.test(object)) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.getNonNavigableInverseReferences(object);
        }
        return Collections.emptyList();
    }

    public Notifier getTarget() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        if (!this.initialized) {
            this.initialize();
        }
        return super.isAdapterForType(type);
    }

    public void notifyChanged(Notification notification) {
        if (!this.initialized) {
            this.initialize();
        }
        super.notifyChanged(notification);
    }

    public void setTarget(Notifier target) {
        if (!this.initialized) {
            this.initialize();
        }
        super.setTarget(target);
    }

    public void unsetTarget(Notifier target) {
        if (!this.initialized) {
            this.initialize();
        }
        super.unsetTarget(target);
    }

    protected void handleContainment(Notification notification) {
        this.deregisterDeletedElements(notification);
        super.handleContainment(notification);
    }

    protected void deregisterDeletedElements(Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 4: {
                Object oldValue = notification.getOldValue();
                if (!(oldValue instanceof Notifier)) break;
                this.removeAdapterIfNecessary(notification, (Notifier)oldValue);
                break;
            }
            case 6: {
                for (Notifier oldVal : Iterables.filter((Iterable)((Collection)notification.getOldValue()), Notifier.class)) {
                    this.removeAdapterIfNecessary(notification, oldVal);
                }
                break;
            }
        }
    }

    private void removeAdapterIfNecessary(Notification notification, Notifier oldValue) {
        boolean toRemove = true;
        if (oldValue instanceof EObject) {
            EObject removedEObject = (EObject)oldValue;
            EObject currentContainer = removedEObject.eContainer();
            if (currentContainer == null) {
                currentContainer = removedEObject.eResource();
            }
            if (currentContainer != null && currentContainer != notification.getNotifier() && currentContainer.eAdapters().contains((Object)this)) {
                toRemove = false;
            }
        }
        if (toRemove) {
            this.removeAdapter(oldValue);
        }
    }

    public DAnalysisSessionImpl getSession() {
        return this.session;
    }

    protected void initialize() {
        EList adapters;
        this.initialized = true;
        Collection<Resource> semanticResources = this.session.getSemanticResources();
        EList<Resource> controlledResources = this.session.getControlledResources();
        Set<Resource> allSessionResources = this.session.getAllSessionResources();
        Collection<Resource> srmFiles = this.session.getSrmResources();
        Iterable resources = Iterables.concat(semanticResources, controlledResources, allSessionResources);
        for (Resource resource : resources) {
            adapters = resource.eAdapters();
            if (adapters.contains((Object)this)) continue;
            adapters.add(this);
        }
        for (Resource resource : srmFiles) {
            EcoreUtil.resolveAll((Resource)resource);
            adapters = resource.eAdapters();
            if (adapters.contains((Object)this)) continue;
            adapters.add(this);
        }
    }

    protected void selfAdapt(Notification notification) {
        if (SessionLazyCrossReferencer.isTopLevelRepresentationRemoval(notification) && !this.unloadedResources.contains(notification.getNotifier())) {
            this.handleContainment(notification);
        }
        super.selfAdapt(notification);
    }

    public void resolveProxyCrossReferences(Resource resource) {
        if (this.initialized) {
            super.resolveProxyCrossReferences(resource);
        }
    }

    public static boolean isTopLevelRepresentationRemoval(Notification notification) {
        boolean isRepresentationRemoval;
        boolean isResourceContentChange;
        Object notifier = notification.getNotifier();
        boolean bl = isResourceContentChange = notifier instanceof Resource && notification.getFeatureID(Resource.class) == 2;
        if (notification.getEventType() == 4 && notification.getOldValue() instanceof DRepresentation) {
            isRepresentationRemoval = true;
        } else if (notification.getEventType() == 6) {
            Collection removed = (Collection)notification.getOldValue();
            isRepresentationRemoval = Iterables.all((Iterable)removed, (com.google.common.base.Predicate)Predicates.instanceOf(DRepresentation.class));
        } else {
            isRepresentationRemoval = false;
        }
        return isResourceContentChange && isRepresentationRemoval;
    }
}

