/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.history.SortableRefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ShowRefactoringHistoryControl
extends SortableRefactoringHistoryControl {
    private Button fDeleteAllButton = null;
    private Button fDeleteButton = null;

    public ShowRefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, configuration);
    }

    @Override
    protected void createBottomButtonBar(Composite parent) {
    }

    @Override
    public void createControl() {
        super.createControl();
        GridData data = new GridData(1808);
        data.heightHint = new PixelConverter((Control)this).convertHeightInCharsToPixels(24);
        this.setLayoutData(data);
    }

    protected void createDeleteAllButton(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fDeleteAllButton = new Button(parent, 0);
        this.fDeleteAllButton.setEnabled(false);
        this.fDeleteAllButton.setText(RefactoringUIMessages.ShowRefactoringHistoryControl_delete_all_label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fDeleteAllButton);
        this.fDeleteAllButton.setLayoutData((Object)data);
    }

    protected void createDeleteButton(Composite parent, int alignment) {
        Assert.isNotNull((Object)parent);
        this.fDeleteButton = new Button(parent, 0);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.setText(RefactoringUIMessages.ShowRefactoringHistoryControl_delete_label);
        GridData data = new GridData();
        data.horizontalAlignment = alignment;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fDeleteButton);
        this.fDeleteButton.setLayoutData((Object)data);
    }

    @Override
    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.fControlConfiguration.isCheckableViewer()) {
            return new RefactoringHistoryControl.RefactoringHistoryTreeViewer(parent, 770);
        }
        return new TreeViewer(parent, 770);
    }

    @Override
    protected void createRightButtonBar(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        composite.setLayoutData((Object)data);
        this.createDeleteButton(composite, 4);
        this.createDeleteAllButton(composite);
    }

    @Override
    protected void createSelectionLabel(Composite parent) {
    }

    @Override
    protected int getContainerColumns() {
        return 2;
    }

    public Button getDeleteAllButton() {
        return this.fDeleteAllButton;
    }

    public Button getDeleteButton() {
        return this.fDeleteButton;
    }

    @Override
    protected int getDetailColumns() {
        return 1;
    }

    @Override
    protected void handleCheckStateChanged() {
        super.handleCheckStateChanged();
        if (this.fDeleteButton != null) {
            this.fDeleteButton.setEnabled(this.getCheckedDescriptors().length > 0);
        }
    }

    @Override
    protected void handleSelectionChanged(IStructuredSelection selection) {
        super.handleSelectionChanged(selection);
        if (this.fDeleteButton != null) {
            this.fDeleteButton.setEnabled(this.getCheckedDescriptors().length > 0);
        }
    }

    @Override
    public void setInput(RefactoringHistory history) {
        super.setInput(history);
        if (this.fDeleteAllButton != null) {
            this.fDeleteAllButton.setEnabled(history != null && !history.isEmpty());
        }
        if (this.fDeleteButton != null) {
            this.fDeleteButton.setEnabled(false);
        }
    }
}

