/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.FieldChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.IModelChangeListenerAddon;

public class SimpleModelChangeListenerAddon
implements IEngineAddon,
IModelChangeListenerAddon {
    private EContentAdapter adapter;
    private IExecutionEngine<?> engine;
    private Map<IEngineAddon, List<FieldChange>> changes;
    private Set<IEngineAddon> registeredAddons;

    private void addFeatureChange(EStructuralFeature feature, EObject eObject, Object value, FieldChange.ChangeType changeType) {
        this.registeredAddons.stream().forEach(addon -> {
            boolean bl = this.changes.get(addon).add(new FieldChange(feature, eObject, value, changeType));
        });
    }

    public SimpleModelChangeListenerAddon(IExecutionEngine<?> engine) {
        this.engine = engine;
        this.changes = new HashMap<IEngineAddon, List<FieldChange>>();
        this.registeredAddons = new HashSet<IEngineAddon>();
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                int eventType = notification.getEventType();
                Object notifier = notification.getNotifier();
                if (eventType < 10 && notifier instanceof EObject && !notification.isTouch()) {
                    switch (notification.getEventType()) {
                        case 3: 
                        case 5: {
                            SimpleModelChangeListenerAddon.this.addFeatureChange((EStructuralFeature)notification.getFeature(), (EObject)notification.getNotifier(), notification.getNewValue(), FieldChange.ChangeType.ADD);
                            break;
                        }
                        case 4: 
                        case 6: {
                            SimpleModelChangeListenerAddon.this.addFeatureChange((EStructuralFeature)notification.getFeature(), (EObject)notification.getNotifier(), notification.getOldValue(), FieldChange.ChangeType.REMOVE);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 7: {
                            SimpleModelChangeListenerAddon.this.addFeatureChange((EStructuralFeature)notification.getFeature(), (EObject)notification.getNotifier(), notification.getNewValue(), FieldChange.ChangeType.MODIFY);
                        }
                    }
                }
            }
        };
        Set allResources = EMFResource.getRelatedResources((Resource)((IExecutionContext)this.engine.getExecutionContext()).getResourceModel());
        allResources.stream().forEach(r -> {
            if (r != null) {
                r.eAdapters().add((Object)this.adapter);
            }
        });
    }

    @Override
    public List<FieldChange> getChanges(IEngineAddon addon) {
        List<FieldChange> result = this.changes.get(addon);
        if (this.registeredAddons.contains(addon)) {
            this.changes.put(addon, new ArrayList());
        }
        return result;
    }

    @Override
    public boolean registerAddon(IEngineAddon addon) {
        boolean res = this.registeredAddons.add(addon);
        if (res) {
            this.changes.put(addon, new ArrayList());
        }
        return res;
    }

    @Override
    public void engineAboutToStop(IExecutionEngine<?> engine) {
        Set allResources = EMFResource.getRelatedResources((Resource)((IExecutionContext)this.engine.getExecutionContext()).getResourceModel());
        allResources.stream().forEach(r -> r.eAdapters().remove((Object)this.adapter));
    }
}

