/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.core.resources;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFolderUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.ProjectDescriptor;
import org.osgi.framework.Bundle;

public class IFileUtils {
    static String lineSeparator = System.getProperty("line.separator");

    public static IFile getIFileFromWorkspaceOrFileSystem(Path path) throws CoreException {
        IFile resultingIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (!resultingIFile.exists()) {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject("ExternalFiles");
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            if (path.segmentCount() == 1) {
                resultingIFile = project.getFile(path.lastSegment());
            } else {
                IFolder folder = IProjectUtils.createFolder(project, path.removeLastSegments(1), null);
                resultingIFile = folder.getFile(path.lastSegment());
            }
            if (!resultingIFile.isLinked()) {
                resultingIFile.createLink((IPath)path, 0, null);
            }
        }
        return resultingIFile;
    }

    public static IFile getIFileFromWorkspaceOrFileSystem(String path) throws CoreException {
        return IFileUtils.getIFileFromWorkspaceOrFileSystem(new Path(path));
    }

    public static void writeInFileIfDifferent(IFile file, String contents, IProgressMonitor monitor) throws CoreException, IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        try {
            if (file.exists()) {
                if (!IFileUtils.isStreamEqual(stream, file.getContents(true))) {
                    stream = new ByteArrayInputStream(contents.getBytes("UTF-8"));
                    file.setContents((InputStream)stream, true, true, monitor);
                }
            } else {
                if (file.getParent() instanceof IFolder && !file.getParent().exists()) {
                    IFolderUtils.create((IFolder)file.getParent(), true, true, monitor);
                }
                file.create((InputStream)stream, true, monitor);
            }
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeInFile(IFile file, String contents, IProgressMonitor monitor) throws CoreException, IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        if (file.exists()) {
            file.setContents((InputStream)stream, true, true, monitor);
        } else {
            if (file.getParent() instanceof IFolder && !file.getParent().exists()) {
                IFolderUtils.create((IFolder)file.getParent(), true, true, monitor);
            }
            file.create((InputStream)stream, true, monitor);
        }
        ((InputStream)stream).close();
    }

    public static void addMarker(IFile file, String markerType, String message, int severity) throws CoreException {
        IMarker marker = file.createMarker(markerType);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", severity);
        marker.setAttribute("lineNumber", 1);
    }

    public static String getStringContent(IFile file) throws CoreException, IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF_8));
        String str = null;
        StringBuilder sb = new StringBuilder();
        while ((str = r.readLine()) != null) {
            sb.append(String.valueOf(str) + '\n');
        }
        return sb.toString();
    }

    public static void copy(InputStream inStream, OutputStream outStream, int bufferSize) throws IOException {
        int nbRead;
        byte[] buffer = new byte[bufferSize];
        while ((nbRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, nbRead);
        }
    }

    public static void copyDirectory(File from, File to) throws IOException {
        if (!to.exists()) {
            to.mkdir();
        }
        File[] inDir = from.listFiles();
        int i = 0;
        while (i < inDir.length) {
            File file = inDir[i];
            IFileUtils.copy(file, new File(to, file.getName()));
            ++i;
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        FileInputStream inStream = new FileInputStream(from);
        FileOutputStream outStream = new FileOutputStream(to);
        IFileUtils.copy(inStream, outStream, (int)Math.min(from.length(), 4096L));
        ((InputStream)inStream).close();
        ((OutputStream)outStream).close();
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isFile()) {
            IFileUtils.copyFile(from, to);
        } else if (from.isDirectory()) {
            IFileUtils.copyDirectory(from, to);
        } else {
            throw new FileNotFoundException(String.valueOf(from.toString()) + " does not exist");
        }
    }

    public static void unZip(IProject project, ProjectDescriptor projectDesc) throws IOException {
        URL interpreterZipUrl = FileLocator.find((Bundle)Platform.getBundle((String)projectDesc.getBundleName()), (IPath)new Path(projectDesc.getZipLocation()), null);
        ZipInputStream zipFileStream = new ZipInputStream(interpreterZipUrl.openStream());
        ZipEntry zipEntry = zipFileStream.getNextEntry();
        while (zipEntry != null) {
            File file = new File(project.getLocation().toString(), zipEntry.getName());
            if (!zipEntry.isDirectory()) {
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                try (FileOutputStream os = null;){
                    os = new FileOutputStream(file);
                    byte[] buffer = new byte[102400];
                    while (true) {
                        int len = zipFileStream.read(buffer);
                        if (zipFileStream.available() == 0) {
                            break;
                        }
                        ((OutputStream)os).write(buffer, 0, len);
                    }
                }
            }
            zipFileStream.closeEntry();
            zipEntry = zipFileStream.getNextEntry();
        }
    }

    private static boolean isStreamEqual(InputStream i1, InputStream i2) throws IOException {
        ReadableByteChannel ch1 = Channels.newChannel(i1);
        ReadableByteChannel ch2 = Channels.newChannel(i2);
        ByteBuffer buf1 = ByteBuffer.allocateDirect(1024);
        ByteBuffer buf2 = ByteBuffer.allocateDirect(1024);
        try {
            while (true) {
                int n1 = ch1.read(buf1);
                int n2 = ch2.read(buf2);
                if (n1 == -1 || n2 == -1) {
                    boolean bl = n1 == n2;
                    return bl;
                }
                buf1.flip();
                buf2.flip();
                int i = 0;
                if (i < Math.min(n1, n2)) {
                }
                buf1.compact();
                buf2.compact();
            }
        }
        finally {
            if (i1 != null) {
                i1.close();
            }
            if (i2 != null) {
                i2.close();
            }
        }
    }
}

