/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.adapter;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.ThreadUtils;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.DSLEclipseDebugIntegration;
import org.eclipse.gemoc.dsl.debug.ide.adapter.AbstractDSLDebugElementAdapter;
import org.eclipse.gemoc.dsl.debug.ide.event.model.SetVariableValueRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ValidateVariableValueRequest;

public class DSLVariableAdapter
extends AbstractDSLDebugElementAdapter
implements IVariable {
    public DSLVariableAdapter(DSLEclipseDebugIntegration factory) {
        super(factory);
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || type == IVariable.class;
    }

    protected Variable getHost() {
        assert (this.target instanceof Variable);
        return (Variable)this.target;
    }

    public void setValue(String expression) throws DebugException {
        this.factory.getDebugger().handleEvent(new SetVariableValueRequest(ThreadUtils.getThread((StackFrame)this.getHost().getFrame()).getName(), this.getHost().getFrame().getName(), this.getHost().getName(), expression));
    }

    public void setValue(IValue value) throws DebugException {
        this.factory.getDebugger().handleEvent(new SetVariableValueRequest(ThreadUtils.getThread((StackFrame)this.getHost().getFrame()).getName(), this.getHost().getFrame().getName(), this.getHost().getName(), value.getValueString()));
    }

    public boolean supportsValueModification() {
        return this.getHost().isSupportModifications();
    }

    public boolean verifyValue(String expression) throws DebugException {
        Object response = this.factory.getDebugger().handleEvent(new ValidateVariableValueRequest(ThreadUtils.getThread((StackFrame)this.getHost().getFrame()).getName(), this.getHost().getFrame().getName(), this.getHost().getName(), expression));
        return Boolean.TRUE == response;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        Object response = this.factory.getDebugger().handleEvent(new ValidateVariableValueRequest(ThreadUtils.getThread((StackFrame)this.getHost().getFrame()).getName(), this.getHost().getFrame().getName(), this.getHost().getName(), value.getValueString()));
        return Boolean.TRUE == response;
    }

    public IValue getValue() throws DebugException {
        return this.factory.getValue(this.getHost().getDeclarationType(), this.getHost().getValue());
    }

    public String getName() throws DebugException {
        return this.getHost().getName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getHost().getDeclarationType();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.getHost().isValueChanged();
    }
}

