/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ide;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.services.RoomGrammarAccess;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.IModelPathProvider;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;

public class RoomIdeContentProposalProvider
extends IdeContentProposalProvider {
    @Inject
    private RoomGrammarAccess grammarAccess;
    @Inject
    protected IModelPathProvider modelPathProvider;
    private static final String ACTOR_CLASS_SNIPPET = "ActorClass ${1:ActorClassName} {\n\tInterface {\n\t\t$0\n\t}\n\tStructure {\n\n\t}\n\tBehavior {\n\t}\n}\n";
    private static final String PROTOCOL_CLASS_SNIPPET = "ProtocolClass ${1:ProtocolClassName} {\n\tincoming {\n\t\tMessage ${2:in1}(${3:type})$0\n\t}\n\toutgoing {\n\t}\n}\n";
    private static final String DATA_CLASS_SNIPPET = "DataClass ${1:DataClassName} {\n\tAttribute ${2:Attr1}: ${3:type}\n}\n";
    private static final String EXTERNAL_TYPE_SNIPPET = "ExternalType ${1:name} -> \"${2:typeName}\"$0";
    private static final String PRIMITIVE_TYPE_SNIPPET = "PrimitiveType ${1:name}: ${2|ptBoolean,ptInteger,ptReal,ptCharacter|} -> \"${3:typeName}\" default \"${4:defaultValueLiteral}\"$0";
    private static final String MESSAGE_SNIPPET = "Message ${1:name}(${2:type})$0";
    private static final String PORT_SNIPPET = "Port ${1:name}: ${2:protocol}";
    private static final String SAP_SNIPPET = "SAP ${1:name}: ${2:protocol}";
    private static final String SPP_SNIPPET = "SPP ${1:name}: ${2:protocol}";
    private static final String ATTRIBUTE_SNIPPET = "Attribute ${1:name}: ${2:type}";
    private static final String OPERATION_SNIPPET = "Operation ${1:name}(${2:param}: ${3:ptype}): ${4:rtype} '''\n\t$0\n'''\n";
    private static final String STATE_SNIPPET = "State ${1:name} {\n\tentry '''// entry code'''\n\texit '''// exit code'''\n\tsubgraph {\n\t}\n}$0\n";
    private static final String REFINED_STATE_SNIPPET = "RefinedState ${1:base} {\n\t$0\n}\n";

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        super._createProposals(keyword, context, acceptor);
        this.createSnippetProposals(keyword, context, acceptor);
    }

    private void createSnippetProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (keyword == this.grammarAccess.getRoomModelAccess().getRoomModelKeyword_0()) {
            IModelPath modelPath = this.modelPathProvider.get((Resource)context.getResource());
            Optional modelPathFQN = modelPath.getQualifiedName(context.getResource().getURI());
            String modelName = modelPathFQN.map(fqn -> fqn.toString()).orElse(context.getResource().getURI().trimFileExtension().lastSegment());
            this.createSnippet(this.roomModelSnippet(modelName), keyword, "room model snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getActorClassAccess().getActorClassKeyword_1()) {
            this.createSnippet(ACTOR_CLASS_SNIPPET, keyword, "actor class snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getProtocolClassAccess().getProtocolClassKeyword_1()) {
            this.createSnippet(PROTOCOL_CLASS_SNIPPET, keyword, "protocol class snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getDataClassAccess().getDataClassKeyword_0()) {
            this.createSnippet(DATA_CLASS_SNIPPET, keyword, "data class snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getExternalTypeAccess().getExternalTypeKeyword_0()) {
            this.createSnippet(EXTERNAL_TYPE_SNIPPET, keyword, "external type snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getPrimitiveTypeAccess().getPrimitiveTypeKeyword_0()) {
            this.createSnippet(PRIMITIVE_TYPE_SNIPPET, keyword, "primitive type snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getMessageAccess().getMessageKeyword_1()) {
            this.createSnippet(MESSAGE_SNIPPET, keyword, "message snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getPortAccess().getPortKeyword_2()) {
            this.createSnippet(PORT_SNIPPET, keyword, "port snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getSAPAccess().getSAPKeyword_0()) {
            this.createSnippet(SAP_SNIPPET, keyword, "service access point snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getSPPAccess().getSPPKeyword_0()) {
            this.createSnippet(SPP_SNIPPET, keyword, "service provision point snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getAttributeAccess().getAttributeKeyword_0()) {
            this.createSnippet(ATTRIBUTE_SNIPPET, keyword, "attribute snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getStandardOperationAccess().getOperationKeyword_1()) {
            this.createSnippet(OPERATION_SNIPPET, keyword, "operation snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getSimpleStateAccess().getStateKeyword_0()) {
            this.createSnippet(STATE_SNIPPET, keyword, "state snippet", context, acceptor);
        } else if (keyword == this.grammarAccess.getRefinedStateAccess().getRefinedStateKeyword_0()) {
            this.createSnippet(REFINED_STATE_SNIPPET, keyword, "refined state snippet", context, acceptor);
        }
    }

    private void createSnippet(String poposal, Keyword keyword, String description, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry contentAssistEntry = this.getProposalCreator().createProposal(poposal, context.getPrefix(), context, "SNIPPET", entry -> {
            entry.setLabel(keyword.getValue());
            entry.setDescription(description);
        });
        int priority = this.getProposalPriorities().getKeywordPriority(keyword.getValue(), contentAssistEntry) - 1;
        acceptor.accept(contentAssistEntry, priority);
    }

    private String roomModelSnippet(String modelName) {
        return "RoomModel %s {\n\t$0\n}\n".formatted(modelName);
    }
}

