/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FSMValidationUtilXtend {
    @Inject
    @Extension
    private FSMNameProvider _fSMNameProvider;

    public ArrayList<Result> uniqueOriginTriggers(State myState) {
        StateGraph parent = this.getStateGraph(myState);
        HashMap trig2trans = CollectionLiterals.newHashMap();
        ArrayList result = CollectionLiterals.newArrayList();
        Functions.Function1 function1 = t -> t instanceof TriggeredTransition && ((TriggeredTransition)t).getFrom() instanceof StateTerminal && Objects.equal((Object)myState, (Object)((StateTerminal)((TriggeredTransition)t).getFrom()).getState());
        Iterable iterable = IterableExtensions.filter(parent.getTransitions(), (Functions.Function1)function1);
        for (Transition t2 : iterable) {
            Functions.Function1 function12 = k -> {
                Guard guard = k.getGuard();
                return guard == null;
            };
            Iterable iterable2 = IterableExtensions.filter(((TriggeredTransition)t2).getTriggers(), (Functions.Function1)function12);
            for (Trigger k2 : iterable2) {
                EList<MessageFromIf> eList = k2.getMsgFromIfPairs();
                for (MessageFromIf specMethod : eList) {
                    String triggerName = this.getTriggerName(specMethod);
                    boolean bl = trig2trans.containsKey(triggerName);
                    if (bl) {
                        TriggeredTransition ot = (TriggeredTransition)trig2trans.get(triggerName);
                        result.add(Result.error("Triggers originating from a state should be unique.", t2, (EStructuralFeature)FSMPackage.Literals.TRIGGERED_TRANSITION__TRIGGERS));
                        result.add(Result.error("Triggers originating from a state should be unique.", ot, (EStructuralFeature)FSMPackage.Literals.TRIGGERED_TRANSITION__TRIGGERS));
                    }
                    trig2trans.put(triggerName, (TriggeredTransition)t2);
                }
            }
        }
        return result;
    }

    private String getTriggerName(MessageFromIf mif) {
        String string = mif.getFrom().getName();
        String string2 = string + "#";
        String string3 = this._fSMNameProvider.getMessageName(mif.getMessage());
        return string2 + string3;
    }

    public StateGraph getStateGraph(EObject obj) {
        EObject parent = obj.eContainer();
        while (parent != null) {
            if (parent instanceof StateGraph) {
                return (StateGraph)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public static class Result {
        private boolean ok;
        private String msg;
        private EObject source;
        private EStructuralFeature feature;
        private int index;

        public static Result ok() {
            return new Result(true, "", null, null, 0);
        }

        public static Result error(String msg) {
            return new Result(false, msg, null, null, -1);
        }

        public static Result error(String msg, EObject source, EStructuralFeature feature) {
            return new Result(false, msg, source, feature, -1);
        }

        public static Result error(String msg, EObject source, EStructuralFeature feature, int index) {
            return new Result(false, msg, source, feature, index);
        }

        public Result(boolean ok, String msg, EObject source, EStructuralFeature feature, int index) {
            this.ok = ok;
            this.msg = msg;
            this.source = source;
            this.feature = feature;
            this.index = index;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getMsg() {
            return this.msg;
        }

        public EObject getSource() {
            return this.source;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

