/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.IGenerator;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.args.Options;
import org.eclipse.etrice.generator.base.cli.CommandLineParseException;
import org.eclipse.etrice.generator.base.cli.ICommandLineParser;
import org.eclipse.etrice.generator.base.cli.IHelpFormatter;
import org.eclipse.etrice.generator.base.io.GeneratorFileIO;
import org.eclipse.etrice.generator.base.io.IGeneratorResourceLoader;
import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.etrice.generator.base.io.LineOutput;
import org.eclipse.etrice.generator.base.logging.Logger;
import org.eclipse.etrice.generator.base.logging.Loglevel;
import org.eclipse.etrice.generator.base.setup.GeneratorApplicationOptions;
import org.eclipse.etrice.generator.base.setup.GeneratorName;
import org.eclipse.etrice.generator.base.setup.GeneratorOptions;
import org.eclipse.etrice.generator.base.validation.IGeneratorResourceValidator;

public class GeneratorApplication {
    private static final String MODULE_CLASS_NAME_LOCATION = "META-INF/generators/";
    private String name;
    private Options options;
    private ICommandLineParser commandLineParser;
    private IHelpFormatter helpFormatter;
    private Provider<Logger> loggerProvider;
    private Provider<GeneratorFileIO> fileIOProvider;
    private IGenerator generator;
    private IGeneratorResourceLoader resourceLoader;
    private IGeneratorResourceValidator resourceValidator;

    public static GeneratorApplication create(Module module) {
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        GeneratorApplication genAppl = (GeneratorApplication)injector.getInstance(GeneratorApplication.class);
        return genAppl;
    }

    public static GeneratorApplication create(String name) {
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try (InputStream in = GeneratorApplication.class.getClassLoader().getResourceAsStream(MODULE_CLASS_NAME_LOCATION + name);){
                String moduleClassName = Optional.ofNullable(in).map(is -> new BufferedReader(new InputStreamReader((InputStream)is))).flatMap(reader -> reader.lines().findFirst()).orElse(name);
                Module module = (Module)Class.forName(moduleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return GeneratorApplication.create(module);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("could not find generator with module name " + name, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    public GeneratorApplication(@GeneratorName String name, GeneratorOptions optionsModule, ICommandLineParser commandLineParser, IHelpFormatter helpFormatter, Provider<Logger> loggerProvider, Provider<GeneratorFileIO> fileIOProvider, IGenerator generator, IGeneratorResourceLoader resourceLoader, IGeneratorResourceValidator resourceValidator) {
        this.name = name;
        this.options = new Options(new GeneratorApplicationOptions(), optionsModule);
        this.commandLineParser = commandLineParser;
        this.helpFormatter = helpFormatter;
        this.loggerProvider = loggerProvider;
        this.fileIOProvider = fileIOProvider;
        this.generator = generator;
        this.resourceLoader = resourceLoader;
        this.resourceValidator = resourceValidator;
    }

    public void run(String[] args) throws GeneratorException {
        this.run(args, (ILineOutput)new LineOutput());
    }

    public void run(String[] args, ILineOutput out) throws GeneratorException {
        try {
            Arguments arguments = this.commandLineParser.parseArgs(this.options, GeneratorApplicationOptions.FILES, args);
            if (arguments.get(GeneratorApplicationOptions.HELP).booleanValue()) {
                this.printHelp(out);
            } else {
                this.run(arguments, out);
            }
        }
        catch (CommandLineParseException e) {
            out.println("Error: " + e.getMessage());
            this.printHelp(out);
            throw new GeneratorException(e);
        }
    }

    public void run(Arguments arguments, ILineOutput out) throws GeneratorException {
        Logger logger = this.createLogger(arguments, out);
        try {
            List<String> files = Arrays.asList(arguments.get(GeneratorApplicationOptions.FILES));
            List<String> modelpath = Arrays.asList(arguments.get(GeneratorApplicationOptions.MODELPATH));
            List<Resource> resources = this.resourceLoader.load(files, modelpath, arguments, logger);
            this.validateAndGenerate(resources, arguments, logger);
        }
        catch (Exception e) {
            this.logException(e, logger);
            throw e;
        }
    }

    public void run(List<Resource> resources, Arguments arguments, ILineOutput out) throws GeneratorException {
        Logger logger = this.createLogger(arguments, out);
        try {
            this.validateAndGenerate(resources, arguments, logger);
        }
        catch (Exception e) {
            this.logException(e, logger);
            throw e;
        }
    }

    public String getName() {
        return this.name;
    }

    public Options getOptions() {
        return this.options;
    }

    public Arguments createArguments() {
        return new Arguments(this.getOptions());
    }

    private void printHelp(ILineOutput out) {
        String help = this.helpFormatter.getHelp(this.name, this.options, GeneratorApplicationOptions.FILES);
        out.println(help);
    }

    private void validateAndGenerate(List<Resource> resources, Arguments arguments, Logger logger) {
        this.resourceValidator.validate(resources, arguments, logger);
        GeneratorFileIO fileIO = (GeneratorFileIO)this.fileIOProvider.get();
        String genDir = arguments.get(GeneratorApplicationOptions.GEN_DIR);
        fileIO.init(genDir, logger);
        logger.logDebug("output directory: " + fileIO.getOutputDirectory().toAbsolutePath());
        this.generator.generate(resources, arguments, fileIO, logger);
        if (arguments.get(GeneratorApplicationOptions.CLEAN).booleanValue()) {
            fileIO.cleanOutputDirectory();
        }
    }

    private Logger createLogger(Arguments arguments, ILineOutput out) {
        Logger logger = (Logger)this.loggerProvider.get();
        Loglevel loglevel = arguments.get(GeneratorApplicationOptions.LOGLEVEL);
        logger.init(loglevel, out);
        logger.logDebug("arguments: " + arguments);
        return logger;
    }

    private void logException(Exception e, Logger logger) {
        if (Loglevel.DEBUG.compareTo(logger.getLoglevel()) >= 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logDebug(sw.toString());
        }
    }
}

