/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.validation;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;

public class FSMValidationUtil
extends FSMValidationUtilXtend {
    @Inject
    private FSMHelpers fsmHelpers;
    @Inject
    private FSMNameProvider fsmNameProvider;

    public FSMValidationUtilXtend.Result isConnectable(TransitionTerminal src, TransitionTerminal tgt, StateGraph sg) {
        return this.isConnectable(src, tgt, null, sg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSMValidationUtilXtend.Result isConnectable(TransitionTerminal src, TransitionTerminal tgt, Transition trans, StateGraph sg) {
        FSMValidationUtilXtend.Result result = this.isConnectableSrc(src, trans, sg);
        if (!result.isOk()) {
            return result;
        }
        if (tgt instanceof TrPointTerminal) {
            if (((TrPointTerminal)tgt).getTrPoint().eIsProxy()) {
                return FSMValidationUtilXtend.Result.error("transition target not found", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            if (((TrPointTerminal)tgt).getTrPoint() instanceof EntryPoint) {
                return FSMValidationUtilXtend.Result.error("entry point can not be transition target", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            TrPoint tgtTP = ((TrPointTerminal)tgt).getTrPoint();
            if (!(((TrPointTerminal)tgt).getTrPoint() instanceof TransitionPoint)) return FSMValidationUtilXtend.Result.ok();
            if (src instanceof TrPointTerminal) {
                TrPoint srcTP = ((TrPointTerminal)src).getTrPoint();
                if (srcTP == tgtTP) return FSMValidationUtilXtend.Result.ok();
                return FSMValidationUtilXtend.Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            if (!(src instanceof ChoicepointTerminal)) return FSMValidationUtilXtend.Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            ChoicePoint cp = ((ChoicepointTerminal)src).getCp();
            block0: while (cp != null) {
                for (Transition tr : sg.getTransitions()) {
                    if (!(tr.getTo() instanceof ChoicepointTerminal) || ((ChoicepointTerminal)tr.getTo()).getCp() != cp || !(tr instanceof NonInitialTransition)) continue;
                    if (((NonInitialTransition)tr).getFrom() instanceof TrPointTerminal) {
                        TrPoint srcTP = ((TrPointTerminal)((NonInitialTransition)tr).getFrom()).getTrPoint();
                        if (srcTP == tgtTP) return FSMValidationUtilXtend.Result.ok();
                        return FSMValidationUtilXtend.Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                    }
                    if (!(((NonInitialTransition)tr).getFrom() instanceof ChoicepointTerminal)) continue;
                    cp = ((ChoicepointTerminal)((NonInitialTransition)tr).getFrom()).getCp();
                    continue block0;
                }
            }
            return FSMValidationUtilXtend.Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
        }
        if (tgt instanceof SubStateTrPointTerminal) {
            if (((SubStateTrPointTerminal)tgt).getTrPoint().eIsProxy()) {
                return FSMValidationUtilXtend.Result.error("transition target not found", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
            }
            if (!(((SubStateTrPointTerminal)tgt).getTrPoint() instanceof ExitPoint)) return FSMValidationUtilXtend.Result.ok();
            return FSMValidationUtilXtend.Result.error("sub state exit point can not be transition target", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
        }
        if (!(tgt instanceof StateTerminal) || !((StateTerminal)tgt).getState().eIsProxy()) return FSMValidationUtilXtend.Result.ok();
        return FSMValidationUtilXtend.Result.error("transition target not found", tgt, (EStructuralFeature)FSMPackage.eINSTANCE.getStateTerminal_State(), 0);
    }

    public FSMValidationUtilXtend.Result isConnectable(TransitionTerminal src, StateGraph sg) {
        return this.isConnectableSrc(src, null, sg);
    }

    public FSMValidationUtilXtend.Result isConnectableSrc(TransitionTerminal src, Transition trans, StateGraph sg) {
        if (src == null) {
            for (Transition t : sg.getTransitions()) {
                if (t == trans || !(t instanceof InitialTransition)) continue;
                return FSMValidationUtilXtend.Result.error("there already is an InitialTransition", sg, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), sg.getTransitions().indexOf((Object)trans));
            }
        } else if (src instanceof TrPointTerminal) {
            TrPoint srcTP = ((TrPointTerminal)src).getTrPoint();
            if (srcTP.eIsProxy()) {
                return FSMValidationUtilXtend.Result.error("transition source not found", src, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            if (srcTP instanceof ExitPoint) {
                return FSMValidationUtilXtend.Result.error("exit point can not be transition source", src, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            if (srcTP instanceof EntryPoint) {
                for (Transition t : sg.getTransitions()) {
                    TrPointTerminal tpt;
                    if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof TrPointTerminal) || (tpt = (TrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != srcTP) continue;
                    return FSMValidationUtilXtend.Result.error("source transition point already is connected", src, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                }
                StateGraph origSG = (StateGraph)srcTP.eContainer();
                for (Transition t : origSG.getTransitions()) {
                    TrPointTerminal tpt;
                    if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof TrPointTerminal) || (tpt = (TrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != srcTP) continue;
                    return FSMValidationUtilXtend.Result.error("source transition point already is connected", src, (EStructuralFeature)FSMPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                }
            }
        } else if (src instanceof SubStateTrPointTerminal) {
            if (((SubStateTrPointTerminal)src).getTrPoint().eIsProxy()) {
                return FSMValidationUtilXtend.Result.error("transition source not found", src, (EStructuralFeature)FSMPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
            }
            if (((SubStateTrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                return FSMValidationUtilXtend.Result.error("sub state entry point can not be transition source", src, (EStructuralFeature)FSMPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
            }
            for (Transition t : sg.getTransitions()) {
                SubStateTrPointTerminal tpt;
                if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof SubStateTrPointTerminal) || (tpt = (SubStateTrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != ((SubStateTrPointTerminal)src).getTrPoint()) continue;
                return FSMValidationUtilXtend.Result.error("source transition point already is connected", src, (EStructuralFeature)FSMPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
            }
        } else if (src instanceof StateTerminal && ((StateTerminal)src).getState().eIsProxy()) {
            return FSMValidationUtilXtend.Result.error("transition source not found", src, (EStructuralFeature)FSMPackage.eINSTANCE.getStateTerminal_State(), 0);
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public FSMValidationUtilXtend.Result isValid(TrPoint tp) {
        if (tp instanceof TransitionPoint) {
            return FSMValidationUtilXtend.Result.ok();
        }
        if (!(tp.eContainer().eContainer() instanceof State)) {
            StateGraph sg = (StateGraph)tp.eContainer();
            int idx = sg.getTrPoints().indexOf((Object)tp);
            return FSMValidationUtilXtend.Result.error("entry and exit points forbidden on top level state graph", tp.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public boolean isConnectedOutside(TrPoint tp) {
        if (tp instanceof TransitionPoint) {
            return false;
        }
        StateGraph parentSG = (StateGraph)tp.eContainer().eContainer().eContainer();
        for (Transition t : parentSG.getTransitions()) {
            SubStateTrPointTerminal term;
            if (t.getTo() instanceof SubStateTrPointTerminal && (term = (SubStateTrPointTerminal)t.getTo()).getTrPoint() == tp) {
                return true;
            }
            if (!(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof SubStateTrPointTerminal) || (term = (SubStateTrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != tp) continue;
            return true;
        }
        return false;
    }

    public FSMValidationUtilXtend.Result checkTransition(Transition tr) {
        TransitionTerminal term;
        ModelComponent mc = this.fsmHelpers.getModelComponent(tr);
        if (mc.getCommType() == ComponentCommunicationType.DATA_DRIVEN) {
            if (tr instanceof TriggeredTransition) {
                return FSMValidationUtilXtend.Result.error("data driven state machine must not contain triggered transition", tr.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof ContinuationTransition) {
                TransitionTerminal term2 = ((ContinuationTransition)tr).getFrom();
                if (term2 instanceof StateTerminal || term2 instanceof TrPointTerminal && ((TrPointTerminal)term2).getTrPoint() instanceof TransitionPoint) {
                    return FSMValidationUtilXtend.Result.error("guard must not be empty", tr.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
                }
            } else if (tr instanceof GuardedTransition && !this.fsmHelpers.hasDetailCode(((GuardedTransition)tr).getGuard())) {
                return FSMValidationUtilXtend.Result.error("guard must not be empty", tr, (EStructuralFeature)FSMPackage.eINSTANCE.getGuardedTransition_Guard());
            }
        } else if (mc.getCommType() == ComponentCommunicationType.EVENT_DRIVEN) {
            TransitionTerminal term3;
            if (tr instanceof GuardedTransition) {
                return FSMValidationUtilXtend.Result.error("event driven state machine must not contain guarded transition", tr.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof ContinuationTransition && ((term3 = ((ContinuationTransition)tr).getFrom()) instanceof StateTerminal || term3 instanceof TrPointTerminal && ((TrPointTerminal)term3).getTrPoint() instanceof TransitionPoint)) {
                return FSMValidationUtilXtend.Result.error("trigger must not be empty", tr.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
        } else if (mc.getCommType() == ComponentCommunicationType.ASYNCHRONOUS && tr instanceof ContinuationTransition && ((term = ((ContinuationTransition)tr).getFrom()) instanceof StateTerminal || term instanceof TrPointTerminal && ((TrPointTerminal)term).getTrPoint() instanceof TransitionPoint)) {
            return FSMValidationUtilXtend.Result.error("trigger/guard must not be empty", tr.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public FSMValidationUtilXtend.Result checkState(State state) {
        ModelComponent mc;
        if (state.getDoCode() != null && (mc = this.fsmHelpers.getModelComponent(state)).getCommType() == ComponentCommunicationType.EVENT_DRIVEN) {
            return FSMValidationUtilXtend.Result.error("event driven state machines must not have 'do' action code", state, (EStructuralFeature)FSMPackage.eINSTANCE.getState_DoCode());
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public List<FSMValidationUtilXtend.Result> checkTopLevelRefinedStates(ModelComponent mc) {
        ArrayList<FSMValidationUtilXtend.Result> errors = new ArrayList<FSMValidationUtilXtend.Result>();
        if (mc.getStateMachine() == null) {
            return errors;
        }
        Function<RefinedState, String> nameProvider = this.fsmNameProvider.getRefinedStateNameProvider();
        Map<RefinedState, RefinedState> rs2parent = this.fsmHelpers.getRefinedStatesToRelocate(mc, nameProvider);
        for (RefinedState rs : rs2parent.keySet()) {
            RefinedState parent = rs2parent.get(rs);
            String path = this.fsmNameProvider.getFullPath(parent);
            int idx = ((StateGraph)rs.eContainer()).getStates().indexOf((Object)rs);
            errors.add(FSMValidationUtilXtend.Result.error("RefinedState has to be in the context of " + path, rs.eContainer(), (EStructuralFeature)FSMPackage.Literals.STATE_GRAPH__STATES, idx));
        }
        return errors;
    }

    public FSMValidationUtilXtend.Result isUniqueName(StateGraphItem s, String name) {
        if (name.trim().isEmpty()) {
            return FSMValidationUtilXtend.Result.error("name must not be empty");
        }
        if (!this.isValidID(name)) {
            return FSMValidationUtilXtend.Result.error("name is no valid ID");
        }
        StateGraph sg = (StateGraph)s.eContainer();
        Set<String> names = this.fsmHelpers.getAllNames(sg, s);
        if (names.contains(name)) {
            return FSMValidationUtilXtend.Result.error("name already used");
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public boolean isValidID(String name) {
        return name.matches("\\^?[a-zA-Z_][a-zA-Z_0-9]*");
    }

    public boolean isRefinedStateEmpty(RefinedState rs) {
        if (rs.getSubgraph() == null || this.fsmHelpers.isEmpty(rs.getSubgraph())) {
            boolean entryEmpty = this.fsmHelpers.getDetailCode(rs.getEntryCode()).trim().isEmpty();
            boolean exitEmpty = this.fsmHelpers.getDetailCode(rs.getExitCode()).trim().isEmpty();
            boolean doEmpty = this.fsmHelpers.getDetailCode(rs.getDoCode()).trim().isEmpty();
            if (entryEmpty && exitEmpty && doEmpty) {
                return true;
            }
        }
        return false;
    }
}

