/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ClassStructor;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ProcedureHelpers {
    protected final String NEWLINE = System.getProperty("line.separator");
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    @Extension
    protected TypeHelpers _typeHelpers;
    @Inject
    @Extension
    protected IDetailCodeTranslator _iDetailCodeTranslator;
    @Inject
    protected ILanguageExtension languageExt;
    @Inject
    protected ILogger logger;

    public CharSequence userCode(DataClass dc, int id) {
        CharSequence charSequence = null;
        switch (id) {
            case 1: {
                charSequence = this.userCode(this._roomHelpers.getDeepUserCode1(dc));
                break;
            }
            case 2: {
                charSequence = this.userCode(this._roomHelpers.getDeepUserCode2(dc));
                break;
            }
            case 3: {
                charSequence = this.userCode(this._roomHelpers.getDeepUserCode3(dc));
            }
        }
        return charSequence;
    }

    public CharSequence userCode(ProtocolClass pc, int id) {
        CharSequence charSequence = null;
        switch (id) {
            case 1: {
                charSequence = this.userCode(this._roomHelpers.getDeepUserCode1(pc));
                break;
            }
            case 2: {
                charSequence = this.userCode(this._roomHelpers.getDeepUserCode2(pc));
                break;
            }
            case 3: {
                charSequence = this.userCode(this._roomHelpers.getDeepUserCode3(pc));
            }
        }
        return charSequence;
    }

    public CharSequence userCode(ActorContainerClass ac, int id, boolean includeInherited) {
        CharSequence charSequence = null;
        if (includeInherited) {
            CharSequence charSequence2 = null;
            switch (id) {
                case 1: {
                    charSequence2 = this.userCode(this._roomHelpers.getDeepUserCode1(ac));
                    break;
                }
                case 2: {
                    charSequence2 = this.userCode(this._roomHelpers.getDeepUserCode2(ac));
                    break;
                }
                case 3: {
                    charSequence2 = this.userCode(this._roomHelpers.getDeepUserCode3(ac));
                }
            }
            charSequence = charSequence2;
        } else {
            CharSequence charSequence3 = null;
            switch (id) {
                case 1: {
                    charSequence3 = this.userCode(ac.getUserCode1());
                    break;
                }
                case 2: {
                    charSequence3 = this.userCode(ac.getUserCode2());
                    break;
                }
                case 3: {
                    charSequence3 = this.userCode(ac.getUserCode3());
                }
            }
            charSequence = charSequence3;
        }
        return charSequence;
    }

    public CharSequence userCode(DetailCode dc) {
        return this.userCode(this._roomHelpers.getDetailCode(dc));
    }

    private CharSequence userCode(String code) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        if (code != null && !code.isEmpty()) {
            stringConcatenation.append("/*--------------------- begin user code ---------------------*/");
            stringConcatenation.newLine();
            stringConcatenation.append(code);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("/*--------------------- end user code ---------------------*/");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    public CharSequence attributes(List<Attribute> attributes) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/*--------------------- attributes ---------------------*/");
        stringConcatenation.newLine();
        for (Attribute it : attributes) {
            CharSequence charSequence = this.attributeDeclaration(it);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation;
    }

    public CharSequence attributeDeclaration(Attribute attribute) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = this.languageExt.accessLevelPublic();
        stringConcatenation.append(string);
        stringConcatenation.append(" ");
        String string2 = this.declarationString(attribute);
        stringConcatenation.append(string2);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public String arrayInitializer(Attribute att) {
        String string = null;
        String string2 = att.getDefaultValueLiteral();
        boolean bl = string2 != null;
        string = bl ? att.getDefaultValueLiteral() : this.languageExt.defaultValue(att.getType().getType());
        String dflt = string;
        boolean bl2 = dflt.startsWith("{");
        if (bl2) {
            int n;
            boolean bl3;
            int n2 = ((List)Conversions.doWrapArray((Object)dflt.split(","))).size();
            boolean bl4 = bl3 = n2 != (n = att.getSize());
            if (bl3) {
                String string3 = att.getName();
                String string4 = "WARNING: array size determined by initializer differs from attribute size (" + string3;
                String string5 = String.valueOf(string4) + "[";
                int n3 = att.getSize();
                String string6 = String.valueOf(string5) + Integer.valueOf(n3);
                String string7 = String.valueOf(string6) + "] <-> ";
                String string8 = String.valueOf(string7) + dflt;
                String string9 = String.valueOf(string8) + ")";
                this.logger.logInfo(string9);
            }
            return dflt;
        }
        String result = "{";
        int i = 0;
        while (i < att.getSize()) {
            boolean bl5;
            result = String.valueOf(result) + dflt;
            int n = att.getSize();
            boolean bl6 = bl5 = ++i < n;
            if (!bl5) continue;
            result = String.valueOf(result) + ", ";
        }
        return String.valueOf(result) + "}";
    }

    public CharSequence attributeSettersGettersDeclaration(List<Attribute> attributes, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/* --------------------- attribute setters and getters */");
        stringConcatenation.newLine();
        for (Attribute attribute : attributes) {
            CharSequence charSequence = this.setterHeader(attribute, classname);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
            CharSequence charSequence2 = this.getterHeader(attribute, classname);
            stringConcatenation.append((Object)charSequence2);
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation;
    }

    public CharSequence attributeSettersGettersImplementation(List<Attribute> attributes, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/* --------------------- attribute setters and getters */");
        stringConcatenation.newLine();
        for (Attribute attribute : attributes) {
            CharSequence charSequence = this.setterHeader(attribute, classname);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.append(" {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t ");
            String string = this.languageExt.memberAccess();
            stringConcatenation.append(string, "\t ");
            String string2 = attribute.getName();
            stringConcatenation.append(string2, "\t ");
            stringConcatenation.append(" = ");
            String string3 = attribute.getName();
            stringConcatenation.append(string3, "\t ");
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            CharSequence charSequence2 = this.getterHeader(attribute, classname);
            stringConcatenation.append((Object)charSequence2);
            stringConcatenation.append(" {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("return ");
            String string4 = this.languageExt.memberAccess();
            stringConcatenation.append(string4, "\t");
            String string5 = attribute.getName();
            stringConcatenation.append(string5, "\t");
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    protected CharSequence setterHeader(Attribute attribute, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = this.languageExt.accessLevelPublic();
        stringConcatenation.append(string);
        stringConcatenation.append("void set");
        String string2 = StringExtensions.toFirstUpper((String)attribute.getName());
        stringConcatenation.append(string2);
        stringConcatenation.append("(");
        String string3 = this.languageExt.selfPointer(classname, true);
        stringConcatenation.append(string3);
        String string4 = this.argList(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Attribute[]{attribute})));
        stringConcatenation.append(string4);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    protected CharSequence getterHeader(Attribute attribute, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = this.languageExt.accessLevelPublic();
        stringConcatenation.append(string);
        String string2 = this.signatureString(attribute);
        stringConcatenation.append(string2);
        stringConcatenation.append(" get");
        String string3 = StringExtensions.toFirstUpper((String)attribute.getName());
        stringConcatenation.append(string3);
        stringConcatenation.append("(");
        String string4 = this.languageExt.selfPointer(classname, false);
        stringConcatenation.append(string4);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public String argList(Iterable<Attribute> attributes) {
        Functions.Function1<Attribute, String> function1 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                String string = ProcedureHelpers.this.signatureString(it);
                String string2 = String.valueOf(string) + " ";
                String string3 = it.getName();
                return String.valueOf(string2) + string3;
            }
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map(attributes, (Functions.Function1)function1), (CharSequence)", ");
    }

    public CharSequence invokeGetters(Iterable<Attribute> path, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl = false;
        for (Attribute a : path) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation.appendImmediate((Object)".", "");
            }
            CharSequence charSequence = this.invokeGetter(a.getName(), classname);
            stringConcatenation.append((Object)charSequence);
        }
        return stringConcatenation;
    }

    public CharSequence getterImplementation(String typeName, String name, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = this.languageExt.accessLevelPublic();
        stringConcatenation.append(string);
        stringConcatenation.append(typeName);
        stringConcatenation.append(" get");
        String string2 = StringExtensions.toFirstUpper((String)name);
        stringConcatenation.append(string2);
        stringConcatenation.append(" (");
        String string3 = this.languageExt.selfPointer(classname, false);
        stringConcatenation.append(string3);
        stringConcatenation.append("){");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("return ");
        String string4 = this.languageExt.memberAccess();
        stringConcatenation.append(string4, "\t");
        stringConcatenation.append(name, "\t");
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public CharSequence invokeGetter(String name, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("get");
        String string = StringExtensions.toFirstUpper((String)name);
        stringConcatenation.append(string);
        stringConcatenation.append("(");
        String string2 = this.languageExt.selfPointer(classname, true);
        stringConcatenation.append(string2);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence invokeSetter(String name, String classname, String value) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("set");
        String string = StringExtensions.toFirstUpper((String)name);
        stringConcatenation.append(string);
        stringConcatenation.append("(");
        String string2 = this.languageExt.selfPointer(classname, true);
        stringConcatenation.append(string2);
        stringConcatenation.append(value);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence operationsDeclaration(List<? extends Operation> operations, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/*--------------------- operations ---------------------*/");
        stringConcatenation.newLine();
        for (Operation operation : operations) {
            CharSequence charSequence = this.operationSignature(operation, classname, true);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation;
    }

    public CharSequence operationsImplementation(List<? extends Operation> operations, String classname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/*--------------------- operations ---------------------*/");
        stringConcatenation.newLine();
        for (Operation operation : operations) {
            CharSequence charSequence = this.operationSignature(operation, classname, false);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.append(" {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            String string = this._iDetailCodeTranslator.getTranslatedCode(operation.getDetailCode());
            stringConcatenation.append(string, "\t");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    public CharSequence asBlock(CharSequence str) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append((Object)str, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public String invokeUserStructor(RoomClass cls, String args, final boolean ctor) {
        boolean bl = this.languageExt.usesInheritance();
        boolean bl2 = !bl;
        Functions.Function1<ClassStructor, Boolean> function1 = new Functions.Function1<ClassStructor, Boolean>(){

            public Boolean apply(ClassStructor it) {
                boolean bl = it.isConstructor();
                return bl == ctor;
            }
        };
        boolean bl3 = IterableExtensions.exists(this.getStructors(cls, bl2), (Functions.Function1)function1);
        if (bl3) {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = cls.getName();
            String string2 = null;
            string2 = ctor ? "ctor" : "dtor";
            String string3 = this.languageExt.memberInDeclaration(string, string2);
            stringConcatenation.append(string3);
            stringConcatenation.append("(");
            stringConcatenation.append(args);
            stringConcatenation.append(");");
            return stringConcatenation.toString();
        }
        return "";
    }

    public String userStructorsDeclaration(RoomClass cls) {
        boolean bl;
        String string = null;
        String namePrefix = this.languageExt.operationScope(cls.getName(), true);
        ArrayList declBlock = CollectionLiterals.newArrayList();
        declBlock.add("/*--------------------- user constructor/destructor ---------------------*/");
        boolean bl2 = this.languageExt.usesInheritance();
        boolean bl3 = !bl2;
        Functions.Function1<ClassStructor, Boolean> function1 = new Functions.Function1<ClassStructor, Boolean>(){

            public Boolean apply(ClassStructor it) {
                return it.isConstructor();
            }
        };
        boolean bl4 = IterableExtensions.exists(this.getStructors(cls, bl3), (Functions.Function1)function1);
        if (bl4) {
            CharSequence charSequence = this.functionSignature(cls.getName(), String.valueOf(namePrefix) + "ctor", "void", "");
            String string2 = charSequence + ";";
            declBlock.add(string2);
        }
        boolean bl5 = !(bl = this.languageExt.usesInheritance());
        Functions.Function1<ClassStructor, Boolean> function12 = new Functions.Function1<ClassStructor, Boolean>(){

            public Boolean apply(ClassStructor it) {
                boolean bl = it.isConstructor();
                return !bl;
            }
        };
        boolean bl6 = IterableExtensions.exists(this.getStructors(cls, bl5), (Functions.Function1)function12);
        if (bl6) {
            CharSequence charSequence = this.functionSignature(cls.getName(), String.valueOf(namePrefix) + "dtor", "void", "");
            String string3 = charSequence + ";";
            declBlock.add(string3);
        }
        string = IterableExtensions.join((Iterable)declBlock, (CharSequence)this.NEWLINE);
        return string;
    }

    public String userStructorsImplementation(RoomClass cls) {
        String string = null;
        ArrayList declBlock = CollectionLiterals.newArrayList();
        declBlock.add("/*--------------------- user constructor/destructor ---------------------*/");
        String string2 = this.userStuctorImplementation(cls, true);
        declBlock.add(string2);
        String string3 = this.userStuctorImplementation(cls, false);
        declBlock.add(string3);
        string = IterableExtensions.join((Iterable)IterableExtensions.filterNull((Iterable)declBlock), (CharSequence)this.NEWLINE);
        return string;
    }

    protected String userStuctorImplementation(RoomClass cls, final boolean ctor) {
        boolean bl;
        String string = null;
        String namePrefix = this.languageExt.operationScope(cls.getName(), false);
        boolean bl2 = this.languageExt.usesInheritance();
        boolean bl3 = !bl2;
        Functions.Function1<ClassStructor, Boolean> function1 = new Functions.Function1<ClassStructor, Boolean>(){

            public Boolean apply(ClassStructor it) {
                boolean bl = it.isConstructor();
                return bl == ctor;
            }
        };
        boolean bl4 = IterableExtensions.exists(this.getStructors(cls, bl3), (Functions.Function1)function1);
        boolean bl5 = bl = !bl4;
        if (bl) {
            return null;
        }
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string2 = cls.getName();
        String string3 = null;
        string3 = ctor ? "ctor" : "dtor";
        String string4 = String.valueOf(namePrefix) + string3;
        CharSequence charSequence = this.functionSignature(string2, string4, "void", "");
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("{");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        String string5 = this.userStructorBody(cls, ctor);
        stringConcatenation.append(string5, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        string = stringConcatenation.toString();
        return string;
    }

    public String userStructorBody(RoomClass cls, final boolean ctor) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/* user defined ");
        if (ctor) {
            stringConcatenation.append("con");
        } else {
            stringConcatenation.append("de");
        }
        stringConcatenation.append("structor body */");
        String comment = stringConcatenation.toString();
        boolean bl = this.languageExt.usesInheritance();
        boolean bl2 = !bl;
        Functions.Function1<ClassStructor, Boolean> function1 = new Functions.Function1<ClassStructor, Boolean>(){

            public Boolean apply(ClassStructor it) {
                boolean bl = it.isConstructor();
                return bl == ctor;
            }
        };
        Iterable implementedStructors = IterableExtensions.filter(this.getStructors(cls, bl2), (Functions.Function1)function1);
        Functions.Function1<ClassStructor, DetailCode> function12 = new Functions.Function1<ClassStructor, DetailCode>(){

            public DetailCode apply(ClassStructor it) {
                return it.getDetailCode();
            }
        };
        Functions.Function1<DetailCode, String> function13 = new Functions.Function1<DetailCode, String>(){

            public String apply(DetailCode it) {
                return ProcedureHelpers.this._iDetailCodeTranslator.getTranslatedCode(it);
            }
        };
        final Iterable translatedCodes = IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)implementedStructors, (Functions.Function1)function12), (Functions.Function1)function13);
        Functions.Function1<String, CharSequence> function14 = new Functions.Function1<String, CharSequence>(){

            public CharSequence apply(String it) {
                CharSequence charSequence = null;
                int n = IterableExtensions.size((Iterable)translatedCodes);
                boolean bl = n > 1;
                charSequence = bl ? ProcedureHelpers.this.asBlock(it) : it;
                return charSequence;
            }
        };
        String string = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)translatedCodes, (Functions.Function1)function14));
        return String.valueOf(comment) + this.NEWLINE + string;
    }

    protected List<ClassStructor> getStructors(RoomClass cls, boolean inherited) {
        Object object = null;
        RoomClass it = cls;
        boolean bl = false;
        if (it instanceof ActorClass && !inherited) {
            bl = true;
            object = ((ActorClass)it).getStructors();
        }
        if (!bl && it instanceof DataClass && !inherited) {
            bl = true;
            object = ((DataClass)it).getStructors();
        }
        if (!bl && it instanceof ActorClass && inherited) {
            bl = true;
            object = this._roomHelpers.getAllStructors((ActorClass)it);
        }
        if (!bl && it instanceof DataClass && inherited) {
            bl = true;
            object = this._roomHelpers.getAllStructors((DataClass)it);
        }
        if (!bl) {
            object = CollectionLiterals.emptyList();
        }
        return object;
    }

    protected CharSequence operationSignature(Operation operation, String classname, boolean isDeclaration) {
        CharSequence charSequence = null;
        Functions.Function1<VarDecl, String> function1 = new Functions.Function1<VarDecl, String>(){

            public String apply(VarDecl arg) {
                return ProcedureHelpers.this.languageExt.toParameterDecl(arg);
            }
        };
        String arguments = IterableExtensions.join((Iterable)ListExtensions.map((List)operation.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
        String returnType = this.languageExt.getTypeSignature(operation.getReturnType());
        String string = this.languageExt.operationScope(classname, isDeclaration);
        String string2 = operation.getName();
        String string3 = String.valueOf(string) + string2;
        charSequence = this.functionSignature(classname, string3, returnType, arguments);
        return charSequence;
    }

    public String signatureString(Attribute attribute) {
        boolean bl;
        String string = null;
        Attribute it = attribute;
        boolean bl2 = false;
        int n = it.getSize();
        boolean bl3 = bl = n > 0;
        if (bl) {
            bl2 = true;
            string = this.languageExt.arrayType(this._typeHelpers.typeName(it.getType().getType()), it.getSize(), it.getType().isRef());
        }
        if (!bl2) {
            string = this.languageExt.getTypeSignature(it.getType());
        }
        return string;
    }

    public String declarationString(Attribute attribute) {
        boolean bl;
        String string = null;
        Attribute it = attribute;
        boolean bl2 = false;
        int n = it.getSize();
        boolean bl3 = bl = n > 0;
        if (bl) {
            bl2 = true;
            string = this.languageExt.arrayDeclaration(this._typeHelpers.typeName(it.getType().getType()), it.getSize(), it.getType().isRef(), it.getName());
        }
        if (!bl2) {
            String string2 = this.languageExt.getTypeSignature(it.getType());
            String string3 = String.valueOf(string2) + " ";
            String string4 = it.getName();
            string = String.valueOf(string3) + string4;
        }
        return string;
    }

    protected CharSequence functionSignature(String className, String fullFctName, String returnType, String arguments) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = this.languageExt.accessLevelPublic();
        stringConcatenation.append(string);
        stringConcatenation.append(" ");
        stringConcatenation.append(returnType);
        stringConcatenation.append(" ");
        stringConcatenation.append(fullFctName);
        stringConcatenation.append("(");
        boolean bl = arguments.isEmpty();
        boolean bl2 = !bl;
        String string2 = this.languageExt.selfPointer(className, bl2);
        stringConcatenation.append(string2);
        stringConcatenation.append(arguments);
        stringConcatenation.append(")");
        return stringConcatenation;
    }
}

