/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.etrice.core.common.ide.modelpath.ModelPathDescriptionLexer;

public class ModelPathDescription {
    private final List<IContainer> sourceDirectories;
    private final List<IProject> projectDependencies;

    private ModelPathDescription(List<IContainer> sourceDirectories, List<IProject> projectDependencies) {
        this.sourceDirectories = sourceDirectories;
        this.projectDependencies = projectDependencies;
    }

    public List<IContainer> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public List<IProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    public static ModelPathDescription load(IFile file) throws CoreException {
        try {
            return new ModelPathDescriptionLoader(file).load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class ModelPathDescriptionLoader {
        private IFile file;
        private IProject project;
        private IWorkspaceRoot root;
        private List<IContainer> srcDirs;
        private List<IProject> projects;

        public ModelPathDescriptionLoader(IFile file) {
            this.file = file;
            this.project = file.getProject();
            this.root = ResourcesPlugin.getWorkspace().getRoot();
            this.srcDirs = new ArrayList<IContainer>();
            this.projects = new ArrayList<IProject>();
        }

        public ModelPathDescription load() throws CoreException, IOException {
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream input = this.file.getContents();){
                for (ModelPathDescriptionLexer.ModelPathDescriptionEntry entry : ModelPathDescriptionLexer.read((InputStream)input)) {
                    this.parseEntry(entry);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new ModelPathDescription(Collections.unmodifiableList(this.srcDirs), Collections.unmodifiableList(this.projects));
        }

        private void parseEntry(ModelPathDescriptionLexer.ModelPathDescriptionEntry entry) throws CoreException {
            switch (entry.key) {
                case "srcDir": {
                    this.parseSrcDir(entry.value, entry.lineNumber);
                    break;
                }
                case "project": {
                    this.parseProject(entry.value, entry.lineNumber);
                    break;
                }
                default: {
                    this.createProblemMarker(2, entry.lineNumber, "unexpected keyword " + entry.key);
                }
            }
        }

        private void parseSrcDir(String value, int lineNumber) throws CoreException {
            if (value.isEmpty()) {
                this.createProblemMarker(2, lineNumber, "directory path is missing");
                return;
            }
            if (!Path.EMPTY.isValidPath(value)) {
                this.createProblemMarker(2, lineNumber, String.valueOf(value) + " isn't a valid path");
                return;
            }
            try {
                IFolder dir = this.project.getFolder(value);
                if (!dir.exists()) {
                    this.createProblemMarker(1, lineNumber, "directory " + dir.getFullPath() + " doesn't exist");
                }
                this.srcDirs.add((IContainer)dir);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.createProblemMarker(2, lineNumber, String.valueOf(value) + " is not a valid directory");
            }
        }

        private void parseProject(String value, int lineNumber) throws CoreException {
            if (value.isEmpty()) {
                this.createProblemMarker(2, lineNumber, "project name is missing");
                return;
            }
            if (!Path.EMPTY.isValidSegment(value)) {
                this.createProblemMarker(2, lineNumber, String.valueOf(value) + " isn't a valid project name");
                return;
            }
            IProject project = this.root.getProject(value);
            if (!project.isAccessible()) {
                this.createProblemMarker(1, lineNumber, "project " + project.getName() + " doesn't exist");
            }
            this.projects.add(project);
        }

        private void createProblemMarker(int severity, int lineNumber, String message) throws CoreException {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", lineNumber + 1);
            marker.setAttribute("message", (Object)message);
        }
    }
}

