/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.common.validation.ValidationHelpers;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomAnnotationTargetEnum;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.AbstractRoomValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.IModelPathProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class RoomValidator
extends AbstractRoomValidator {
    @Inject
    protected RoomHelpers roomHelpers;
    @Inject
    protected ValidationUtil validationUtil;
    @Inject
    protected IQualifiedNameProvider fqnProvider;
    @Inject
    protected IQualifiedNameConverter nameConverter;
    @Inject
    private IModelPathProvider modelPathProvider;
    @Inject
    ImportHelpers importHelpers;
    public static final String WRONG_MODEL_NAME = "RoomJavaValidator.WrongModelName";
    public static final String THREAD_MISSING = "RoomJavaValidator.ThreadMissing";
    public static final String DUPLICATE_ACTOR_INSTANCE_MAPPING = "RoomJavaValidator.DuplicateActorInstanceMapping";
    public static final String WRONG_NAMESPACE = "RoomJavaValidator.WrongNamespace";
    public static final String CIRCULAR_CONTAINMENT = "RoomJavaValidator.CircularContainment";
    public static final String CHANGE_DESTRUCTOR_NAME = "RoomJavaValidator.ChangeDestructorName";
    public static final String CHANGE_CONSTRUCTOR_NAME = "RoomJavaValidator.ChangeConstructorName";
    public static final String INVALID_ANNOTATION_TARGET = "RoomJavaValidator.InvalidAnnotationTarget";
    public static final String OPERATION_MISSING_OVERRIDE = "RoomJavaValidator.OperationMissingOverride";
    public static final String OPERATION_EXTRANEOUS_OVERRIDE = "RoomJavaValidator.OperationExtraneousOverride";
    public static final String INCONSISTENT_COMMUNICATION_TYPE = "RoomJavaValidator.InconsistentCommType";
    public static final String DEPRECATED_MESSAGE_DATA_NAME = "RoomJavaValidator.DeprecatedMessageDataName";

    @Check
    public void checkRoomModelName(RoomModel roomModel) {
        QualifiedName modelName = this.fqnProvider.getFullyQualifiedName((EObject)roomModel);
        if (modelName != null) {
            Resource resource = roomModel.eResource();
            IModelPath modelpath = this.modelPathProvider.get(resource);
            modelpath.getQualifiedName(resource.getURI()).ifPresent(fileName -> {
                if (!fileName.equals((Object)modelName)) {
                    this.error("model name doesn't match its file name and its location on the modelpath", (EStructuralFeature)RoomPackage.Literals.ROOM_MODEL__NAME, WRONG_MODEL_NAME, new String[]{this.nameConverter.toString(modelName), this.nameConverter.toString(fileName)});
                }
            });
        }
    }

    @Check
    public void checkRoomImportedNamespace(Import imp) {
        final QualifiedName importedFQN = this.importHelpers.toFQN(imp);
        if (importedFQN == null) {
            return;
        }
        Predicate<IEObjectDescription> nameMatcher = new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return importedFQN.equals((Object)input.getQualifiedName());
            }
        };
        Predicate<IEObjectDescription> candidateMatcher = new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return input.getEClass() == RoomPackage.Literals.ROOM_MODEL;
            }
        };
        Predicate<IEObjectDescription> allowedClasses = new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return input.getEClass() == RoomPackage.Literals.ROOM_MODEL || input.getEClass() == BasePackage.Literals.ANNOTATION_TYPE || RoomPackage.Literals.ROOM_CLASS.isSuperTypeOf(input.getEClass());
            }
        };
        Optional importCandidates = this.importHelpers.getImportedObjectsFor(imp, (Predicate)candidateMatcher);
        if (!importCandidates.isPresent()) {
            return;
        }
        List candidates = (List)importCandidates.get();
        Optional exactMatch = Iterables.tryFind((Iterable)candidates, (Predicate)Predicates.and((Predicate)nameMatcher, (Predicate)candidateMatcher)).toJavaUtil();
        if (exactMatch.isPresent()) {
            EObject importedElement = ((IEObjectDescription)exactMatch.get()).getEObjectOrProxy();
            if (importedElement instanceof RoomElement && this.roomHelpers.findDeprecatedAnnotation((RoomElement)importedElement) != null) {
                this.warning("Deprecated Element", null);
            }
            return;
        }
        LinkedHashSet candidatesNames = Sets.newLinkedHashSet();
        for (IEObjectDescription eObjDesc : candidates) {
            candidatesNames.add(String.valueOf(eObjDesc.getQualifiedName().toString()) + ".*");
        }
        if (candidates.isEmpty()) {
            this.error("no match for imported namespace", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE);
        } else if (!Iterables.any((Iterable)candidates, (Predicate)nameMatcher)) {
            this.error("no match for imported namespace", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, WRONG_NAMESPACE, candidatesNames.toArray(new String[0]));
        } else if (!Iterables.any((Iterable)Iterables.filter((Iterable)candidates, (Predicate)nameMatcher), (Predicate)allowedClasses)) {
            this.error("referenced model is not supported", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, WRONG_NAMESPACE, candidatesNames.toArray(new String[0]));
        }
    }

    @Check
    public void checkActorRef(ActorRef ar) {
        if (ar.eContainer() instanceof ActorClass) {
            ActorClass ac = (ActorClass)ar.eContainer();
            if (this.roomHelpers.isReferencing(ar.getType(), ac)) {
                this.error("Actor reference is circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_Type(), "no_special_code", new String[]{"blocking_marker"});
            }
        }
        if (ar.getRefType() == ReferenceType.FIXED && ar.getType().isAbstract()) {
            this.error("A (fixed) actor reference must not be of an abstract type", null);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(DataClass dc) {
        if (dc == null) {
            return;
        }
        if (this.roomHelpers.isCircularClassHierarchy(dc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getDataClass_Base());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Check
    public void checkAttributeNotCircular(Attribute att) {
        if (att.eContainer() instanceof ActorClass) {
            return;
        }
        if (att.eContainer() instanceof PortClass) {
            return;
        }
        if (!(att.eContainer() instanceof DataClass)) {
            if (!RoomValidator.$assertionsDisabled) {
                throw new AssertionError((Object)"unexpected parent class");
            }
            return;
        }
        dc = (DataClass)att.eContainer();
        if (!this.roomHelpers.isCircularClassHierarchy(dc)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            if (att.getType().getType() == dc && !att.getType().isRef()) {
                this.error("Attribute type must not refer to own class or a super class", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__TYPE, "RoomJavaValidator.CircularContainment", new String[]{"" + att.getType().getType().getName().length()});
                break;
            }
            dc = dc.getBase();
lbl16:
            // 2 sources

            ** while (dc != null)
        }
lbl17:
        // 2 sources

    }

    @Check
    public void checkAttribute(Attribute attr) {
        if (attr.getType() == null) {
            this.error("missing type", attr, (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__TYPE);
        }
    }

    @Check
    public void checkAttributeNoStringArray(Attribute att) {
        PrimitiveType type;
        if (!att.getType().isRef() && att.getType().getType() instanceof PrimitiveType && (type = (PrimitiveType)att.getType().getType()).getName().equalsIgnoreCase("string") && att.getSize() > 0) {
            this.error("string type must have multiplicity 0", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__SIZE);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ProtocolClass pc) {
        if (pc == null) {
            return;
        }
        if (this.roomHelpers.isCircularClassHierarchy(pc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getProtocolClass_Base());
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ActorClass ac) {
        if (ac == null) {
            return;
        }
        if (this.roomHelpers.isCircularClassHierarchy(ac)) {
            this.error("Base classes are circular", (EStructuralFeature)FSMPackage.eINSTANCE.getModelComponent_Base());
        }
    }

    @Check
    public void checkExecModelConsistent(ActorClass ac) {
        if (this.roomHelpers.isCircularClassHierarchy(ac)) {
            return;
        }
        ComponentCommunicationType commType = ac.getCommType();
        String acName = ac.getName();
        switch (commType) {
            case ASYNCHRONOUS: {
                break;
            }
            case DATA_DRIVEN: {
                break;
            }
            case EVENT_DRIVEN: {
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)FSMPackage.eINSTANCE.getModelComponent_CommType());
            }
        }
        while (ac.getActorBase() != null) {
            if (commType == (ac = ac.getActorBase()).getCommType()) continue;
            this.error("Communication type '" + commType.getLiteral() + "' is not consistent with the " + "base class '" + ac.getName() + "' which uses '" + ac.getCommType().getLiteral() + "' (if not explicitly specified then 'eventdriven' is the default).", (EStructuralFeature)FSMPackage.eINSTANCE.getModelComponent_CommType(), INCONSISTENT_COMMUNICATION_TYPE, new String[]{ac.getCommType().getLiteral(), acName});
        }
    }

    @Check
    public void checkTopLevelRefinedStates(ActorClass ac) {
        List errors = this.validationUtil.checkTopLevelRefinedStates(ac);
        for (FSMValidationUtilXtend.Result err : errors) {
            this.error(err);
        }
    }

    @Check
    public void checkSubSystem(SubSystemClass ssc) {
        if (ssc.getActorRefs().isEmpty()) {
            this.warning("SubSystemClass must contain at least one ActorRef", (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ActorRefs());
        }
        if (ssc.getThreads().isEmpty()) {
            this.warning("at least one thread has to be defined", (EStructuralFeature)RoomPackage.Literals.SUB_SYSTEM_CLASS__THREADS, THREAD_MISSING, new String[]{"LogicalThread defaultThread"});
        }
        this.checkMappings(ssc.getActorInstanceMappings());
    }

    @Check
    public void checkLogicalSystem(LogicalSystem ls) {
        if (ls.getSubSystems().isEmpty()) {
            this.error("LogicalSystem must contain at least one SubSystemRef", (EStructuralFeature)RoomPackage.eINSTANCE.getLogicalSystem_SubSystems());
        }
    }

    @Check
    public void checkActorInstanceMapping(ActorInstanceMapping aim) {
        RefPath path;
        ActorContainerClass root = this.roomHelpers.getParentContainer(aim);
        if (root != null && !root.eIsProxy() && (path = aim.getPath()) != null) {
            String invalidSegment = this.roomHelpers.checkPath(root, path);
            if (invalidSegment != null) {
                this.error("no match for segment '" + invalidSegment + "'", (EStructuralFeature)RoomPackage.Literals.ACTOR_INSTANCE_MAPPING__PATH);
            } else {
                ActorRef aRef = this.roomHelpers.getLastActorRef(root, path);
                if (aRef == null) {
                    this.error("invalid actor reference", (EStructuralFeature)RoomPackage.Literals.ACTOR_INSTANCE_MAPPING__PATH);
                }
            }
        }
        this.checkMappings(aim.getActorInstanceMappings());
    }

    private void checkMappings(EList<ActorInstanceMapping> actorInstanceMappings) {
        HashSet<String> paths = new HashSet<String>();
        for (ActorInstanceMapping aim : actorInstanceMappings) {
            if (paths.add(aim.getPath().toString())) continue;
            EObject parent = aim.eContainer();
            int idx = actorInstanceMappings.indexOf((Object)aim);
            this.error("duplicate mapping", parent, aim.eContainingFeature(), idx, DUPLICATE_ACTOR_INSTANCE_MAPPING, new String[0]);
        }
    }

    @Check
    public void checkPortCommunicationCompatibility(ActorClass ac) {
        if (ac.getCommType() == ComponentCommunicationType.SYNCHRONOUS) {
            return;
        }
        ArrayList<Port> extPorts = new ArrayList<Port>();
        for (ExternalPort exPort : ac.getExternalPorts()) {
            extPorts.add(exPort.getInterfacePort());
        }
        this.checkPortCommunicationCompatibility(ac, extPorts, RoomPackage.eINSTANCE.getActorClass_ExternalPorts());
        this.checkPortCommunicationCompatibility(ac, (List<? extends InterfaceItem>)ac.getInternalPorts(), RoomPackage.eINSTANCE.getActorClass_InternalPorts());
        this.checkPortCommunicationCompatibility(ac, (List<? extends InterfaceItem>)ac.getServiceAccessPoints(), RoomPackage.eINSTANCE.getActorClass_ServiceAccessPoints());
        ArrayList<SPP> serviceImpls = new ArrayList<SPP>();
        for (ServiceImplementation si : ac.getServiceImplementations()) {
            serviceImpls.add(si.getSpp());
        }
        this.checkPortCommunicationCompatibility(ac, serviceImpls, RoomPackage.eINSTANCE.getActorClass_ServiceImplementations());
    }

    private void checkPortCommunicationCompatibility(ActorClass ac, List<? extends InterfaceItem> items, EReference ref) {
        boolean datadriven = ac.getCommType() == ComponentCommunicationType.DATA_DRIVEN;
        boolean eventdriven = ac.getCommType() == ComponentCommunicationType.EVENT_DRIVEN;
        boolean async = ac.getCommType() == ComponentCommunicationType.ASYNCHRONOUS;
        block4: for (InterfaceItem interfaceItem : items) {
            ProtocolClass pc = interfaceItem.getProtocol();
            switch (pc.getCommType()) {
                case DATA_DRIVEN: {
                    if (datadriven || async) continue block4;
                    this.error("ports with datadriven protocols not allowed", (EStructuralFeature)ref, items.indexOf(interfaceItem));
                    break;
                }
                case EVENT_DRIVEN: {
                    if (eventdriven || async) continue block4;
                    this.error("ports with eventdriven protocols not allowed", (EStructuralFeature)ref, items.indexOf(interfaceItem));
                }
            }
        }
    }

    @Check
    public void checkPortCompatibility(Binding bind) {
        if (EcoreUtil.ExternalCrossReferencer.find((EObject)bind).keySet().stream().anyMatch(eObj -> eObj.eIsProxy())) {
            return;
        }
        if (bind.getEndpoint1().getPort().getProtocol().eIsProxy() || bind.getEndpoint2().getPort().getProtocol().eIsProxy()) {
            return;
        }
        FSMValidationUtilXtend.Result result = this.validationUtil.isValid(bind);
        if (!result.isOk()) {
            this.error(result.getMsg(), bind, null);
        }
    }

    @Check
    public void checkServiceCompatibility(LayerConnection conn) {
        if (EcoreUtil.ExternalCrossReferencer.find((EObject)conn).keySet().stream().anyMatch(eObj -> eObj.eIsProxy())) {
            return;
        }
        if (conn.getFrom() instanceof RelaySAPoint && ((RelaySAPoint)conn.getFrom()).getRelay().getProtocol().eIsProxy()) {
            return;
        }
        if (conn.getTo().getService().getProtocol().eIsProxy()) {
            return;
        }
        FSMValidationUtilXtend.Result result = this.validationUtil.isValid(conn);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        }
    }

    @Check
    public void checkProtocol(ProtocolClass pc) {
        if (this.roomHelpers.isCircularClassHierarchy(pc)) {
            return;
        }
        switch (pc.getCommType()) {
            case DATA_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.DATA_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (this.roomHelpers.getAllMessages(pc, true).isEmpty()) {
                    this.error("at least one incoming message must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                }
                if (this.roomHelpers.getAllMessages(pc, false).isEmpty()) break;
                this.error("data driven protocols must have no outgoing messages", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
                break;
            }
            case EVENT_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.EVENT_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (!this.roomHelpers.getAllMessages(pc, true).isEmpty() || !this.roomHelpers.getAllMessages(pc, false).isEmpty() || !this.roomHelpers.getAllOperations(pc, true).isEmpty() || !this.roomHelpers.getAllOperations(pc, false).isEmpty()) break;
                this.error("at least one message/port operation (incoming or outgoing) must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
            }
        }
        this.checkDuplicates(pc, true);
        this.checkDuplicates(pc, false);
        this.checkMessagesStringAnnotation(pc);
        if (pc.getBase() != null && pc.getIncomingMessages().size() > 0 && pc.getOutgoingMessages().size() > 0) {
            this.warning("a derived protocol should add either incoming or outgoing messages, not both", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
        }
    }

    private void checkDuplicates(ProtocolClass pc, boolean incoming) {
        ValidationHelpers.NamedObjectList all = new ValidationHelpers.NamedObjectList();
        all.addAll(this.roomHelpers.getAllMessages(pc, incoming), (EStructuralFeature)RoomPackage.Literals.MESSAGE__NAME);
        all.addAll(this.roomHelpers.getAllOperations(pc, incoming), (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME);
        Iterable duplicates = ValidationHelpers.inSameResource((Iterable)ValidationHelpers.removeUniques((List)all), (Resource)pc.eResource());
        for (ValidationHelpers.NamedObject dupl : duplicates) {
            this.error("duplicate message name", dupl.getObj(), dupl.getFeature());
        }
    }

    private void checkMessagesStringAnnotation(ProtocolClass pc) {
        List<Message> msgs = this.roomHelpers.getAllMessages(pc, true);
        msgs.addAll(this.roomHelpers.getAllMessages(pc, false));
        for (Message msg : msgs) {
            boolean isStringMessage = msg.getAnnotations().stream().anyMatch(an -> an.getType().getName().equals("StringMessage"));
            if (!isStringMessage) continue;
            boolean isIncomming = this.roomHelpers.getAllIncomingMessages(pc).contains(msg);
            if (msg.getData() == null) {
                this.error("The @StringMessage annotation may only be used on messages with charPtr payload.", msg, (EStructuralFeature)RoomPackage.Literals.MESSAGE__NAME);
            } else if (!msg.getData().getRefType().getType().getName().equals("charPtr")) {
                this.error("The @StringMessage annotation may only be used on messages with charPtr payload.", msg, (EStructuralFeature)RoomPackage.Literals.MESSAGE__DATA);
            } else if (msg.getData().getRefType().isRef()) {
                this.error("The @StringMessage annotation may only be used on messages with charPtr payload. Found charPtr ref.", msg, (EStructuralFeature)RoomPackage.Literals.MESSAGE__DATA);
            }
            PortClass portClass = pc.getRegular();
            if (isIncomming) {
                portClass = pc.getConjugated();
            }
            if (portClass == null) continue;
            for (MessageHandler handler : portClass.getMsgHandlers()) {
                if (handler.getMsg() != msg) continue;
                String errorMsg = "If the @StringMessage annotation is used no custom send handler can be defined.";
                this.error(errorMsg, msg, (EStructuralFeature)RoomPackage.Literals.MESSAGE__NAME);
                this.error(errorMsg, handler, (EStructuralFeature)RoomPackage.Literals.MESSAGE_HANDLER__MSG);
            }
        }
    }

    @Check
    public void checkInheritedNames(ActorClass ac) {
        HashSet overrideFeatures = Sets.newHashSet((Object[])new EReference[]{RoomPackage.Literals.ACTOR_CLASS__OPERATIONS, RoomPackage.Literals.ACTOR_CLASS__STRUCTORS, FSMPackage.Literals.MODEL_COMPONENT__STATE_MACHINE});
        final HashMap superNames = Maps.newHashMap();
        ValidationHelpers.saveRecursiveVisitor((EObject)ac.getActorBase(), (Function)new Function<ActorClass, ActorClass>(){

            public ActorClass apply(ActorClass input) {
                for (EObject containee : input.eContents()) {
                    String name;
                    QualifiedName qualifiedName = (QualifiedName)RoomValidator.this.fqnProvider.apply((Object)containee);
                    String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
                    if (name == null || superNames.containsKey(name)) continue;
                    superNames.put(name, containee);
                }
                return input.getActorBase();
            }
        });
        for (EObject containee : ac.eContents()) {
            EObject existing;
            String name;
            QualifiedName qualifiedName = (QualifiedName)this.fqnProvider.apply((Object)containee);
            String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
            if (name == null || (existing = (EObject)superNames.get(name)) == null || overrideFeatures.contains(containee.eContainingFeature()) && containee.eContainingFeature() == existing.eContainingFeature() || !superNames.containsKey(((QualifiedName)this.fqnProvider.apply((Object)existing)).getLastSegment())) continue;
            this.issueInheritedNameError(containee, existing);
        }
    }

    @Check
    public void checkInheritedNames(DataClass dc) {
        HashSet overrideFeatures = Sets.newHashSet((Object[])new EReference[]{RoomPackage.Literals.DATA_CLASS__OPERATIONS, RoomPackage.Literals.DATA_CLASS__STRUCTORS});
        final HashMap superNames = Maps.newHashMap();
        ValidationHelpers.saveRecursiveVisitor((EObject)dc.getBase(), (Function)new Function<DataClass, DataClass>(){

            public DataClass apply(DataClass input) {
                for (EObject containee : input.eContents()) {
                    String name;
                    QualifiedName qualifiedName = (QualifiedName)RoomValidator.this.fqnProvider.apply((Object)containee);
                    String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
                    if (name == null || superNames.containsKey(name)) continue;
                    superNames.put(name, containee);
                }
                return input.getBase();
            }
        });
        for (EObject containee : dc.eContents()) {
            EObject existing;
            String name;
            QualifiedName qualifiedName = (QualifiedName)this.fqnProvider.apply((Object)containee);
            String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
            if (name == null || (existing = (EObject)superNames.get(name)) == null || overrideFeatures.contains(containee.eContainingFeature()) && containee.eContainingFeature() == existing.eContainingFeature() || !superNames.containsKey(((QualifiedName)this.fqnProvider.apply((Object)existing)).getLastSegment())) continue;
            this.issueInheritedNameError(containee, existing);
        }
    }

    private void issueInheritedNameError(EObject target, EObject source) {
        String targetName = ((QualifiedName)this.fqnProvider.apply((Object)target)).getLastSegment();
        String sourceName = ((QualifiedName)this.fqnProvider.apply((Object)source)).getLastSegment();
        String sourceType = source.eClass().getName();
        String sourceOwner = this.roomHelpers.getRoomClass(source).getName();
        this.error("Name '" + targetName + "' is already assigned to " + sourceType + " " + sourceOwner + "." + sourceName, target, target.eClass().getEStructuralFeature("name"));
    }

    @Check
    public void checkMessage(Message msg) {
        ProtocolClass pc = (ProtocolClass)msg.eContainer();
        if (pc.getCommType() == CommunicationType.DATA_DRIVEN && msg.getData() == null) {
            this.error("Messages of data driven protocols must carry data", (EStructuralFeature)RoomPackage.Literals.MESSAGE__DATA);
        }
    }

    @Check
    public void checkMessageFromIf(MessageFromIf mfi) {
        ProtocolClass protocol;
        if (mfi.getFrom() != null && (protocol = ((InterfaceItem)mfi.getFrom()).getProtocol()) != null && !protocol.eIsProxy() && protocol.getCommType() != CommunicationType.EVENT_DRIVEN) {
            this.error("port must have event driven protocol", (EObject)mfi, (EStructuralFeature)FSMPackage.eINSTANCE.getMessageFromIf_From());
        }
    }

    @Check
    public void checkDataClass(DataClass dc) {
        if (dc.getAttributes().isEmpty() && dc.getBase() == null) {
            this.error("Non-derived data classes have to define at least one attribute", (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__ATTRIBUTES);
        }
        dc.getStructors().stream().filter(op -> op.isConstructor()).forEach(dtor -> this.warning("Not implemented for C generation", (EObject)dtor, null));
        dc.getStructors().stream().filter(op -> !op.isConstructor()).forEach(dtor -> this.error("DataClass cannot have a destructor", (EObject)dtor, null));
    }

    @Check
    public void checkPortClassContents(PortClass pc) {
        if (pc.getAttributes().isEmpty() && pc.getMsgHandlers().isEmpty() && pc.getOperations().isEmpty()) {
            this.error("port class must not be empty", pc, (EStructuralFeature)RoomPackage.Literals.PORT_CLASS__ATTRIBUTES);
        }
    }

    @Check
    public void checkAnnotationTarget(Annotation a) {
        if (a.getType() == null || a.getType().eIsProxy()) {
            return;
        }
        EObject parent = a.eContainer();
        EList targetList = a.getType().getTargets();
        RoomAnnotationTargetEnum invalidTargetType = null;
        if (parent instanceof ActorClass) {
            ActorClass actorParent = (ActorClass)parent;
            if (actorParent.getAnnotations().contains((Object)a) && !targetList.contains((Object)RoomAnnotationTargetEnum.ACTOR_CLASS.getLiteral())) {
                invalidTargetType = RoomAnnotationTargetEnum.ACTOR_CLASS;
            } else if (actorParent.getBehaviorAnnotations().contains((Object)a) && !targetList.contains((Object)RoomAnnotationTargetEnum.ACTOR_BEHAVIOR.getLiteral())) {
                invalidTargetType = RoomAnnotationTargetEnum.ACTOR_BEHAVIOR;
            }
        } else if (parent instanceof DataClass && !targetList.contains((Object)RoomAnnotationTargetEnum.DATA_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.DATA_CLASS;
        } else if (parent instanceof ProtocolClass && !targetList.contains((Object)RoomAnnotationTargetEnum.PROTOCOL_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.PROTOCOL_CLASS;
        } else if (parent instanceof LogicalSystem && !targetList.contains((Object)RoomAnnotationTargetEnum.LOGICAL_SYSTEM_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.LOGICAL_SYSTEM_CLASS;
        } else if (parent instanceof SubSystemClass && !targetList.contains((Object)RoomAnnotationTargetEnum.SUBSYSTEM_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.SUBSYSTEM_CLASS;
        } else if (parent instanceof Port && !targetList.contains((Object)RoomAnnotationTargetEnum.PORT.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.PORT;
        } else if (parent instanceof Message && !targetList.contains((Object)RoomAnnotationTargetEnum.MESSAGE.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.MESSAGE;
        } else if (parent instanceof RoomModel && !targetList.contains((Object)RoomAnnotationTargetEnum.ROOM_MODEL.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.ROOM_MODEL;
        }
        if (invalidTargetType != null) {
            this.error("AnnotationType " + a.getType().getName() + " is not allowed for target " + invalidTargetType.getLiteral(), (EObject)a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__TYPE, INVALID_ANNOTATION_TARGET, new String[]{a.getType().getName(), String.valueOf(a.getType().getName()) + " {target = " + invalidTargetType.getLiteral() + " ...", invalidTargetType.getLiteral()});
        }
    }

    @Check
    public void checkTestInstanceAnnotation(Annotation annotation) {
        if (annotation.getType() == null || !"TestInstance".equals(annotation.getType().getName())) {
            return;
        }
        RoomClass roomClass = this.roomHelpers.getRoomClass((EObject)annotation);
        if (roomClass instanceof SubSystemClass && ((SubSystemClass)roomClass).getThreads().size() > 0) {
            this.error("Annotation 'TestInstance' does not allow (explicit) LogicalThreads", (EObject)annotation, null);
        }
    }

    @Check
    public void checkEnumeration(EnumerationType et) {
        if (et.getPrimitiveType() != null && et.getPrimitiveType().getType() != LiteralType.INT) {
            this.error("enumerations must be of integer type", (EStructuralFeature)RoomPackage.Literals.ENUMERATION_TYPE__PRIMITIVE_TYPE);
        }
        if (et.getLiterals().isEmpty()) {
            this.error("at least one literal has to be specified", (EStructuralFeature)RoomPackage.Literals.ENUMERATION_TYPE__LITERALS);
        }
    }

    private void error(FSMValidationUtilXtend.Result result) {
        this.error(result.getMsg(), result.getSource(), result.getFeature(), result.getIndex(), "no_special_code", new String[]{"blocking_marker"});
    }

    @Check
    public void checkOperations(ActorClass ac) {
        if (this.roomHelpers.isCircularClassHierarchy(ac)) {
            return;
        }
        for (Operation op : ac.getOperations()) {
            if (!ac.getName().equals(op.getName())) continue;
            this.warning("Operation name is discouraged, may be mistaken for ctor/dtor", op, (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME);
        }
        this.checkOperationsOverride(this.roomHelpers.getAllOperations(ac), (List<StandardOperation>)ac.getOperations());
    }

    @Check
    public void checkOperations(DataClass dc) {
        if (this.roomHelpers.isCircularClassHierarchy(dc)) {
            return;
        }
        for (Operation op : dc.getOperations()) {
            if (!dc.getName().equals(op.getName())) continue;
            this.warning("Operation name is discouraged, may be mistaken for ctor/dtor", op, (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME);
        }
        this.checkOperationsOverride(this.roomHelpers.getAllOperations(dc), (List<StandardOperation>)dc.getOperations());
    }

    private void checkOperationsOverride(List<StandardOperation> allOperations, List<StandardOperation> toCheck) {
        HashMap map = Maps.newHashMap();
        for (StandardOperation op : allOperations) {
            if (map.containsKey(op.getName())) continue;
            map.put(op.getName(), op);
        }
        for (StandardOperation op : toCheck) {
            if (op.getName() == null) continue;
            StandardOperation baseOp = (StandardOperation)map.get(op.getName());
            if (baseOp == op) {
                if (!op.isOverride()) continue;
                this.error("Operation '" + op.getName() + "' must override an operation in super class", op, (EStructuralFeature)RoomPackage.Literals.STANDARD_OPERATION__OVERRIDE, OPERATION_EXTRANEOUS_OVERRIDE, new String[0]);
                continue;
            }
            String baseOpFQN = String.valueOf(this.roomHelpers.getRoomClass(baseOp).getName()) + "." + baseOp.getName() + "()";
            if (!op.isOverride()) {
                this.error("Implicit override of operation " + baseOpFQN, op, (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME, OPERATION_MISSING_OVERRIDE, new String[0]);
                continue;
            }
            if (!this.roomHelpers.matchingArguments(baseOp, op)) {
                this.error("Arguments must be identical to overriden operation in " + baseOpFQN, op, (EStructuralFeature)RoomPackage.Literals.OPERATION__ARGUMENTS);
            }
            if (this.roomHelpers.matchingReturnType(baseOp, op)) continue;
            this.error("Return type  must be identical to overriden operation " + baseOpFQN, op, (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURN_TYPE);
        }
    }

    @Check
    public void checkMessageData(MessageData m) {
        if (m.getDeprecatedName() != null) {
            this.warning("The data name of messages is deprecated (always named 'transitionData' in action code)", (EStructuralFeature)RoomPackage.Literals.MESSAGE_DATA__DEPRECATED_NAME, DEPRECATED_MESSAGE_DATA_NAME, new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDeprecatedRefs(RoomModel container) {
        HashMap deprecatedCandidates = Maps.newHashMap();
        Function findDeprecatedAnnotation = eObj -> {
            if (eObj instanceof RoomElement && this.roomHelpers.canHaveAnnotations((RoomElement)eObj) && !deprecatedCandidates.containsKey(eObj)) {
                Annotation annotation = this.roomHelpers.findDeprecatedAnnotation((RoomElement)eObj);
                deprecatedCandidates.put(eObj, annotation);
            }
            return (Annotation)deprecatedCandidates.get(eObj);
        };
        Predicate isError = anno -> anno.getAttributes().stream().anyMatch(keyValue -> "error".equals(keyValue.getKey()) && ((BooleanLiteral)keyValue.getValue()).isIsTrue());
        Map intCrossRefs = EcoreUtil.CrossReferencer.find((Collection)container.eContents());
        Map extCrossRef = EcoreUtil.ExternalCrossReferencer.find((EObject)container);
        FluentIterable.concat(intCrossRefs.entrySet(), extCrossRef.entrySet()).forEach(entry -> {
            Annotation annotation = (Annotation)findDeprecatedAnnotation.apply((Object)((EObject)entry.getKey()));
            if (annotation != null) {
                if (isError.apply((Object)annotation)) {
                    ((Collection)entry.getValue()).forEach(setting -> this.error("Deprecated - this element cannot be used anymore", setting.getEObject(), setting.getEStructuralFeature()));
                } else {
                    ((Collection)entry.getValue()).forEach(setting -> this.warning("Deprecated", setting.getEObject(), setting.getEStructuralFeature()));
                }
            }
        });
    }
}

