/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.base.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.StringLiteral;

public class BaseHelpers {
    public boolean isAnnotationPresent(List<Annotation> annotations, String name) {
        for (Annotation annotation : annotations) {
            if (annotation.getType() == null || !name.equals(annotation.getType().getName())) continue;
            return true;
        }
        return false;
    }

    public List<KeyValue> getAttributes(List<Annotation> annotations, String name) {
        for (Annotation annotation : annotations) {
            if (!annotation.getType().getName().equals(name)) continue;
            return annotation.getAttributes();
        }
        return Collections.emptyList();
    }

    public boolean isAttributePresent(List<Annotation> annotations, String name, String key) {
        List<KeyValue> attributes = this.getAttributes(annotations, name);
        for (KeyValue attrib : attributes) {
            if (!attrib.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(List<Annotation> annotations, String name, String key) {
        List<KeyValue> attributes = this.getAttributes(annotations, name);
        for (KeyValue attrib : attributes) {
            if (!key.equals(attrib.getKey()) || attrib.getValue() == null) continue;
            return this.literalToString(attrib.getValue());
        }
        return "";
    }

    public boolean isAttributePresent(Annotation annotation, String key) {
        for (KeyValue attrib : annotation.getAttributes()) {
            if (!attrib.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(Annotation annotation, String key) {
        for (KeyValue attrib : annotation.getAttributes()) {
            if (!attrib.getKey().equals(key)) continue;
            return this.literalToString(attrib.getValue());
        }
        return "";
    }

    public String literalToString(Literal l) {
        if (l instanceof BooleanLiteral) {
            return ((BooleanLiteral)l).isIsTrue() ? "true" : "false";
        }
        if (l instanceof IntLiteral) {
            return Long.toString(((IntLiteral)l).getValue());
        }
        if (l instanceof RealLiteral) {
            return Double.toString(((RealLiteral)l).getValue());
        }
        if (l instanceof StringLiteral) {
            return ((StringLiteral)l).getValue();
        }
        assert (false) : "unexpected sub type: " + l;
        return "";
    }
}

