/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.List;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public final class Exceptions {
    private Exceptions() {
    }

    public static String exToStr(Throwable ex) {
        List<String> rslt = Lists.list();
        Object exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <no error message available>";
        }
        rslt.add("ERROR: " + (String)exMsg);
        if (ex.getCause() != null) {
            Exceptions.exToStrAddCauses(ex.getCause(), rslt);
        }
        return String.join((CharSequence)Strings.NL, rslt);
    }

    private static void exToStrAddCauses(Throwable ex, List<String> rslt) {
        Object exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <cause details not available>";
        }
        rslt.add("CAUSE: " + (String)exMsg);
        if (ex.getCause() != null) {
            Exceptions.exToStrAddCauses(ex.getCause(), rslt);
        }
    }

    public static String exToLine(Throwable ex) {
        Object exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <no error message available>";
        }
        return ex.getCause() == null ? exMsg : (String)exMsg + Exceptions.exToLineCauses(ex.getCause());
    }

    private static String exToLineCauses(Throwable ex) {
        Object exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <cause details not available>";
        }
        exMsg = " / Cause: " + (String)exMsg;
        return ex.getCause() == null ? exMsg : (String)exMsg + Exceptions.exToLineCauses(ex.getCause());
    }
}

