/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.xtend.ast.GenericExtension;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtFile;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtResource;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.HelperOperationCall;

public class QvtExtension
implements GenericExtension {
    private QvtResource qvtResource;
    private List<String> parameterNames;
    private List<EClassifier> parameterTypes;
    private String fileName;
    private HelperOperationCall helperCall;

    public QvtExtension(HelperOperationCall helperOperationCall, QvtFile qvtFile, String fileName) {
        this.helperCall = helperOperationCall;
        this.qvtResource = qvtFile;
        this.fileName = fileName;
    }

    public void setQvtResource(QvtResource resource) {
        this.qvtResource = resource;
    }

    public QvtResource getQvtResource() {
        return this.qvtResource;
    }

    @Override
    public Object evaluate(Object[] parameters, ExecutionContext ctx) {
        try {
            if (this.helperCall.isContextual()) {
                assert (parameters.length > 0);
                Object self = parameters[0];
                Object[] actualParameters = new Object[parameters.length - 1];
                System.arraycopy(parameters, 1, actualParameters, 0, parameters.length - 1);
                return this.helperCall.invoke(self, actualParameters);
            }
            return this.helperCall.invoke(parameters);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Illigal arguments in QVT helper (" + this.getSignature(this.helperCall.getOperation()) + ") call: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invocation target exception in QVT helper (" + this.getSignature(this.helperCall.getOperation()) + ") call: " + e.getMessage());
        }
    }

    private String getSignature(Helper operation) {
        StringBuilder sb = new StringBuilder();
        if (operation.getContext() != null) {
            sb.append(operation.getContext().getEType().getName());
            sb.append("::");
        }
        sb.append(operation.getName());
        sb.append("(");
        for (EParameter parameter : operation.getEParameters()) {
            if (sb.lastIndexOf("(") != sb.length() - 1) {
                sb.append(",");
            }
            sb.append(parameter.getName());
            sb.append(":");
            sb.append(parameter.getEType().getName());
        }
        sb.append(")");
        sb.append(":");
        sb.append(operation.getEType().getName());
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getHelper().getName();
    }

    @Override
    public List<EClassifier> getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = new ArrayList<EClassifier>();
            if (this.getHelper().getContext() != null) {
                this.parameterTypes.add(this.getHelper().getContext().getEType());
            }
            for (EParameter parameter : this.getHelper().getEParameters()) {
                this.parameterTypes.add(parameter.getEType());
            }
            this.parameterTypes = Collections.unmodifiableList(this.parameterTypes);
        }
        return this.parameterTypes;
    }

    @Override
    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList<String>();
            for (EParameter parameter : this.getHelper().getEParameters()) {
                this.parameterNames.add(parameter.getName());
            }
            this.parameterNames = Collections.unmodifiableList(this.parameterNames);
        }
        return this.parameterNames;
    }

    @Override
    public EClassifier getReturnType(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return this.getHelper().getEType();
    }

    @Override
    public void init(ExecutionContext ctx) {
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    private Helper getHelper() {
        return this.helperCall.getOperation();
    }

    @Override
    public EClassifier getContext() {
        return this.helperCall.getContextType();
    }

    @Override
    public EOperation getOperation() {
        return this.helperCall.getOperation();
    }
}

