/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandIterator;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.ecore.CollectionType;

public class ForEachStatement
extends Statement {
    public static final String ITERATOR_VAR_NAME = "iterator";
    private final Statement[] body;
    private final ExpressionHelper target;
    private final ExpressionHelper separator;
    private final Identifier variable;
    private final Identifier iteratorName;

    public ForEachStatement(int start, int end, int line, Identifier variable, OCLExpressionCS target, Statement[] body, OCLExpressionCS separator, Identifier iterator) {
        super(start, end, line);
        this.variable = variable;
        this.target = new ExpressionHelper(target, this);
        this.body = body;
        this.separator = separator == null ? null : new ExpressionHelper(separator, this);
        this.iteratorName = iterator;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = this.target.analyze(ctx, issues);
        if (this.separator != null) {
            EClassifier sepT = this.separator.analyze(ctx, issues);
            if (ctx.getOCLEnvironment().getOCLStandardLibrary().getString() != sepT) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "String expected!", this.target));
            }
        }
        if (t != null) {
            if (t instanceof CollectionType) {
                t = (EClassifier)((CollectionType)t).getElementType();
            } else {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Collection type expected!", this.target));
                return;
            }
        }
        ctx = ctx.cloneWithVariable(new Variable(this.variable.getValue(), t, null));
        if (this.iteratorName != null) {
            ctx = ctx.cloneWithVariable(new Variable(this.iteratorName.getValue(), (EClassifier)BuiltinMetaModel.ITERATOR_TYPE, null));
        }
        Statement[] statementArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            statement.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        EClassifier targetType = this.target.analyze(ctx, issues);
        if (issues.size() > 0 || !(targetType instanceof CollectionType)) {
            throw new EvaluationException("Can't evaluate FOREACH expression: target collection type cannot be defined", this.target);
        }
        EClassifier targetElementType = (EClassifier)((CollectionType)targetType).getElementType();
        Object o = this.target.evaluate(ctx);
        if (!(o instanceof Collection)) {
            throw new EvaluationException("Collection expected (was: " + o.getClass().getName() + ")!", this.target);
        }
        Collection col = (Collection)o;
        String sep = (String)(this.separator != null ? this.separator.evaluate(ctx) : null);
        XpandIterator iterator = new XpandIterator(col.size());
        if (this.iteratorName != null) {
            ctx = ctx.cloneWithVariable(new Variable(this.iteratorName.getValue(), (EClassifier)BuiltinMetaModel.ITERATOR_TYPE, iterator));
        }
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!BuiltinMetaModel.isAssignableFrom(ctx, targetElementType, BuiltinMetaModel.getType(ctx, element))) {
                throw new EvaluationException("Can't evaluate FOREACH expression: actual collection element type is not assignable to declared collection element type", this);
            }
            ctx = ctx.cloneWithVariable(new Variable(this.variable.getValue(), targetElementType, element));
            int i = 0;
            while (i < this.body.length) {
                this.body[i].evaluate(ctx);
                ++i;
            }
            if (sep != null && iter.hasNext()) {
                ctx.getScope().getOutput().write(sep);
            }
            iterator.increment();
        }
    }

    ExpressionHelper getSeparator() {
        return this.separator;
    }

    ExpressionHelper getTarget() {
        return this.target;
    }

    Statement[] getBody() {
        return this.body;
    }
}

