/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPageExtension;

public abstract class ElementSelectorExtension
extends Observable
implements ModelSelectionPageExtension {
    protected List<EObject> modelElements = new ArrayList<EObject>();
    protected EObject selectedModelElement;

    protected abstract String getModelElementName();

    protected abstract String getModelElementLabel(EObject var1);

    protected EClass getModelElementClass() {
        return null;
    }

    protected boolean isApplicable(EObject element) {
        return true;
    }

    protected List<EObject> getModelElements(Resource resource) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            boolean applicableType;
            EObject next = (EObject)it.next();
            boolean bl = applicableType = this.getModelElementClass() == null || next.eClass().equals(this.getModelElementClass());
            if (!applicableType || !this.isApplicable(next)) continue;
            elements.add(next);
        }
        this.sortModelElements(elements);
        return elements;
    }

    protected void fireModelElementChanged() {
        this.setChanged();
        this.notifyObservers(this.selectedModelElement);
    }

    public EObject getModelElement() {
        return this.selectedModelElement;
    }

    protected void sortModelElements(List<EObject> elements) {
        Collections.sort(elements, new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                String n1 = ElementSelectorExtension.this.getModelElementLabel(o1);
                String n2 = ElementSelectorExtension.this.getModelElementLabel(o2);
                return n1.compareTo(n2);
            }
        });
    }
}

