/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.E_TripleFn;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.ExprVisitorBase;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.Unstable;
import org.apache.jena.sparql.function.FunctionEnv;

public class ExprLib {
    private static ExprTransform replaceAgg = new ExprTransformCopy(){

        @Override
        public Expr transform(ExprAggregator eAgg) {
            return eAgg.getAggVar();
        }
    };
    private static ExprVisitor exprVisitorCheckForNonFunctions = new ExprVisitorBase(){

        @Override
        public void visit(ExprFunction0 func) {
            this.check(func);
        }

        @Override
        public void visit(ExprFunction1 func) {
            this.check(func);
        }

        @Override
        public void visit(ExprFunction2 func) {
            this.check(func);
        }

        @Override
        public void visit(ExprFunction3 func) {
            this.check(func);
        }

        @Override
        public void visit(ExprFunctionN func) {
            this.check(func);
        }

        private void check(ExprFunction exprFn) {
            if (exprFn instanceof Unstable) {
                throw new ExprUnstable();
            }
        }
    };

    public static NodeValue evalOrNull(Expr expr, Binding binding, FunctionEnv functionEnv) {
        return ExprLib.evalOrElse(expr, binding, functionEnv, null);
    }

    private static NodeValue evalOrException(Expr expr, Binding binding, FunctionEnv functionEnv) {
        return expr.eval(binding, functionEnv);
    }

    private static NodeValue evalOrElse(Expr expr, Binding binding, FunctionEnv functionEnv, NodeValue exceptionValue) {
        if (expr.isConstant()) {
            return expr.getConstant();
        }
        if (expr.isVariable()) {
            Var v = expr.asVar();
            Node n = binding.get(v);
            if (n == null) {
                return exceptionValue;
            }
            NodeValue nv = NodeValue.makeNode(n);
            return nv;
        }
        try {
            return expr.eval(binding, functionEnv);
        }
        catch (ExprEvalException ex) {
            return exceptionValue;
        }
    }

    public static Expr foldConstants(Expr expr) {
        return ExprTransformer.transform((ExprTransform)new ExprTransformConstantFold(), expr);
    }

    public static Expr replaceAggregateByVariable(Expr expr) {
        return ExprTransformer.transform(replaceAgg, expr);
    }

    public static boolean isAssignmentSafeEquality(Expr expr) {
        return ExprLib.isAssignmentSafeEquality(expr, false, false);
    }

    public static boolean isAssignmentSafeEquality(Expr expr, boolean graphHasStringEquality, boolean graphHasNumercialValueEquality) {
        if (!(expr instanceof E_Equals) && !(expr instanceof E_SameTerm)) {
            return false;
        }
        ExprFunction2 eq = (ExprFunction2)expr;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return false;
        }
        if (!constant.isLiteral()) {
            return true;
        }
        if (expr instanceof E_SameTerm) {
            if (graphHasStringEquality && constant.isString()) {
                return false;
            }
            return !graphHasNumercialValueEquality || !constant.isNumber();
        }
        if (expr instanceof E_Equals) {
            if (!graphHasStringEquality && constant.isString()) {
                return false;
            }
            return graphHasNumercialValueEquality || !constant.isNumber();
        }
        throw new ARQInternalErrorException();
    }

    public static boolean isStable(Expr expr) {
        try {
            Walker.walk(expr, exprVisitorCheckForNonFunctions);
            return true;
        }
        catch (ExprUnstable ex) {
            return false;
        }
    }

    public static Expr nodeToExpr(Node n) {
        if (n.isVariable()) {
            return new ExprVar(n);
        }
        if (n.isNodeTriple()) {
            return new ExprTripleTerm(n);
        }
        return NodeValue.makeNode(n);
    }

    public static Expr rewriteTriple(Triple t) {
        Expr e1 = ExprLib.nodeToExpr(t.getSubject());
        Expr e2 = ExprLib.nodeToExpr(t.getPredicate());
        Expr e3 = ExprLib.nodeToExpr(t.getObject());
        return new E_TripleFn(e1, e2, e3);
    }

    private static class ExprUnstable
    extends ExprException {
        private ExprUnstable() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

