/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.provider;

import java.io.File;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfstore.client.provider.ESAbstractClientURIConverter;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.provider.ProjectSpaceFileURIHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMIClientURIConverter
extends ESAbstractClientURIConverter {
    public static final String PROJECT_SAPCE_DIRECTORY_PREFIX = "ps-";
    private final String projectSpaceFileName = "projectspace";
    private final String projectSpaceFileExtension = ExportImportDataUnits.ProjectSpace.getExtension();
    private final String localChangePackageFileName = "operations";
    private final String localChangePackageExtension = ".eoc";
    private final String projectFragmentFileName = "project";
    private final String projectFragmentExtension = ExportImportDataUnits.Project.getExtension();

    public XMIClientURIConverter() {
        this.getURIHandlers().add(0, (Object)new ProjectSpaceFileURIHandler(this.getExtensionsMap()));
    }

    @Override
    protected URI normalizeWorkspaceURI(String profile) {
        return URI.createFileURI((String)(String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + "workspace.ucw"));
    }

    @Override
    protected URI normalizeProjectURI(String profile, String projectId) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectSpaceDirectory(projectId)) + "project" + this.projectFragmentExtension));
    }

    @Override
    protected URI normalizeOperationsURI(String profile, String projectId) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectSpaceDirectory(projectId)) + "operations" + ".eoc"));
    }

    @Override
    protected URI normalizeProjectSpaceURI(String profile, String projectId) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectSpaceDirectory(projectId)) + "projectspace" + this.projectSpaceFileExtension));
    }

    private String getProjectSpaceDirectory(String projectId) {
        return String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + PROJECT_SAPCE_DIRECTORY_PREFIX + projectId + File.separatorChar;
    }

    private HashSet<String> getExtensionsMap() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(this.projectSpaceFileExtension);
        extensions.add(".eoc");
        extensions.add(this.projectFragmentExtension);
        return extensions;
    }
}

