/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.test;

import java.util.concurrent.Callable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.fuzzy.Annotations;
import org.eclipse.emf.emfstore.fuzzy.FuzzyRunner;
import org.eclipse.emf.emfstore.fuzzy.emf.EMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.test.FuzzyProjectTest;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceImpl;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FuzzyRunner.class)
@Annotations.DataProvider(value=EMFDataProvider.class)
public class SerializationTest
extends FuzzyProjectTest {
    @Test
    public void loadAndSaveToResource() {
        ProjectSpace projectSpace = this.getProjectSpace();
        final ModelMutatorConfiguration mmc = this.getModelMutatorConfiguration(projectSpace.getProject());
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                SerializationTest.this.getUtil().mutate(mmc);
            }
        });
        projectSpace.save();
        ((ESWorkspaceProviderImpl)ESWorkspaceProvider.INSTANCE).dispose();
        ESWorkspaceProviderImpl.init();
        EList projectSpaces = ((WorkspaceImpl)ESWorkspaceProvider.INSTANCE.getWorkspace()).getProjectSpaces();
        if (projectSpaces.size() != 1) {
            throw new IllegalStateException("There must be exactly one projectSpace in the workspace! Current value: " + projectSpaces.size());
        }
        ProjectSpace reloadedProjectSpace = (ProjectSpace)projectSpaces.get(0);
        try {
            if (!ModelUtil.areEqual((IdEObjectCollection)reloadedProjectSpace.getProject(), (IdEObjectCollection)projectSpace.getProject())) {
                this.fail(reloadedProjectSpace.getProject(), projectSpace.getProject());
            }
        }
        finally {
            this.setProjectSpace(reloadedProjectSpace);
        }
    }

    public boolean projectSpaceCopyNeeded() {
        return false;
    }
}

