/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.jobs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.packs.Activator;
import org.eclipse.embedcdt.packs.core.ConsoleStream;
import org.eclipse.embedcdt.packs.core.Utils;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.eclipse.embedcdt.packs.data.cmsis.PdscParserFull;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.console.MessageConsoleStream;
import org.xml.sax.SAXParseException;

public class ParsePdscRunnable
implements IRunnableWithProgress {
    private static boolean fgRunning = false;
    private MessageConsoleStream fgOut = ConsoleStream.getConsoleOut();
    private PackNode fgVersionNode;

    public ParsePdscRunnable(String name, PackNode versionNode) {
        this.fgVersionNode = versionNode;
    }

    public void run(IProgressMonitor monitor) {
        IPath folderPath;
        try {
            folderPath = PacksStorage.getFolderPath();
        }
        catch (IOException iOException) {
            return;
        }
        if (fgRunning) {
            return;
        }
        fgRunning = true;
        long beginTime = System.currentTimeMillis();
        this.fgOut.println();
        this.fgOut.println(Utils.getCurrentDateTime());
        String destFolder = this.fgVersionNode.getProperty("dest.folder");
        String pdscName = this.fgVersionNode.getProperty("pdsc.name");
        IPath path = folderPath.append(destFolder).append(pdscName);
        this.fgOut.println("Parsing \"" + path.toOSString() + "\"...");
        Node outlineNode = null;
        try {
            PdscParserFull pdsc = new PdscParserFull();
            pdsc.parseXml(path);
            outlineNode = pdsc.parsePdscFull();
            outlineNode.putProperty("dest.folder", destFolder);
            this.fgVersionNode.setOutline(outlineNode);
            PackNode packNode = (PackNode)this.fgVersionNode.getParent();
            if (packNode.getFirstChild().getName().equals(this.fgVersionNode.getName())) {
                packNode.setOutline(outlineNode);
            }
            pdsc.parseExamples((Node)this.fgVersionNode);
        }
        catch (FileNotFoundException e) {
            this.fgOut.println("Failed: " + e.toString());
        }
        catch (SAXParseException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + path.toString() + ", line: " + e.getLineNumber() + ", column: " + e.getColumnNumber();
            Activator.log((Throwable)e);
            this.fgOut.println("Failed: " + msg);
        }
        catch (Exception e) {
            Activator.log((Throwable)e);
            this.fgOut.println("Failed: " + e.toString());
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - beginTime;
        if (duration == 0L) {
            duration = 1L;
        }
        this.fgOut.println("Parse completed in " + duration + "ms.");
        fgRunning = false;
    }
}

