/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import org.eclipse.elk.alg.disco.debug.views.ConfigState;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderer;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingCanvas;
import org.eclipse.elk.alg.disco.debug.views.DisCoImageExportAction;
import org.eclipse.elk.alg.disco.debug.views.DropdownIntRangeAction;
import org.eclipse.elk.alg.disco.debug.views.SelectivePaintToggleAction;
import org.eclipse.elk.alg.disco.debug.views.State;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DisCoDebugView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.elk.debug.disCoDebugView";
    private ScrolledComposite scrolledComposite;
    private DisCoGraphRenderingCanvas graphCanvas;

    public static void updateWithGraph(final ElkNode graph) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DisCoDebugView activeView = DisCoDebugView.findView();
                if (graph != null && activeView != null) {
                    ElkNode nodeCopy = (ElkNode)EcoreUtil.copy((EObject)graph);
                    activeView.getCanvas().setLayoutGraph(nodeCopy);
                }
            }
        });
    }

    private static DisCoDebugView findView() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart viewPart = activePage.findView(VIEW_ID);
        if (viewPart instanceof DisCoDebugView) {
            return (DisCoDebugView)viewPart;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.graphCanvas = new DisCoGraphRenderingCanvas((Composite)this.scrolledComposite);
        this.scrolledComposite.setContent((Control)this.graphCanvas);
        toolBarManager.add((IAction)new SelectivePaintToggleAction("elkgraph", "Toggle ElkGraph", "Shows and hides the ElkGraph", this.graphCanvas));
        toolBarManager.add((IAction)new SelectivePaintToggleAction("dcgraph", "Toggle DCGraph", "Shows and hides the DCGraph", this.graphCanvas));
        toolBarManager.add((IAction)new SelectivePaintToggleAction("polyominoes", "Toggle Polyominoes", "Shows and hides polyominoes", this.graphCanvas));
        toolBarManager.add((IContributionItem)new Separator());
        DisCoGraphRenderer renderer = this.graphCanvas.getRenderer();
        ConfigState state = renderer.getState();
        Integer upperBound = state.getMaxDepth();
        upperBound = upperBound == null ? 0 : upperBound - 1;
        toolBarManager.add((IAction)new DropdownIntRangeAction(state, "Show levels ", 0, upperBound, 0, State.LOWER, this.graphCanvas));
        toolBarManager.add((IAction)new DropdownIntRangeAction(state, "to ", 0, upperBound, upperBound, State.UPPER, this.graphCanvas));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new DisCoImageExportAction(this));
    }

    public void setFocus() {
        this.scrolledComposite.setFocus();
    }

    public DisCoGraphRenderingCanvas getCanvas() {
        return this.graphCanvas;
    }
}

