/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.core.options.PortSide;

public class SelfLoopNode {
    private final LNode node;
    private EnumMap<PortSide, SelfLoopNodeSide> nodeSides = new EnumMap(PortSide.class);
    private List<SelfLoopComponent> selfLoopComponents = new ArrayList<SelfLoopComponent>();

    public SelfLoopNode(LNode node) {
        this.node = node;
        this.nodeSides.put(PortSide.NORTH, new SelfLoopNodeSide(PortSide.NORTH));
        this.nodeSides.put(PortSide.EAST, new SelfLoopNodeSide(PortSide.EAST));
        this.nodeSides.put(PortSide.SOUTH, new SelfLoopNodeSide(PortSide.SOUTH));
        this.nodeSides.put(PortSide.WEST, new SelfLoopNodeSide(PortSide.WEST));
    }

    public LNode getNode() {
        return this.node;
    }

    public SelfLoopNodeSide getNodeSide(PortSide side) {
        return this.nodeSides.get(side);
    }

    public Collection<SelfLoopNodeSide> getSides() {
        return this.nodeSides.values();
    }

    public int getNumberOfPorts() {
        int numberOfPorts = 0;
        for (SelfLoopNodeSide side : this.getSides()) {
            numberOfPorts += side.getPorts().size();
        }
        return numberOfPorts;
    }

    public List<SelfLoopComponent> getSelfLoopComponents() {
        return this.selfLoopComponents;
    }

    public void prependPort(SelfLoopPort port, PortSide side) {
        this.nodeSides.get(side).getPorts().add(0, port);
    }

    public void prependPorts(List<SelfLoopPort> ports, PortSide side) {
        for (SelfLoopPort port : ports) {
            this.prependPort(port, side);
        }
    }

    public void appendPort(SelfLoopPort port, PortSide side) {
        this.nodeSides.get(side).getPorts().add(port);
    }

    public void appendPorts(List<SelfLoopPort> ports, PortSide side) {
        for (SelfLoopPort port : ports) {
            this.appendPort(port, side);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.sideSpecificString(builder, PortSide.NORTH);
        this.sideSpecificString(builder, PortSide.EAST);
        this.sideSpecificString(builder, PortSide.SOUTH);
        this.sideSpecificString(builder, PortSide.WEST);
        return builder.toString();
    }

    private void sideSpecificString(StringBuilder builder, PortSide portSide) {
        builder.append(String.valueOf(portSide.toString()) + ": [");
        SelfLoopNodeSide nodeSide = this.nodeSides.get(portSide);
        for (SelfLoopPort port : nodeSide.getPorts()) {
            builder.append(port);
            if (nodeSide.getPorts().indexOf(port) == nodeSide.getPorts().size()) continue;
            builder.append(", ");
        }
        builder.append("] ");
    }
}

