/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class CommentNodeMarginCalculator
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Node margin calculation", 1.0f);
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).forEach(lnode -> this.processComments((LNode)((Object)lnode)));
        monitor.done();
    }

    private void processComments(LNode node) {
        double maxCommentWidth;
        LMargin margin = node.getMargin();
        List topBoxes = (List)node.getProperty(InternalProperties.TOP_COMMENTS);
        List bottomBoxes = (List)node.getProperty(InternalProperties.BOTTOM_COMMENTS);
        if (topBoxes == null && bottomBoxes == null) {
            return;
        }
        double commentCommentSpacing = Spacings.getIndividualOrDefault(node, LayeredOptions.SPACING_COMMENT_COMMENT);
        double commentNodeSpacing = Spacings.getIndividualOrDefault(node, LayeredOptions.SPACING_COMMENT_NODE);
        double topWidth = 0.0;
        if (topBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : topBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                topWidth += commentBox.getSize().x;
            }
            topWidth += commentCommentSpacing * (double)(topBoxes.size() - 1);
            margin.top += maxHeight + commentNodeSpacing;
        }
        double bottomWidth = 0.0;
        if (bottomBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : bottomBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                bottomWidth += commentBox.getSize().x;
            }
            bottomWidth += commentCommentSpacing * (double)(bottomBoxes.size() - 1);
            margin.bottom += maxHeight + commentNodeSpacing;
        }
        if ((maxCommentWidth = Math.max(topWidth, bottomWidth)) > node.getSize().x) {
            double protrusion = (maxCommentWidth - node.getSize().x) / 2.0;
            margin.left = Math.max(margin.left, protrusion);
            margin.right = Math.max(margin.right, protrusion);
        }
    }
}

