/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.dot.transform;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.elk.alg.graphviz.dot.dot.Attribute;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeType;
import org.eclipse.elk.alg.graphviz.dot.dot.DotFactory;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeTarget;
import org.eclipse.elk.alg.graphviz.dot.dot.Graph;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.dot.Node;
import org.eclipse.elk.alg.graphviz.dot.dot.NodeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.Statement;
import org.eclipse.elk.alg.graphviz.dot.dot.Subgraph;
import org.eclipse.elk.alg.graphviz.dot.dot.util.DotSwitch;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.dot.transform.DotExporter;
import org.eclipse.elk.alg.graphviz.dot.transform.IDotTransformationData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DotImporter {
    private static final IProperty<Map<String, ElkNode>> NODE_ID_MAP = new Property("nodeIdMap");
    private static final IProperty<Map<Pair<ElkNode, String>, ElkPort>> PORT_ID_MAP = new Property("portIdMap");
    private static final IProperty<Statement> PROP_STATEMENT = new Property("dotTransformer.statement");
    private static final IProperty<String> PROP_ID = new Property("dotTransformer.name");
    private static final IProperty<Graph> PROP_GRAPH = new Property("dotTransformer.graph");
    private static final IProperty<Float> PROP_DEF_WIDTH = new Property("dotTransformer.defWidth");
    private static final IProperty<Float> PROP_DEF_HEIGHT = new Property("dotTransformer.defHeight");
    private static final float DEF_WIDTH = 10.0f;

    public void transform(IDotTransformationData<GraphvizModel, ElkNode> transData) {
        for (Graph graph : transData.getSourceGraph().getGraphs()) {
            ElkNode parent = ElkGraphUtil.createGraph();
            HashMap nodeIdMap = Maps.newHashMap();
            transData.setProperty(NODE_ID_MAP, nodeIdMap);
            HashMap portIdMap = Maps.newHashMap();
            transData.setProperty(PORT_ID_MAP, portIdMap);
            this.transform((List<Statement>)graph.getStatements(), parent, transData, (IPropertyHolder)new MapPropertyHolder(), (IPropertyHolder)new MapPropertyHolder());
            transData.getTargetGraphs().add(parent);
            parent.setProperty(PROP_GRAPH, (Object)graph);
        }
    }

    public void transferLayout(IDotTransformationData<GraphvizModel, ElkNode> transData) {
        for (ElkNode layoutNode : transData.getTargetGraphs()) {
            this.applyLayout(layoutNode, new KVector(), (Graph)layoutNode.getProperty(PROP_GRAPH));
        }
    }

    private void transform(List<Statement> statements, final ElkNode parent, final IDotTransformationData<GraphvizModel, ElkNode> transData, final IPropertyHolder nodeProps, final IPropertyHolder edgeProps) {
        DotSwitch<Object> statementSwitch = new DotSwitch<Object>(){

            @Override
            public Object caseNodeStatement(NodeStatement statement) {
                DotImporter.this.transformNode(statement, parent, transData, nodeProps);
                return null;
            }

            @Override
            public Object caseEdgeStatement(EdgeStatement statement) {
                DotImporter.this.transformEdge(statement, parent, transData, edgeProps);
                return null;
            }

            @Override
            public Object caseSubgraph(Subgraph subgraph) {
                ElkNode subElkNode = parent;
                if (subgraph.getName() != null && subgraph.getName().startsWith("cluster")) {
                    subElkNode = DotImporter.this.transformNode(subgraph.getName(), parent, transData);
                    if (subElkNode.getProperty(PROP_STATEMENT) != null) {
                        transData.log("Discarding cluster subgraph \"" + subgraph.getName() + "\" since its id is already used.");
                        return null;
                    }
                    subElkNode.copyProperties((IPropertyHolder)parent);
                    subElkNode.setProperty(PROP_STATEMENT, (Object)subgraph);
                }
                MapPropertyHolder subNodeProps = new MapPropertyHolder();
                subNodeProps.copyProperties(nodeProps);
                MapPropertyHolder subEdgeProps = new MapPropertyHolder();
                subEdgeProps.copyProperties(edgeProps);
                DotImporter.this.transform((List<Statement>)subgraph.getStatements(), subElkNode, transData, (IPropertyHolder)subNodeProps, (IPropertyHolder)subEdgeProps);
                return null;
            }

            @Override
            public Object caseAttributeStatement(AttributeStatement statement) {
                switch (statement.getType()) {
                    case GRAPH: {
                        for (Attribute attr : statement.getAttributes()) {
                            this.caseAttribute(attr);
                        }
                        break;
                    }
                    case NODE: {
                        for (Attribute attr : statement.getAttributes()) {
                            DotImporter.this.transformAttribute(nodeProps, attr, transData);
                        }
                        break;
                    }
                    case EDGE: {
                        for (Attribute attr : statement.getAttributes()) {
                            DotImporter.this.transformAttribute(edgeProps, attr, transData);
                        }
                        break;
                    }
                }
                return null;
            }

            @Override
            public Object caseAttribute(Attribute attribute) {
                if ("margin".equals(attribute.getName())) {
                    ElkPadding padding = (ElkPadding)parent.getProperty(CoreOptions.PADDING);
                    if (attribute.getValue().indexOf(44) >= 0) {
                        KVector value = new KVector();
                        try {
                            value.parse(attribute.getValue());
                            padding.setLeft((double)((float)value.x));
                            padding.setRight((double)((float)value.x));
                            padding.setTop((double)((float)value.y));
                            padding.setBottom((double)((float)value.y));
                        }
                        catch (IllegalArgumentException exception) {
                            transData.log("Discarding attribute \"" + attribute.getName() + "\" since its value could not be parsed correctly.");
                        }
                    } else {
                        try {
                            float value = Float.parseFloat(DotImporter.this.trimValue(attribute));
                            padding.setLeft((double)value);
                            padding.setRight((double)value);
                            padding.setTop((double)value);
                            padding.setBottom((double)value);
                        }
                        catch (NumberFormatException exception) {
                            transData.log("Discarding attribute \"" + attribute.getName() + "\" since its value could not be parsed correctly.");
                        }
                    }
                } else {
                    DotImporter.this.transformAttribute((IPropertyHolder)parent, attribute, transData);
                }
                return null;
            }
        };
        for (Statement statement : statements) {
            statementSwitch.doSwitch(statement);
        }
    }

    private void transformAttribute(IPropertyHolder target, Attribute attribute, IDotTransformationData<GraphvizModel, ElkNode> transData) {
        block32: {
            String name = attribute.getName();
            String value = this.trimValue(attribute);
            try {
                if ("layout".equals(name)) {
                    Command command = Command.parse(value);
                    if (command != Command.INVALID) {
                        target.setProperty(CoreOptions.ALGORITHM, (Object)("org.eclipse.elk.algorithm.graphviz." + String.valueOf((Object)command)));
                    } else {
                        target.setProperty(CoreOptions.ALGORITHM, (Object)value);
                    }
                    break block32;
                }
                if ("width".equals(name)) {
                    target.setProperty(PROP_DEF_WIDTH, (Object)Float.valueOf(Float.valueOf(value).floatValue() * 72.0f));
                    break block32;
                }
                if ("height".equals(name)) {
                    target.setProperty(PROP_DEF_HEIGHT, (Object)Float.valueOf(Float.valueOf(value).floatValue() * 72.0f));
                    break block32;
                }
                if ("fixedsize".equals(name)) {
                    Boolean fixedSize = Boolean.valueOf(value);
                    target.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, fixedSize != false ? SizeConstraint.fixed() : EnumSet.of(SizeConstraint.MINIMUM_SIZE));
                    break block32;
                }
                if ("nodesep".equals(name)) {
                    target.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)Double.valueOf(value));
                    break block32;
                }
                if ("pack".equals(name)) {
                    target.setProperty(CoreOptions.SEPARATE_CONNECTED_COMPONENTS, (Object)Boolean.valueOf(value));
                    break block32;
                }
                if ("pad".equals(name)) {
                    if (value.indexOf(44) >= 0) {
                        KVector pad = new KVector();
                        pad.parse(value);
                        ElkPadding padding = new ElkPadding(pad.x / 2.0, pad.y / 2.0);
                        target.setProperty(CoreOptions.PADDING, (Object)padding);
                    } else {
                        target.setProperty(CoreOptions.PADDING, (Object)new ElkPadding((double)Float.valueOf(value).floatValue()));
                    }
                    break block32;
                }
                if ("rankdir".equals(name)) {
                    if (value.equals("TB")) {
                        target.setProperty(CoreOptions.DIRECTION, (Object)Direction.DOWN);
                    } else if (value.equals("BT")) {
                        target.setProperty(CoreOptions.DIRECTION, (Object)Direction.UP);
                    } else if (value.equals("LR")) {
                        target.setProperty(CoreOptions.DIRECTION, (Object)Direction.RIGHT);
                    } else if (value.equals("RL")) {
                        target.setProperty(CoreOptions.DIRECTION, (Object)Direction.LEFT);
                    }
                    break block32;
                }
                if ("splines".equals(name)) {
                    if (value.equals("spline") || value.equals("true")) {
                        target.setProperty(CoreOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
                    } else if (value.equals("polyline") || value.equals("line") || value.equals("false")) {
                        target.setProperty(CoreOptions.EDGE_ROUTING, (Object)EdgeRouting.POLYLINE);
                    } else if (value.equals("ortho")) {
                        target.setProperty(CoreOptions.EDGE_ROUTING, (Object)EdgeRouting.ORTHOGONAL);
                    }
                    break block32;
                }
                if ("start".equals(name)) {
                    if (!value.startsWith("random")) break block32;
                    int random = 0;
                    try {
                        random = Integer.parseInt(value.substring("random".length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    target.setProperty(CoreOptions.RANDOM_SEED, (Object)random);
                    break block32;
                }
                if ("weight".equals(name)) {
                    target.setProperty(CoreOptions.PRIORITY, (Object)((int)Float.parseFloat(value)));
                }
            }
            catch (NumberFormatException exception) {
                transData.log("Discarding attribute " + attribute.getName() + "=" + attribute.getValue() + " since its value could not be parsed correctly.");
            }
            catch (IllegalArgumentException exception) {
                transData.log("Discarding attribute " + attribute.getName() + "=" + attribute.getValue() + " since its value could not be parsed correctly.");
            }
        }
    }

    private void transformNode(NodeStatement statement, ElkNode parent, IDotTransformationData<GraphvizModel, ElkNode> transData, IPropertyHolder defaultProps) {
        ElkNode elknode = this.transformNode(statement.getNode().getName(), parent, transData);
        if (elknode.getProperty(PROP_STATEMENT) != null) {
            transData.log("Discarding node \"" + statement.getNode().getName() + "\" since its id is already used.");
        } else {
            Float defHeight;
            elknode.copyProperties(defaultProps);
            elknode.setProperty(PROP_STATEMENT, (Object)statement);
            Float defWidth = (Float)defaultProps.getProperty(PROP_DEF_WIDTH);
            if (defWidth != null) {
                elknode.setWidth((double)defWidth.floatValue());
            }
            if ((defHeight = (Float)defaultProps.getProperty(PROP_DEF_HEIGHT)) != null) {
                elknode.setHeight((double)defHeight.floatValue());
            }
            for (Attribute attr : statement.getAttributes()) {
                String value = this.trimValue(attr);
                try {
                    if ("label".equals(attr.getName())) {
                        ElkGraphUtil.createLabel((String)value, (ElkGraphElement)elknode);
                        continue;
                    }
                    if ("pos".equals(attr.getName())) {
                        KVector pos = new KVector();
                        pos.parse(value);
                        pos.scale(72.0);
                        elknode.setLocation(pos.x, pos.y);
                        continue;
                    }
                    if ("width".equals(attr.getName())) {
                        elknode.setWidth((double)(Float.parseFloat(value) * 72.0f));
                        continue;
                    }
                    if ("height".equals(attr.getName())) {
                        elknode.setHeight((double)(Float.parseFloat(value) * 72.0f));
                        continue;
                    }
                    this.transformAttribute((IPropertyHolder)elknode, attr, transData);
                }
                catch (NumberFormatException exception) {
                    transData.log("Discarding attribute \"" + attr.getName() + "\" for node \"" + statement.getNode().getName() + "\" since its value could not be parsed correctly.");
                }
                catch (IllegalArgumentException exception) {
                    transData.log("Discarding attribute \"" + attr.getName() + "\" for node \"" + statement.getNode().getName() + "\" since its value could not be parsed correctly.");
                }
            }
        }
    }

    private ElkNode transformNode(String nodeId, ElkNode parent, IDotTransformationData<GraphvizModel, ElkNode> transData) {
        Map nodeIdMap = (Map)transData.getProperty(NODE_ID_MAP);
        ElkNode elknode = (ElkNode)nodeIdMap.get(nodeId);
        if (elknode == null) {
            elknode = ElkGraphUtil.createNode((ElkNode)parent);
            elknode.setWidth(10.0);
            elknode.setHeight(10.0);
            if (nodeId != null) {
                nodeIdMap.put(nodeId, elknode);
                elknode.setProperty(PROP_ID, (Object)nodeId);
            }
        }
        return elknode;
    }

    private ElkPort transformPort(String portId, ElkNode node, IDotTransformationData<GraphvizModel, ElkNode> transData) {
        Pair key;
        Map portIdMap = (Map)transData.getProperty(PORT_ID_MAP);
        ElkPort elkport = (ElkPort)portIdMap.get(key = new Pair((Object)node, (Object)portId));
        if (elkport == null) {
            elkport = ElkGraphUtil.createPort((ElkNode)node);
            if (portId != null) {
                portIdMap.put(key, elkport);
            }
        }
        return elkport;
    }

    private void transformEdge(EdgeStatement statement, ElkNode parent, IDotTransformationData<GraphvizModel, ElkNode> transData, IPropertyHolder defaultProps) {
        String sourceName = statement.getSourceNode().getName();
        ElkNode source = this.transformNode(sourceName, parent, transData);
        ElkPort sourcePort = null;
        if (statement.getSourceNode().getPort() != null) {
            String portName = statement.getSourceNode().getPort().getCompass_pt();
            if (portName == null) {
                portName = statement.getSourceNode().getPort().getName();
            }
            sourcePort = this.transformPort(portName, source, transData);
        }
        ListIterator targetIter = statement.getEdgeTargets().listIterator();
        while (targetIter.hasNext()) {
            ElkNode target;
            String targetName;
            EdgeTarget edgeTarget = (EdgeTarget)targetIter.next();
            ElkEdge elkedge = ElkGraphUtil.createEdge(null);
            if (sourcePort != null) {
                elkedge.getSources().add((Object)sourcePort);
            } else {
                elkedge.getSources().add((Object)source);
            }
            ElkPort targetPort = null;
            Node edgeTargetNode = edgeTarget.getTargetnode();
            if (edgeTargetNode == null) {
                targetName = edgeTarget.getTargetSubgraph().getName();
                target = this.transformNode(targetName, parent, transData);
            } else {
                targetName = edgeTargetNode.getName();
                target = this.transformNode(targetName, parent, transData);
                if (edgeTargetNode.getPort() != null) {
                    String portName = edgeTargetNode.getPort().getCompass_pt();
                    if (portName == null) {
                        portName = edgeTargetNode.getPort().getName();
                    }
                    targetPort = this.transformPort(portName, target, transData);
                }
            }
            if (targetPort != null) {
                elkedge.getTargets().add(targetPort);
            } else {
                elkedge.getTargets().add((Object)target);
            }
            elkedge.copyProperties(defaultProps);
            if (targetIter.previousIndex() == 0) {
                elkedge.setProperty(PROP_STATEMENT, (Object)statement);
            } else {
                EdgeStatement newStatement = DotFactory.eINSTANCE.createEdgeStatement();
                Node sourceNode = DotFactory.eINSTANCE.createNode();
                sourceNode.setName(sourceName);
                newStatement.setSourceNode(sourceNode);
                targetIter.remove();
                newStatement.getEdgeTargets().add((Object)edgeTarget);
                for (Attribute attr : statement.getAttributes()) {
                    newStatement.getAttributes().add((Object)((Attribute)EcoreUtil.copy((EObject)attr)));
                }
                elkedge.setProperty(PROP_STATEMENT, (Object)newStatement);
            }
            for (Attribute attr : statement.getAttributes()) {
                ElkLabel label;
                String value = this.trimValue(attr);
                if ("label".equals(attr.getName())) {
                    label = ElkGraphUtil.createLabel((String)value, (ElkGraphElement)elkedge);
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                    continue;
                }
                if ("headlabel".equals(attr.getName())) {
                    label = ElkGraphUtil.createLabel((String)value, (ElkGraphElement)elkedge);
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                    continue;
                }
                if ("taillabel".equals(attr.getName())) {
                    label = ElkGraphUtil.createLabel((String)value, (ElkGraphElement)elkedge);
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
                    continue;
                }
                this.transformAttribute((IPropertyHolder)elkedge, attr, transData);
            }
            source = target;
            sourceName = targetName;
            sourcePort = targetPort;
        }
    }

    private void applyLayout(ElkNode parent, KVector offset, Graph graph) {
        for (ElkNode elknode : parent.getChildren()) {
            Statement statement = (Statement)elknode.getProperty(PROP_STATEMENT);
            if (statement == null) {
                NodeStatement stm = DotFactory.eINSTANCE.createNodeStatement();
                Node node = DotFactory.eINSTANCE.createNode();
                node.setName((String)elknode.getProperty(PROP_ID));
                stm.setNode(node);
                graph.getStatements().add((Object)stm);
                statement = stm;
            }
            if (statement instanceof NodeStatement) {
                EList<Attribute> attributes = ((NodeStatement)statement).getAttributes();
                this.removeAttributes((List<Attribute>)attributes, "pos");
                double xpos = elknode.getX() + elknode.getWidth() / 2.0 + offset.x;
                double ypos = elknode.getY() + elknode.getHeight() / 2.0 + offset.y;
                String posString = "\"" + Double.toString(xpos) + "," + Double.toString(ypos) + "\"";
                attributes.add(DotExporter.createAttribute("pos", posString));
                this.removeAttributes((List<Attribute>)attributes, "width");
                attributes.add(DotExporter.createAttribute("width", elknode.getWidth() / 72.0));
                this.removeAttributes((List<Attribute>)attributes, "height");
                attributes.add(DotExporter.createAttribute("height", elknode.getHeight() / 72.0));
            } else if (statement instanceof Subgraph) {
                this.applyLayout(elknode, new KVector(offset).add(elknode.getX(), elknode.getY()), graph);
            }
            for (ElkEdge elkedge : ElkGraphUtil.allOutgoingEdges((ElkNode)elknode)) {
                this.applyLayout(elkedge, offset, graph);
            }
        }
        Statement graphStm = (Statement)parent.getProperty(PROP_STATEMENT);
        EList<Statement> statements = graphStm instanceof Subgraph ? ((Subgraph)graphStm).getStatements() : graph.getStatements();
        this.removeGraphAttributes((List<Statement>)statements, "bb");
        String bbString = "\"0,0," + Double.toString(parent.getWidth()) + "," + Double.toString(parent.getHeight()) + "\"";
        statements.add(DotExporter.createAttribute("bb", bbString));
    }

    private void applyLayout(ElkEdge edge, KVector offset, Graph graph) {
        EdgeStatement edgeStatement = (EdgeStatement)edge.getProperty(PROP_STATEMENT);
        if (edgeStatement.eContainer() == null) {
            graph.getStatements().add((Object)edgeStatement);
        }
        EList<Attribute> attributes = edgeStatement.getAttributes();
        this.removeAttributes((List<Attribute>)attributes, "pos");
        if (!edge.getSections().isEmpty()) {
            StringBuilder bendpointString = new StringBuilder("\"");
            KVectorChain vectorChain = ElkUtil.createVectorChain((ElkEdgeSection)((ElkEdgeSection)edge.getSections().get(0)));
            ListIterator chainIter = vectorChain.listIterator();
            while (chainIter.hasNext()) {
                KVector point = ((KVector)chainIter.next()).add(offset);
                bendpointString.append(point.x);
                bendpointString.append(',');
                bendpointString.append(point.y);
                if (!chainIter.hasNext()) continue;
                bendpointString.append(' ');
            }
            bendpointString.append('\"');
            attributes.add(DotExporter.createAttribute("pos", bendpointString.toString()));
        }
        for (ElkLabel label : edge.getLabels()) {
            String attrKey = null;
            switch ((EdgeLabelPlacement)label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT)) {
                case CENTER: {
                    attrKey = "lp";
                    break;
                }
                case HEAD: {
                    attrKey = "head_lp";
                    break;
                }
                case TAIL: {
                    attrKey = "tail_lp";
                }
            }
            if (attrKey == null) continue;
            this.removeAttributes((List<Attribute>)attributes, attrKey);
            double xpos = label.getX() + label.getWidth() / 2.0 + offset.x;
            double ypos = label.getY() + label.getHeight() / 2.0 + offset.y;
            String posString = "\"" + Double.toString(xpos) + "," + Double.toString(ypos) + "\"";
            attributes.add(DotExporter.createAttribute(attrKey, posString));
        }
    }

    private void removeGraphAttributes(List<Statement> statements, String key) {
        ListIterator<Statement> stmIter = statements.listIterator();
        while (stmIter.hasNext()) {
            AttributeStatement attrStatement;
            Statement stm = stmIter.next();
            if (stm instanceof Attribute) {
                if (!key.equals(((Attribute)stm).getName())) continue;
                stmIter.remove();
                continue;
            }
            if (!(stm instanceof AttributeStatement) || (attrStatement = (AttributeStatement)stm).getType() != AttributeType.GRAPH) continue;
            this.removeAttributes((List<Attribute>)attrStatement.getAttributes(), key);
            if (!attrStatement.getAttributes().isEmpty()) continue;
            stmIter.remove();
        }
    }

    private void removeAttributes(List<Attribute> attributes, String key) {
        ListIterator<Attribute> attrIter = attributes.listIterator();
        while (attrIter.hasNext()) {
            Attribute attr = attrIter.next();
            if (!key.equals(attr.getName())) continue;
            attrIter.remove();
        }
    }

    private String trimValue(Attribute attribute) {
        String value = attribute.getValue();
        if (value == null) {
            value = "true";
        } else if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1).trim();
        }
        return value;
    }
}

