/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.internal.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.core.ui.contributor.EditorMenuContributor;
import org.eclipse.egf.core.ui.contributor.IMenuEditorActionBarContributor;
import org.eclipse.egf.core.ui.internal.registry.EditorMenuContributorProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorMenuContributorRegistry
implements IRegistryEventListener {
    private List<EditorMenuContributorProxy> _proxies;
    public static final String EXTENSION_ID = "org.eclipse.egf.core.ui.editor.menu.contributor";
    public static final String INVOKER_ATT_CLASS = "class";

    public List<EditorMenuContributor> createEditorMenuContributors(IMenuEditorActionBarContributor parent) {
        ArrayList<EditorMenuContributor> menus = new ArrayList<EditorMenuContributor>();
        for (EditorMenuContributorProxy proxy : this._proxies) {
            EditorMenuContributor menu = proxy.createEditorMenuContributor(parent);
            if (menu == null) continue;
            menus.add(menu);
        }
        return menus;
    }

    public void disposeEditorMenuContributors(IMenuEditorActionBarContributor parent) {
        if (parent == null) {
            return;
        }
        for (EditorMenuContributorProxy proxy : this._proxies) {
            proxy.disposeEditorMenuContributor(parent);
        }
    }

    public EditorMenuContributorRegistry() {
        this.initialize();
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXTENSION_ID);
    }

    private void initialize() {
        if (this._proxies != null) {
            return;
        }
        this._proxies = new ArrayList<EditorMenuContributorProxy>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_ID);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.register(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void register(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        EditorMenuContributorProxy proxy = EditorMenuContributorProxy.createProxy(element);
        if (proxy != null) {
            this._proxies.add(proxy);
        }
    }

    public void added(IExtension[] extensions) {
        if (extensions == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.register(element);
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            Iterator<EditorMenuContributorProxy> it = this._proxies.iterator();
            while (it.hasNext()) {
                EditorMenuContributorProxy proxy = it.next();
                if (!proxy.originatesFrom(extensions[i])) continue;
                proxy.dispose();
                it.remove();
            }
            ++i;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void dispose() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        for (EditorMenuContributorProxy proxy : this._proxies) {
            proxy.dispose();
        }
        this._proxies = null;
    }
}

