/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class TaskBundleAdapter
extends EContentAdapter {
    private Resource _resource;
    private Shell _shell;

    public TaskBundleAdapter(Resource resource) {
        this._shell = EGFModelEditorPlugin.getActiveWorkbenchShell();
        this._resource = resource;
    }

    public TaskBundleAdapter(Resource resource, IWorkbenchPartSite site) {
        this._shell = site != null ? site.getShell() : EGFModelEditorPlugin.getActiveWorkbenchShell();
        this._resource = resource;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNewValue() != null && notification.getNewValue() instanceof Task) {
            this.handleTaskNotification(notification);
        }
    }

    private void handleTaskNotification(Notification notification) {
        if (notification.getEventType() == 3) {
            Task task = (Task)notification.getNewValue();
            Resource resource = task.eResource();
            if (resource != this._resource || ((ResourceImpl)resource).isLoading()) {
                return;
            }
            if (!(resource instanceof IPlatformFcoreProvider)) {
                return;
            }
            IPlatformFcore fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore();
            if (fcore == null || fcore.getPlatformBundle().getProject() == null) {
                return;
            }
            for (Object object : this._resource.getContents()) {
                if (!(object instanceof Task) || object == task) continue;
                return;
            }
            ConvertProjectOperation operation = new ConvertProjectOperation(fcore.getPlatformBundle().getProject(), true, true){

                public List<String> addDependencies() {
                    ArrayList<String> dependencies = new ArrayList<String>(1);
                    dependencies.add("org.eclipse.egf.model.ftask");
                    return dependencies;
                }

                public List<String> addSourceFolders() {
                    ArrayList<String> sourceFolders = new ArrayList<String>(1);
                    sourceFolders.add("src");
                    return sourceFolders;
                }
            };
            try {
                new ProgressMonitorDialog(this._shell).run(false, false, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)e);
            }
        }
    }
}

